/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpledb.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.simpledb.model.DeletableItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BatchDeleteAttributesRequest
extends AmazonWebServiceRequest {
    private String domainName;
    private List<DeletableItem> items;

    public BatchDeleteAttributesRequest() {
    }

    public BatchDeleteAttributesRequest(String domainName, List<DeletableItem> items) {
        this.domainName = domainName;
        this.items = items;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public void setDomainName(String domainName) {
        this.domainName = domainName;
    }

    public BatchDeleteAttributesRequest withDomainName(String domainName) {
        this.domainName = domainName;
        return this;
    }

    public List<DeletableItem> getItems() {
        if (this.items == null) {
            this.items = new ArrayList<DeletableItem>();
        }
        return this.items;
    }

    public void setItems(Collection<DeletableItem> items) {
        ArrayList<DeletableItem> itemsCopy = new ArrayList<DeletableItem>();
        if (items != null) {
            itemsCopy.addAll(items);
        }
        this.items = itemsCopy;
    }

    public BatchDeleteAttributesRequest withItems(DeletableItem ... items) {
        for (DeletableItem value : items) {
            this.getItems().add(value);
        }
        return this;
    }

    public BatchDeleteAttributesRequest withItems(Collection<DeletableItem> items) {
        ArrayList<DeletableItem> itemsCopy = new ArrayList<DeletableItem>();
        if (items != null) {
            itemsCopy.addAll(items);
        }
        this.items = itemsCopy;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        sb.append("DomainName: " + this.domainName + ", ");
        sb.append("Items: " + this.items + ", ");
        sb.append("}");
        return sb.toString();
    }
}

