/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.callgraph.impl;

import java.awt.Image;
import java.util.ArrayList;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import org.netbeans.modules.cnd.callgraph.api.Call;
import org.netbeans.modules.cnd.callgraph.impl.CallChildren;
import org.netbeans.modules.cnd.callgraph.impl.CallGraphState;
import org.netbeans.modules.cnd.callgraph.impl.GoToReferenceAction;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class CallNode
extends AbstractNode {
    private final Call object;
    private final CallGraphState model;
    private final boolean isCalls;
    private volatile Image image;
    private static final RequestProcessor RP = new RequestProcessor("Call Graph icon updater", 1);
    static Image downBadge = ImageUtilities.loadImage((String)"org/netbeans/modules/cnd/callgraph/resources/down_20.png");
    private static Image upBadge = ImageUtilities.loadImage((String)"org/netbeans/modules/cnd/callgraph/resources/up_8.png");
    private static Image emptyBadge = ImageUtilities.loadImage((String)"org/netbeans/modules/cnd/callgraph/resources/empty_20.png");

    public CallNode(Call element, CallGraphState model, boolean isCalls) {
        super((Children)new CallChildren(element, model, isCalls));
        this.object = element;
        this.model = model;
        this.isCalls = isCalls;
        if (isCalls) {
            this.setName(element.getCallee().getName());
        } else {
            this.setName(element.getCaller().getName());
        }
        ((CallChildren)this.getChildren()).setParent((Node)this);
        model.addCallToScene(element);
    }

    public String getShortDescription() {
        if (this.isCalls) {
            return this.object.getCallee().getDescription();
        }
        return this.object.getCaller().getDescription();
    }

    public String getHtmlDisplayName() {
        String displayName = this.isCalls ? this.object.getCallee().getHtmlDisplayName() : this.object.getCaller().getHtmlDisplayName();
        if (((CallChildren)this.getChildren()).isRecusion()) {
            return displayName + NbBundle.getMessage(CallNode.class, (String)"CTL_Recuesion");
        }
        return displayName;
    }

    public Image getIcon(int param) {
        Image res = this.image;
        if (res != null) {
            return res;
        }
        RP.post(new Runnable(){

            @Override
            public void run() {
                if (SwingUtilities.isEventDispatchThread()) {
                    CallNode.this.fireIconChange();
                    CallNode.this.fireOpenedIconChange();
                } else {
                    Image icon = CallNode.this.isCalls ? CallNode.this.object.getCallee().getIcon() : CallNode.this.object.getCaller().getIcon();
                    CallNode.this.image = CallNode.this.mergeBadge(icon);
                    SwingUtilities.invokeLater(this);
                }
            }
        });
        res = super.getIcon(param);
        return this.mergeBadge(res);
    }

    private Image mergeBadge(Image original) {
        if (this.isCalls) {
            return ImageUtilities.mergeImages((Image)original, (Image)downBadge, (int)0, (int)0);
        }
        Image res = ImageUtilities.mergeImages((Image)emptyBadge, (Image)original, (int)4, (int)0);
        return ImageUtilities.mergeImages((Image)res, (Image)upBadge, (int)0, (int)0);
    }

    Call getCall() {
        return this.object;
    }

    public Image getOpenedIcon(int param) {
        return this.getIcon(param);
    }

    public Action getPreferredAction() {
        return new GoToReferenceAction(this.object);
    }

    public Action[] getActions(boolean context) {
        ArrayList<Action> actions = new ArrayList<Action>();
        Action action = this.getPreferredAction();
        if (action != null) {
            actions.add(action);
            actions.add(new GoToReferenceAction(this.object.getCaller(), 1));
            actions.add(new GoToReferenceAction(this.object.getCallee(), 2));
            actions.add(null);
        }
        for (Action a : this.model.getActions()) {
            actions.add(a);
        }
        return actions.toArray(new Action[actions.size()]);
    }
}

