/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2me.project.wizard;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.Collator;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeSet;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.plaf.UIResource;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.platform.PlatformsCustomizer;
import org.netbeans.modules.j2me.project.J2MEProjectUtils;
import org.netbeans.modules.j2me.project.ui.customizer.J2MEProjectProperties;
import org.netbeans.modules.j2me.project.ui.customizer.J2MERunPanel;
import org.netbeans.modules.j2me.project.wizard.J2MEProjectWizardIterator;
import org.netbeans.modules.j2me.project.wizard.PanelConfigureProject;
import org.netbeans.modules.j2me.project.wizard.SettingsPanel;
import org.netbeans.modules.java.api.common.ui.PlatformUiSupport;
import org.netbeans.modules.mobility.cldcplatform.J2MEPlatform;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.WizardValidationException;
import org.openide.awt.Mnemonics;
import org.openide.modules.SpecificationVersion;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.Parameters;
import org.openide.util.WeakListeners;

public class PlatformDevicesPanel
extends SettingsPanel {
    private final J2MEProjectWizardIterator.WizardType type;
    private final PanelConfigureProject panel;
    private ComboBoxModel platformsModel;
    private DefaultComboBoxModel devicesModel;
    private JavaPlatformChangeListener jpcl;
    private ButtonGroup configurationsGroup;
    private ButtonGroup profilesGroup;
    private final HashMap<String, J2MEPlatform.J2MEProfile> name2profile = new HashMap();
    private int firstConfigurationWidth = -1;
    private ArrayList<JCheckBox> optionalPackages;
    private HashMap<J2MEPlatform.Device, List<String>> devices2packages;
    private J2MEProjectProperties props;
    private Map<String, Map<String, String>> configs;
    private J2MEProjectProperties.DataSource[] data;
    private boolean wizard;
    private boolean reloadOptionalPackages = true;
    private JButton btnManagePlatforms;
    private JComboBox configCombo;
    private JButton configDel;
    private JLabel configLabel;
    private JButton configNew;
    private JPanel configPanel;
    private JSeparator configSeparator;
    private JPanel configurationPanel;
    private JComboBox deviceComboBox;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JComboBox jdkComboBox;
    private JLabel lblConfiguration;
    private JLabel lblDevice;
    private JLabel lblJDKPath;
    private JLabel lblOptionalPackages;
    private JLabel lblPlatform;
    private JLabel lblProfile;
    private JPanel optionalPackagesPanel;
    private JComboBox platformComboBox;
    private JPanel profilePanel;

    public PlatformDevicesPanel(J2MEProjectProperties properties) {
        this.props = properties;
        this.panel = null;
        this.type = null;
        this.initializeCustomizer();
    }

    PlatformDevicesPanel(PanelConfigureProject panel, J2MEProjectWizardIterator.WizardType type) {
        this.panel = panel;
        this.type = type;
        this.initializeWizard();
    }

    private void initializeWizard() {
        this.wizard = true;
        this.preInitComponents();
        this.initComponents();
        this.postInitComponents();
        this.configs = null;
        this.data = null;
        this.configPanel.setVisible(false);
        this.configLabel.setVisible(false);
        this.configCombo.setVisible(false);
        this.configSeparator.setVisible(false);
    }

    private void initializeCustomizer() {
        this.wizard = false;
        this.preInitComponents();
        this.initComponents();
        this.postInitComponents();
        this.configs = this.props.RUN_CONFIGS;
        this.configCombo.setRenderer(new ConfigListCellRenderer());
        this.configCombo.setModel(this.props.CONFIGS_MODEL);
        this.data = new J2MEProjectProperties.DataSource[]{new MultiCheckboxDataSource("platform.apis", this.optionalPackages, this.configCombo, this.configs), new J2MEProjectProperties.ComboDataSource("platform.device", this.deviceComboBox, this.configCombo, this.configs), new J2MEProjectProperties.ButtonGroupDataSource("platform.configuration", this.configurationsGroup, this.configCombo, this.configs), new J2MEProjectProperties.ButtonGroupDataSource("platform.profile", this.profilesGroup, this.configCombo, this.configs)};
        this.configChanged(this.props.activeConfig);
    }

    private void preInitComponents() {
        if (this.wizard) {
            this.platformsModel = J2MEProjectUtils.createPlatformComboBoxModel();
        } else {
            this.props.reloadJ2MEPlatforms();
            this.platformsModel = this.props.J2ME_PLATFORM_MODEL;
            if (this.platformsModel.getSize() == 0) {
                String platformActive = this.props.getEvaluator().getProperty("platform.active");
                this.platformsModel = new DefaultComboBoxModel<String>(new String[]{NbBundle.getMessage(PlatformDevicesPanel.class, (String)"ERROR_MissingJ2MEPlatform", (Object)platformActive)});
            }
        }
        this.devicesModel = new DefaultComboBoxModel();
        this.configurationsGroup = J2MEProjectUtils.getConfigurationsButtonGroup();
        this.profilesGroup = J2MEProjectUtils.getProfilesButtonGroup();
        this.optionalPackages = J2MEProjectUtils.getOptionalPackages();
        this.devices2packages = J2MEProjectUtils.getOptionalPackagesForDevices();
    }

    private void postInitComponents() {
        if (this.panel != null && this.type != null) {
            this.lblOptionalPackages.setVisible(false);
            this.jScrollPane1.setVisible(false);
        }
        this.initJdkPlatform();
        this.initPlatformAndDevices();
        this.jpcl = new JavaPlatformChangeListener();
        JavaPlatformManager.getDefault().addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.jpcl, (Object)JavaPlatformManager.getDefault()));
    }

    private void initJdkPlatform() {
        this.jdkComboBox.setRenderer(J2MEProjectUtils.createJDKPlatformListCellRenderer());
        ComboBoxModel jdkCompoboxModel = null;
        if (this.wizard) {
            jdkCompoboxModel = J2MEProjectUtils.createJDKPlatformComboBoxModel();
        } else {
            jdkCompoboxModel = this.props.JDK_PLATOFRM_MODEL;
            if (jdkCompoboxModel.getSize() == 1) {
                jdkCompoboxModel.setSelectedItem(jdkCompoboxModel.getElementAt(0));
            }
        }
        this.jdkComboBox.setModel(jdkCompoboxModel);
    }

    private void initPlatformAndDevices() {
        J2MEPlatform platform = this.getPlatform();
        this.platformComboBox.setModel(this.platformsModel);
        if (!UIManager.getLookAndFeel().getClass().getName().toUpperCase().contains("AQUA")) {
            this.platformComboBox.putClientProperty("JComboBox.isTableCellEditor", Boolean.TRUE);
            this.deviceComboBox.putClientProperty("JComboBox.isTableCellEditor", Boolean.TRUE);
        }
        this.initDeviceConfigurations();
        this.initDeviceProfiles();
        this.initOptionalPackages();
        if (platform == null) {
            if (this.platformComboBox.getItemCount() > 0) {
                this.platformComboBox.setSelectedIndex(0);
            }
        } else {
            boolean found = false;
            for (int i = 0; i < this.platformComboBox.getItemCount(); ++i) {
                J2MEPlatform platf;
                J2MEPlatform j2MEPlatform = platf = this.platformComboBox.getItemAt(i) instanceof J2MEPlatform ? (J2MEPlatform)this.platformComboBox.getItemAt(i) : null;
                if (platf == null || !platf.getDisplayName().equals(platform.getDisplayName())) continue;
                this.platformComboBox.setSelectedIndex(i);
                found = true;
                break;
            }
            if (!found && this.platformComboBox.getItemCount() > 0) {
                this.platformComboBox.setSelectedIndex(0);
            }
        }
        this.deviceComboBox.setModel(this.devicesModel);
    }

    private void initDeviceConfigurations() {
        this.configurationPanel.removeAll();
        Enumeration<AbstractButton> configurations = this.configurationsGroup.getElements();
        while (configurations.hasMoreElements()) {
            JRadioButton btn = (JRadioButton)configurations.nextElement();
            this.configurationPanel.add(btn);
            Dimension preferredSize = btn.getPreferredSize();
            if (this.firstConfigurationWidth == -1) {
                this.firstConfigurationWidth = preferredSize.width + 30;
                btn.setPreferredSize(new Dimension(this.firstConfigurationWidth, preferredSize.height));
                continue;
            }
            btn.setPreferredSize(new Dimension(this.firstConfigurationWidth, preferredSize.height));
        }
    }

    private void initDeviceProfiles() {
        this.profilePanel.removeAll();
        Enumeration<AbstractButton> profiles = this.profilesGroup.getElements();
        while (profiles.hasMoreElements()) {
            JRadioButton btn = (JRadioButton)profiles.nextElement();
            btn.setPreferredSize(new Dimension(this.firstConfigurationWidth, btn.getPreferredSize().height));
            this.profilePanel.add(btn);
        }
    }

    private void initOptionalPackages() {
        if (this.reloadOptionalPackages) {
            this.optionalPackagesPanel.removeAll();
            for (JCheckBox cb : this.optionalPackages) {
                this.optionalPackagesPanel.add((Component)cb, new GridBagConstraints(0, -1, 0, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
            }
            this.reloadOptionalPackages = false;
        }
        if (!(this.wizard || this.platformComboBox.getSelectedItem() != null && this.platformComboBox.getItemAt(0) instanceof J2MEPlatform)) {
            this.optionalPackagesPanel.setVisible(false);
        } else {
            this.optionalPackagesPanel.setVisible(true);
        }
    }

    private void initComponents() {
        this.lblPlatform = new JLabel();
        this.platformComboBox = new JComboBox();
        this.btnManagePlatforms = new JButton();
        this.configLabel = new JLabel();
        this.configCombo = new JComboBox();
        this.configPanel = new JPanel();
        this.configNew = new JButton();
        this.configDel = new JButton();
        this.configSeparator = new JSeparator();
        this.lblDevice = new JLabel();
        this.deviceComboBox = new JComboBox();
        this.jSeparator1 = new JSeparator();
        this.lblConfiguration = new JLabel();
        this.configurationPanel = new JPanel();
        this.lblProfile = new JLabel();
        this.profilePanel = new JPanel();
        this.lblOptionalPackages = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.optionalPackagesPanel = new JPanel();
        this.lblJDKPath = new JLabel();
        this.jdkComboBox = new JComboBox();
        this.setLayout(new GridBagLayout());
        this.lblPlatform.setLabelFor(this.platformComboBox);
        Mnemonics.setLocalizedText((JLabel)this.lblPlatform, (String)NbBundle.getMessage(PlatformDevicesPanel.class, (String)"LBL_PanelOptions_Platform_ComboBox"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 512;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.add((Component)this.lblPlatform, gridBagConstraints);
        this.lblPlatform.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PlatformDevicesPanel.class, (String)"ACSN_labelPlatform"));
        this.lblPlatform.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PlatformDevicesPanel.class, (String)"ACSD_labelPlatform"));
        this.platformComboBox.setModel(this.platformsModel);
        this.platformComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PlatformDevicesPanel.this.platformComboBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 512;
        gridBagConstraints.weightx = 0.1;
        this.add((Component)this.platformComboBox, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.btnManagePlatforms, (String)NbBundle.getMessage(PlatformDevicesPanel.class, (String)"LBL_PanelOptions_Manage_Button"));
        this.btnManagePlatforms.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PlatformDevicesPanel.this.btnManagePlatformsActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 768;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.add((Component)this.btnManagePlatforms, gridBagConstraints);
        this.btnManagePlatforms.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PlatformDevicesPanel.class, (String)"ACSN_buttonManagePlatforms"));
        this.btnManagePlatforms.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PlatformDevicesPanel.class, (String)"ACSD_buttonManagePlatforms"));
        Mnemonics.setLocalizedText((JLabel)this.configLabel, (String)MessageFormat.format(ResourceBundle.getBundle("org/netbeans/modules/j2me/project/ui/customizer/Bundle").getString("J2MERunPanel.configLabel.text"), new Object[0]));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(2, 0, 2, 0);
        this.add((Component)this.configLabel, gridBagConstraints);
        this.configCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"<default>"}));
        this.configCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PlatformDevicesPanel.this.configComboActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.configCombo, gridBagConstraints);
        this.configPanel.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.configNew, (String)MessageFormat.format(ResourceBundle.getBundle("org/netbeans/modules/j2me/project/ui/customizer/Bundle").getString("J2MERunPanel.configNew.text"), new Object[0]));
        this.configNew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PlatformDevicesPanel.this.configNewActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 6, 2, 0);
        this.configPanel.add((Component)this.configNew, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.configDel, (String)MessageFormat.format(ResourceBundle.getBundle("org/netbeans/modules/j2me/project/ui/customizer/Bundle").getString("J2MERunPanel.configDel.text"), new Object[0]));
        this.configDel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PlatformDevicesPanel.this.configDelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 6, 2, 0);
        this.configPanel.add((Component)this.configDel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 768;
        this.add((Component)this.configPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(12, 0, 12, 0);
        this.add((Component)this.configSeparator, gridBagConstraints);
        this.lblDevice.setLabelFor(this.deviceComboBox);
        Mnemonics.setLocalizedText((JLabel)this.lblDevice, (String)NbBundle.getMessage(PlatformDevicesPanel.class, (String)"LBL_PanelOptions_Device_ComboBox"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 512;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.add((Component)this.lblDevice, gridBagConstraints);
        this.lblDevice.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PlatformDevicesPanel.class, (String)"ACSN_labelDevice"));
        this.lblDevice.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PlatformDevicesPanel.class, (String)"ACSD_labelDevice"));
        this.deviceComboBox.setModel(this.devicesModel);
        this.deviceComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PlatformDevicesPanel.this.deviceComboBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 512;
        this.add((Component)this.deviceComboBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(12, 0, 13, 0);
        this.add((Component)this.jSeparator1, gridBagConstraints);
        this.lblConfiguration.setLabelFor(this.configurationPanel);
        Mnemonics.setLocalizedText((JLabel)this.lblConfiguration, (String)NbBundle.getMessage(PlatformDevicesPanel.class, (String)"LBL_PanelOptions_Configuration_Label"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 512;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.lblConfiguration, gridBagConstraints);
        this.lblConfiguration.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PlatformDevicesPanel.class, (String)"ACSN_labelConfiguration"));
        this.lblConfiguration.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PlatformDevicesPanel.class, (String)"ACSD_labelConfiguration"));
        this.configurationPanel.setLayout(new GridLayout(1, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 512;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 5, 0, 0);
        this.add((Component)this.configurationPanel, gridBagConstraints);
        this.lblProfile.setLabelFor(this.profilePanel);
        Mnemonics.setLocalizedText((JLabel)this.lblProfile, (String)NbBundle.getMessage(PlatformDevicesPanel.class, (String)"LBL_PanelOptions_Profile_Label"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 512;
        gridBagConstraints.insets = new Insets(12, 0, 12, 0);
        this.add((Component)this.lblProfile, gridBagConstraints);
        this.lblProfile.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PlatformDevicesPanel.class, (String)"ACSN_labelProfile"));
        this.lblProfile.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PlatformDevicesPanel.class, (String)"ACSD_labelProfile"));
        this.profilePanel.setLayout(new GridLayout(1, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 512;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 5, 12, 0);
        this.add((Component)this.profilePanel, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.lblOptionalPackages, (String)NbBundle.getMessage(PlatformDevicesPanel.class, (String)"J2MEPlatformPanel.lblOptionalPackages.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 512;
        this.add((Component)this.lblOptionalPackages, gridBagConstraints);
        this.optionalPackagesPanel.setLayout(new GridBagLayout());
        this.jScrollPane1.setViewportView(this.optionalPackagesPanel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 512;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        this.lblJDKPath.setLabelFor(this.jdkComboBox);
        Mnemonics.setLocalizedText((JLabel)this.lblJDKPath, (String)NbBundle.getMessage(PlatformDevicesPanel.class, (String)"LBL_PanelOptions_JDkPath_ComboBox"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 512;
        this.add((Component)this.lblJDKPath, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 512;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(0, 0, 10, 0);
        this.add((Component)this.jdkComboBox, gridBagConstraints);
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PlatformDevicesPanel.class, (String)"ACSN_PanelOptionsVisual"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PlatformDevicesPanel.class, (String)"ACSD_PanelOptionsVisual"));
    }

    private void deviceComboBoxActionPerformed(ActionEvent evt) {
        this.updateConfigsAndProfiles();
        if (!this.wizard) {
            this.displayCorrectOptionalPackages();
        }
    }

    private void platformComboBoxActionPerformed(ActionEvent evt) {
        this.updateDevices();
    }

    private void btnManagePlatformsActionPerformed(ActionEvent evt) {
        PlatformsCustomizer.showCustomizer((JavaPlatform)this.getPlatform());
        this.preInitComponents();
        this.initJdkPlatform();
        this.initPlatformAndDevices();
        if (this.panel != null) {
            this.panel.fireChangeEvent();
        }
    }

    private void configComboActionPerformed(ActionEvent evt) {
        String config = (String)this.configCombo.getSelectedItem();
        if (config.length() == 0) {
            config = null;
        }
        this.configChanged(config);
        this.props.activeConfig = config;
    }

    private void configNewActionPerformed(ActionEvent evt) {
        this.createNewConfiguration();
    }

    private void configDelActionPerformed(ActionEvent evt) {
        String config = (String)this.configCombo.getSelectedItem();
        assert (config != null);
        this.configs.put(config, null);
        this.configChanged(null);
        this.props.activeConfig = null;
    }

    private void configChanged(String activeConfig) {
        this.props.CONFIGS_MODEL = new DefaultComboBoxModel();
        this.props.CONFIGS_MODEL.addElement("");
        TreeSet<String> alphaConfigs = new TreeSet<String>(new Comparator<String>(){
            Collator coll = Collator.getInstance();

            @Override
            public int compare(String s1, String s2) {
                return this.coll.compare(this.label(s1), this.label(s2));
            }

            private String label(String c) {
                Map m = (Map)PlatformDevicesPanel.this.configs.get(c);
                String label = (String)m.get("$label");
                return label != null ? label : c;
            }
        });
        for (Map.Entry<String, Map<String, String>> entry : this.configs.entrySet()) {
            String config = entry.getKey();
            if (config == null || entry.getValue() == null) continue;
            alphaConfigs.add(config);
        }
        for (String c : alphaConfigs) {
            this.props.CONFIGS_MODEL.addElement(c);
        }
        this.configCombo.setModel(this.props.CONFIGS_MODEL);
        this.configCombo.setSelectedItem(activeConfig != null ? activeConfig : "");
        Map<String, String> m = this.configs.get(activeConfig);
        if (m != null) {
            for (J2MEProjectProperties.DataSource ds : this.data) {
                ds.update(activeConfig);
            }
        }
        this.configDel.setEnabled(activeConfig != null);
    }

    private void createNewConfiguration() {
        NotifyDescriptor.InputLine d = new NotifyDescriptor.InputLine(NbBundle.getMessage(J2MERunPanel.class, (String)"J2MERunPanel.input.prompt"), NbBundle.getMessage(J2MERunPanel.class, (String)"J2MERunPanel.input.title"));
        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)d) != NotifyDescriptor.OK_OPTION) {
            return;
        }
        String name = d.getInputText();
        String config = name.replaceAll("[^a-zA-Z0-9_.-]", "_");
        if (config.trim().length() == 0) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(J2MERunPanel.class, (String)"J2MERunPanel.input.empty", (Object)config), 2));
            return;
        }
        if (this.configs.get(config) != null) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(J2MERunPanel.class, (String)"J2MERunPanel.input.duplicate", (Object)config), 2));
            return;
        }
        HashMap<String, String> m = new HashMap<String, String>();
        if (!name.equals(config)) {
            m.put("$label", name);
        }
        this.configs.put(config, m);
        this.configChanged(config);
        this.props.activeConfig = config;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (this.configs != null) {
            this.configChanged(this.props.activeConfig);
        }
    }

    private synchronized void updateDevices() {
        boolean embedded = false;
        J2MEPlatform platform = this.getPlatform();
        Object deviceName = null;
        this.devicesModel.setSelectedItem(null);
        this.devicesModel.removeAllElements();
        if (platform != null) {
            int j;
            J2MEPlatform.J2MEProfile[] p;
            J2MEPlatform.Device[] devices;
            J2MEPlatform.Device select = null;
            for (J2MEPlatform.Device device : devices = platform.getDevices()) {
                p = device.getProfiles();
                for (j = 0; j < p.length; ++j) {
                    if (embedded && (!p[j].isDefault() || !"profile".equals(p[j].getType()))) continue;
                    this.devicesModel.addElement(device);
                    if (device.getName().equals(deviceName)) {
                        this.devicesModel.setSelectedItem(device);
                    }
                    if (select == null) {
                        select = device;
                    }
                    j = p.length;
                }
            }
            if (embedded && select == null) {
                for (J2MEPlatform.Device device : devices) {
                    p = device.getProfiles();
                    for (j = 0; j < p.length; ++j) {
                        if (!p[j].isDefault() || !"profile".equals(p[j].getType()) || !p[j].getName().equals("IMP")) continue;
                        this.devicesModel.addElement(device);
                        if (device.getName().equals(deviceName)) {
                            this.devicesModel.setSelectedItem(device);
                        }
                        if (select == null) {
                            select = device;
                        }
                        j = p.length;
                    }
                }
            }
            if (this.devicesModel.getSelectedItem() == null && select != null) {
                this.devicesModel.setSelectedItem(select);
            }
        }
        this.updateConfigsAndProfiles();
    }

    private synchronized void updateConfigsAndProfiles() {
        J2MEPlatform.Device device = this.getDevice();
        String defCfg = null;
        String defProf = null;
        this.name2profile.clear();
        if (device != null) {
            J2MEPlatform.J2MEProfile[] p;
            for (J2MEPlatform.J2MEProfile p1 : p = device.getProfiles()) {
                this.name2profile.put(p1.toString(), p1);
                if (!p1.isDefault()) continue;
                if ("configuration".equals(p1.getType())) {
                    defCfg = p1.toString();
                    continue;
                }
                if (!"profile".equals(p1.getType())) continue;
                defProf = p1.toString();
            }
        }
        this.updateGroup(this.configurationsGroup, this.name2profile.keySet(), defCfg);
        this.updateGroup(this.profilesGroup, this.name2profile.keySet(), defProf);
    }

    private void displayCorrectOptionalPackages() {
        J2MEPlatform.Device device = this.getDevice();
        if (device != null) {
            List<String> deviceOpts = this.devices2packages.get(device);
            for (JCheckBox cb : this.optionalPackages) {
                if (deviceOpts.contains(cb.getActionCommand())) {
                    cb.setVisible(true);
                    continue;
                }
                cb.setSelected(false);
                cb.setVisible(false);
            }
        }
    }

    private void updateGroup(ButtonGroup grp, Set<String> enabled, String def) {
        Enumeration<AbstractButton> en = grp.getElements();
        AbstractButton defB = null;
        while (en.hasMoreElements()) {
            JRadioButton btn = (JRadioButton)en.nextElement();
            String name = btn.getActionCommand();
            btn.setEnabled(enabled.contains(name));
            if (def == null || !def.equals(name)) continue;
            defB = btn;
        }
        ButtonModel m = grp.getSelection();
        if (!(m != null && m.isEnabled() || defB == null)) {
            grp.setSelected(defB.getModel(), true);
        }
    }

    private J2MEPlatform getPlatform() {
        return this.platformComboBox.getSelectedItem() instanceof J2MEPlatform ? (J2MEPlatform)this.platformComboBox.getSelectedItem() : null;
    }

    private J2MEPlatform.Device getDevice() {
        return (J2MEPlatform.Device)this.devicesModel.getSelectedItem();
    }

    private String getConfiguration() {
        ButtonModel m = this.configurationsGroup.getSelection();
        return m == null ? "" : m.getActionCommand();
    }

    private String getProfile() {
        ButtonModel m = this.profilesGroup.getSelection();
        return m == null ? "" : m.getActionCommand();
    }

    private JavaPlatform getJdkPlatform() {
        return PlatformUiSupport.getPlatform((Object)this.jdkComboBox.getSelectedItem());
    }

    private void setBottomPanelAreaVisible(boolean visible) {
        this.jSeparator1.setVisible(visible);
        this.lblDevice.setVisible(visible);
        this.lblConfiguration.setVisible(visible);
        this.lblProfile.setVisible(visible);
        this.deviceComboBox.setVisible(visible);
        this.configurationPanel.setVisible(visible);
        this.profilePanel.setVisible(visible);
    }

    @Override
    boolean valid(WizardDescriptor settings) {
        JavaPlatform platform;
        if (this.getPlatform() == null) {
            this.setBottomPanelAreaVisible(false);
            settings.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(PlatformDevicesPanel.class, (String)"WARN_PanelOptionsVisual.noMEPlatform"));
            return false;
        }
        if (this.jdkComboBox.getSelectedItem() == null) {
            this.setBottomPanelAreaVisible(false);
            settings.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(PlatformDevicesPanel.class, (String)"WARN_PanelOptionsVisual.noSEPlatform"));
            return false;
        }
        Object item = this.jdkComboBox.getSelectedItem();
        if (item != null && (platform = PlatformUiSupport.getPlatform((Object)item)).getSpecification().getVersion().compareTo((Object)new SpecificationVersion("1.8")) < 0) {
            settings.putProperty("WizardPanel_warningMessage", (Object)NbBundle.getMessage(PlatformDevicesPanel.class, (String)"WARN_PanelOptionsVisual.missingJDK"));
        }
        this.setBottomPanelAreaVisible(true);
        return true;
    }

    @Override
    synchronized void read(WizardDescriptor d) {
        JRadioButton btn;
        J2MEPlatform itemAt;
        int i;
        String profile;
        String configuration;
        String platform = d.getProperty("platform") != null ? ((J2MEPlatform)d.getProperty("platform")).getName() : this.getPreferences().get("platform", null);
        String device = (String)d.getProperty("device");
        if (device == null) {
            device = this.getPreferences().get("device", null);
        }
        if ((configuration = (String)d.getProperty("config")) == null) {
            configuration = this.getPreferences().get("config", null);
        }
        if ((profile = (String)d.getProperty("profile")) == null) {
            profile = this.getPreferences().get("profile", null);
        }
        JavaPlatform jdkPlatform = (JavaPlatform)d.getProperty("jdk");
        if (platform != null) {
            for (i = 0; i < this.platformComboBox.getItemCount(); ++i) {
                itemAt = (J2MEPlatform)this.platformComboBox.getItemAt(i);
                if (!platform.equals(itemAt.getName())) continue;
                this.platformComboBox.setSelectedItem(itemAt);
            }
        }
        if (device != null) {
            for (i = 0; i < this.deviceComboBox.getItemCount(); ++i) {
                itemAt = (J2MEPlatform.Device)this.deviceComboBox.getItemAt(i);
                if (!device.equals(itemAt.getName())) continue;
                this.deviceComboBox.setSelectedItem(itemAt);
            }
        }
        if (configuration != null) {
            Enumeration<AbstractButton> configurations = this.configurationsGroup.getElements();
            while (configurations.hasMoreElements()) {
                btn = (JRadioButton)configurations.nextElement();
                if (!btn.getActionCommand().equals(configuration)) continue;
                this.configurationsGroup.setSelected(btn.getModel(), true);
                break;
            }
        }
        if (profile != null) {
            Enumeration<AbstractButton> profiles = this.profilesGroup.getElements();
            while (profiles.hasMoreElements()) {
                btn = (JRadioButton)profiles.nextElement();
                if (!btn.getActionCommand().equals(profile)) continue;
                this.profilesGroup.setSelected(btn.getModel(), true);
                break;
            }
        }
        if (jdkPlatform != null) {
            for (int i2 = 0; i2 < this.jdkComboBox.getItemCount(); ++i2) {
                itemAt = PlatformUiSupport.getPlatform(this.jdkComboBox.getItemAt(i2));
                if (!itemAt.equals(jdkPlatform)) continue;
                this.jdkComboBox.setSelectedItem(itemAt);
                break;
            }
        }
    }

    @Override
    void validate(WizardDescriptor d) throws WizardValidationException {
    }

    @Override
    void store(WizardDescriptor d) {
        d.putProperty("platform", (Object)(this.platformComboBox.getSelectedIndex() == -1 ? null : this.getPlatform()));
        d.putProperty("device", (Object)(this.deviceComboBox.getSelectedIndex() == -1 ? "" : this.getDevice().getName()));
        d.putProperty("config", (Object)this.getConfiguration());
        d.putProperty("profile", (Object)this.getProfile());
        d.putProperty("jdk", (Object)(this.jdkComboBox.getSelectedIndex() == -1 ? "" : this.getJdkPlatform()));
        d.putProperty("optionalApi", (Object)this.getOptionalAPI());
        d.putProperty("bootclasspath", (Object)this.getBootClasspath());
        this.getPreferences().put("platform", this.platformComboBox.getSelectedIndex() == -1 ? "" : this.getPlatform().getName());
        this.getPreferences().put("device", this.deviceComboBox.getSelectedIndex() == -1 ? "" : this.getDevice().getName());
        this.getPreferences().put("config", this.getConfiguration());
        this.getPreferences().put("profile", this.getProfile());
    }

    private String getOptionalAPI() {
        StringBuilder sb = new StringBuilder();
        for (JCheckBox cb : this.optionalPackages) {
            if (this.props != null && !cb.isSelected()) continue;
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append(cb.getActionCommand());
        }
        return sb.toString();
    }

    private String getBootClasspath() {
        String[] optionalPkgs;
        StringBuilder sbBootCP = new StringBuilder();
        J2MEPlatform.J2MEProfile configProfile = this.name2profile.get(this.getConfiguration());
        J2MEPlatform.J2MEProfile profileProfile = this.name2profile.get(this.getProfile());
        if (configProfile == null || profileProfile == null) {
            return "";
        }
        sbBootCP.append(configProfile.getClassPath());
        sbBootCP.append(":").append(profileProfile.getClassPath());
        for (String pkg : optionalPkgs = this.getOptionalAPI().split(",")) {
            J2MEPlatform.J2MEProfile profile = this.name2profile.get(pkg);
            if (profile == null) continue;
            sbBootCP.append(":").append(profile.getClassPath());
        }
        return sbBootCP.toString();
    }

    protected final Preferences getPreferences() {
        return NbPreferences.forModule(PlatformDevicesPanel.class);
    }

    private static class MultiCheckboxDataSource
    extends J2MEProjectProperties.DataSource {
        private final List<JCheckBox> options;

        MultiCheckboxDataSource(@NonNull String propName, @NonNull List<JCheckBox> options, @NonNull JComboBox<?> configCombo, @NonNull Map<String, Map<String, String>> configs) {
            super(propName, null, configCombo, configs);
            Parameters.notNull((CharSequence)"options", options);
            this.options = options;
            for (JCheckBox box : options) {
                box.addItemListener(new ItemListener(){

                    @Override
                    public void itemStateChanged(ItemEvent e) {
                        MultiCheckboxDataSource.this.changed(MultiCheckboxDataSource.this.getPropertyValue());
                    }
                });
            }
        }

        @Override
        public final String getPropertyValue() {
            StringBuilder sb = new StringBuilder();
            for (JCheckBox cb : this.options) {
                if (!cb.isSelected()) continue;
                if (sb.length() > 0) {
                    sb.append(',');
                }
                sb.append(cb.getActionCommand());
            }
            return sb.toString();
        }

        @Override
        public void update(String activeConfig) {
            String selectedOptions = this.getPropertyValue(activeConfig, this.getPropertyName());
            if (selectedOptions != null) {
                for (JCheckBox box : this.options) {
                    if (selectedOptions.contains(box.getActionCommand())) {
                        box.setSelected(true);
                        continue;
                    }
                    box.setSelected(false);
                }
            } else {
                for (JCheckBox box : this.options) {
                    box.setSelected(false);
                }
            }
        }
    }

    private final class ConfigListCellRenderer
    extends JLabel
    implements ListCellRenderer,
    UIResource {
        public ConfigListCellRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String label;
            this.setName("ComboBox.listRenderer");
            String config = (String)value;
            if (config == null) {
                label = null;
            } else if (config.length() > 0) {
                Map m = (Map)PlatformDevicesPanel.this.configs.get(config);
                String string = label = m != null ? (String)m.get("$label") : null;
                if (label == null) {
                    label = config;
                }
            } else {
                label = NbBundle.getBundle((String)"org.netbeans.modules.java.j2seproject.Bundle").getString("J2SEConfigurationProvider.default.label");
            }
            this.setText(label);
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            return this;
        }

        @Override
        public String getName() {
            String name = super.getName();
            return name == null ? "ComboBox.renderer" : name;
        }
    }

    private class JavaPlatformChangeListener
    implements PropertyChangeListener {
        private JavaPlatformChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (PlatformDevicesPanel.this.panel != null) {
                PlatformDevicesPanel.this.panel.fireChangeEvent();
            }
        }
    }
}

