/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.jcasm.cap;

import com.sun.javacard.jcasm.ConstantPool;
import com.sun.javacard.jcasm.Field;
import com.sun.javacard.jcasm.Info;
import com.sun.javacard.jcasm.JCClass;
import com.sun.javacard.jcasm.JCMethod;
import com.sun.javacard.jcasm.JCPackage;
import com.sun.javacard.jcasm.Member;
import com.sun.javacard.jcasm.Msg;
import com.sun.javacard.jcasm.cap.TypeDescriptorEntry;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;

public class TypeDescriptorInfo {
    protected int token;
    protected TypeDescriptorEntry[] constantPoolTypes;
    protected Vector<TypeDescriptorEntry> descVector;
    protected int descOffset;
    private int descBase;

    TypeDescriptorInfo(JCPackage jCPackage) {
        Object object;
        Object object2;
        ConstantPool constantPool = jCPackage.getConstantPool();
        this.constantPoolTypes = new TypeDescriptorEntry[constantPool.getCount()];
        this.descVector = new Vector(constantPool.getCount());
        this.descBase = this.descOffset = 2 + constantPool.getCount() * 2;
        for (int i = 0; i < this.constantPoolTypes.length; ++i) {
            object2 = constantPool.getConstantPoolEntry(i);
            if (((Info)object2).getType() == 1) continue;
            object = new TypeDescriptorEntry(jCPackage, (Info)object2, this.descOffset);
            int n = this.descVector.indexOf(object);
            if (n != -1) {
                object = this.descVector.elementAt(n);
            } else {
                this.descVector.addElement((TypeDescriptorEntry)object);
                this.descOffset += ((TypeDescriptorEntry)object).size();
            }
            this.constantPoolTypes[i] = object;
        }
        Enumeration<JCClass> enumeration = jCPackage.classElements();
        while (enumeration.hasMoreElements()) {
            int n;
            TypeDescriptorEntry typeDescriptorEntry;
            Member member;
            object2 = enumeration.nextElement();
            object = ((JCClass)object2).methodElements();
            while (object.hasMoreElements()) {
                member = (JCMethod)object.nextElement();
                typeDescriptorEntry = new TypeDescriptorEntry((JCMethod)member, this.descOffset);
                n = this.descVector.indexOf(typeDescriptorEntry);
                if (n != -1) continue;
                this.descVector.addElement(typeDescriptorEntry);
                this.descOffset += typeDescriptorEntry.size();
            }
            object = ((JCClass)object2).fieldElements();
            while (object.hasMoreElements()) {
                member = object.nextElement();
                if (((Field)member).getDescriptor().isPrimitive() || (n = this.descVector.indexOf(typeDescriptorEntry = new TypeDescriptorEntry((Field)member, this.descOffset))) != -1) continue;
                this.descVector.addElement(typeDescriptorEntry);
                this.descOffset += typeDescriptorEntry.size();
            }
        }
    }

    int getOffset(JCMethod jCMethod) {
        TypeDescriptorEntry typeDescriptorEntry = new TypeDescriptorEntry(jCMethod, this.descOffset);
        int n = this.descVector.indexOf(typeDescriptorEntry);
        if (n == -1) {
            this.descVector.addElement(typeDescriptorEntry);
            this.descOffset += typeDescriptorEntry.size();
        } else {
            typeDescriptorEntry = this.descVector.elementAt(n);
        }
        return typeDescriptorEntry.getOffset();
    }

    int getOffset(Field field) {
        TypeDescriptorEntry typeDescriptorEntry = new TypeDescriptorEntry(field, this.descOffset);
        int n = this.descVector.indexOf(typeDescriptorEntry);
        if (n == -1) {
            this.descVector.addElement(typeDescriptorEntry);
            this.descOffset += typeDescriptorEntry.size();
        } else {
            typeDescriptorEntry = this.descVector.elementAt(n);
        }
        return typeDescriptorEntry.getOffset();
    }

    int size() {
        int n = 2 + this.constantPoolTypes.length * 2;
        for (TypeDescriptorEntry typeDescriptorEntry : this.descVector) {
            n += typeDescriptorEntry.size();
        }
        return n;
    }

    byte[] toByteArray() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(this.size());
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            dataOutputStream.writeShort(this.constantPoolTypes.length);
            for (TypeDescriptorEntry typeDescriptorEntry : this.constantPoolTypes) {
                if (typeDescriptorEntry == null) {
                    dataOutputStream.writeShort(65535);
                    continue;
                }
                dataOutputStream.writeShort(typeDescriptorEntry.getOffset());
            }
            for (TypeDescriptorEntry typeDescriptorEntry : this.descVector) {
                byte[] byArray = typeDescriptorEntry.toByteArray();
                dataOutputStream.write(byArray, 0, byArray.length);
            }
            dataOutputStream.flush();
        }
        catch (IOException iOException) {
            return null;
        }
        return byteArrayOutputStream.toByteArray();
    }

    public String toString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("constant_pool_count: " + this.constantPoolTypes.length + Msg.eol);
        for (n = 0; n < this.constantPoolTypes.length; ++n) {
            if (n % 10 == 0) {
                stringBuffer.append("[" + n + "] ");
            }
            if (this.constantPoolTypes[n] == null) {
                stringBuffer.append(" " + Msg.toHexString((short)-1));
            } else {
                stringBuffer.append(" " + Msg.toHexString((short)this.constantPoolTypes[n].getOffset()));
            }
            if (n % 10 != 9) continue;
            stringBuffer.append(Msg.eol);
        }
        if (n % 10 != 0) {
            stringBuffer.append(Msg.eol);
        }
        stringBuffer.append("type_desc[]: " + Msg.eol);
        int n2 = this.descBase;
        for (TypeDescriptorEntry typeDescriptorEntry : this.descVector) {
            stringBuffer.append("[" + Msg.toHexString((short)n2) + "] " + typeDescriptorEntry + Msg.eol);
            n2 += typeDescriptorEntry.size();
        }
        return stringBuffer.toString();
    }
}

