/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common2.debugger.assembly;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;
import javax.swing.text.StyledEditorKit;
import org.netbeans.modules.cnd.debugger.common2.debugger.Address;
import org.netbeans.modules.cnd.debugger.common2.debugger.actions.MemoryWindowAction;
import org.netbeans.modules.cnd.debugger.common2.debugger.actions.RegistersWindowAction;
import org.netbeans.modules.cnd.debugger.common2.debugger.actions.RunToCursorInstAction;
import org.netbeans.modules.cnd.debugger.common2.debugger.actions.StepInstAction;
import org.netbeans.modules.cnd.debugger.common2.debugger.actions.StepOutInstAction;
import org.netbeans.modules.cnd.debugger.common2.debugger.actions.StepOverInstAction;
import org.netbeans.modules.cnd.debugger.common2.debugger.assembly.BreakpointModel;
import org.netbeans.modules.cnd.debugger.common2.debugger.assembly.Catalog;
import org.netbeans.modules.cnd.debugger.common2.debugger.assembly.Controller;
import org.netbeans.modules.cnd.debugger.common2.debugger.assembly.DisFragModel;
import org.netbeans.modules.cnd.debugger.common2.debugger.assembly.Log;
import org.netbeans.modules.cnd.debugger.common2.debugger.assembly.StateModel;
import org.netbeans.modules.cnd.debugger.common2.utils.StopWatch;
import org.netbeans.modules.cnd.utils.CndPathUtilities;
import org.openide.ErrorManager;
import org.openide.text.CloneableEditorSupport;
import org.openide.util.ImageUtilities;
import org.openide.util.actions.SystemAction;

public class DisView {
    private String view_name = Catalog.get("TITLE_DisassemblerView");
    private DisFragModel model;
    private StateModel stateModel;
    private BreakpointModel breakpointModel;
    private Controller controller;
    private boolean from_address = false;
    private CachedFontMetrics metrics = new CachedFontMetrics();
    private transient JComponent tree = null;
    private StyledDocument styledDoc;
    private Font default_font;
    private JEditorPane editorPane;
    private Gutter gutter;
    private JScrollPane textScrollPane;
    private JPanel columnHeader;
    private JPanel statusPanel;
    private JTextField patternText;
    private String debugPattern;
    private JLabel addressLabel;
    private JComboBox addressText;
    private JLabel fileLabel;
    private JTextField fileText;
    private JLabel functionLabel;
    private JTextField functionText;
    private final String linePatternString = "(\\s*)(0x\\p{XDigit}+:)(\\s*)(.*:)(\\s)(.*?)(!.*)*\n";
    private Pattern linePattern;
    private String insPatternString = "(.*?)(\\s+)(.*)";
    private Pattern insPattern;
    private final Pattern commasPattern = Pattern.compile(",");
    private PopupListener popupListener;
    private GutterListener gutterListener;
    private JPopupMenu popup;
    private JMenuItem menuItemGoToSource;
    private JMenuItem menuItemRegWindow;
    private JMenuItem menuItemMemWindow;
    private JMenuItem menuItemShowCurrentStatement;
    private JMenuItem menuItemAddBreakpoint;
    private JMenuItem menuItemDeleteBreakpoint;
    private HashMap<Long, Integer> modelToViewMap = new HashMap();
    private final BreakpointModel.Listener breakpointListener = new BreakpointModel.Listener(){

        @Override
        public void bptUpdated() {
            DisView.this.breakpointModelChanged();
        }
    };
    private final DisFragModel.Listener fragListener = new DisFragModel.Listener(){

        @Override
        public void fragUpdated() {
            DisView.this.modelChanged();
        }
    };
    private final StateModel.Listener stateListener = new StateModel.Listener(){

        @Override
        public void stateUpdated() {
            DisView.this.stateModelChanged();
        }
    };

    public DisView() {
        EditorKit kit;
        this.tree = new JPanel(new BorderLayout());
        this.tree.setName(this.view_name);
        this.editorPane = new JEditorPane(){
            private final ViewScanner viewScanner = new ViewScanner(){

                @Override
                protected void scanLine(Graphics g, int y, int ycenter) {
                    Point p = new Point(0, ycenter);
                    int pos = DisView.this.editorPane.viewToModel(p);
                    String line = DisView.this.getLineAt(pos);
                    if (line.length() == 0) {
                        return;
                    }
                    int[] regIndex = DisView.this.checkForRegs(line);
                    int bptCount = DisView.this.checkForBreakpoint(line);
                    int disBptCount = DisView.this.checkForDisabledBpt(line);
                    boolean pc = DisView.this.checkForCurrent(line);
                    Color stripeColor = null;
                    if (pc && DisView.this.stateModel.isVisited()) {
                        stripeColor = new Color(231, 225, 239);
                    } else if (bptCount > 0 && pc) {
                        stripeColor = new Color(189, 230, 170);
                    } else if (bptCount > 0) {
                        stripeColor = new Color(252, 159, 157);
                        if (disBptCount > 0) {
                            stripeColor = new Color(220, 220, 216);
                        }
                    } else if (pc) {
                        stripeColor = new Color(189, 230, 170);
                    }
                    int x = 0;
                    if (stripeColor != null) {
                        g.setColor(stripeColor);
                        g.fillRect(x, y - DisView.this.metrics.height, this.getWidth(), DisView.this.metrics.height);
                    } else {
                        Graphics graphics = g.create();
                    }
                }
            };

            @Override
            public void setSize(Dimension d) {
                if (d.width < this.getParent().getSize().width) {
                    d.width = this.getParent().getSize().width;
                }
                super.setSize(d);
            }

            @Override
            public boolean getScrollableTracksViewportWidth() {
                return false;
            }

            @Override
            protected void paintComponent(Graphics passG) {
                Graphics g = passG.create();
                Rectangle clip = g.getClipBounds();
                g.setColor(this.getBackground());
                g.fillRect(clip.x, clip.y, clip.width, clip.height);
                this.viewScanner.scan(DisView.this.editorPane, g, DisView.this.metrics);
                super.paintComponent(passG);
            }
        };
        if (Log.Dis.cndAsm) {
            kit = CloneableEditorSupport.getEditorKit((String)"text/x-asm");
            this.editorPane.setEditorKit(kit);
        } else {
            kit = new StyledEditorKit();
            this.editorPane.setEditorKit(kit);
        }
        this.editorPane.getCaret().setVisible(true);
        this.editorPane.setCaretPosition(0);
        this.editorPane.setOpaque(false);
        this.editorPane.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                DisView.this.editorPane.getCaret().setVisible(true);
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        });
        Font f = this.editorPane.getFont();
        this.default_font = new Font("Monospaced", f.getStyle(), f.getSize() + 1);
        this.editorPane.setFont(this.default_font);
        this.editorPane.setEditable(false);
        if (!Log.Dis.cndAsm) {
            this.styledDoc = new DefaultStyledDocument();
            this.editorPane.setDocument(this.styledDoc);
            this.addStylesToDocument(this.styledDoc);
        } else {
            Document doc = this.editorPane.getDocument();
            if (doc instanceof StyledDocument) {
                this.styledDoc = (StyledDocument)doc;
            }
        }
        this.textScrollPane = new JScrollPane(this.editorPane);
        this.metrics.update(this.editorPane);
        this.gutter = new Gutter(this.editorPane);
        this.textScrollPane.setRowHeaderView(this.gutter);
        int policy = 30;
        this.textScrollPane.setHorizontalScrollBarPolicy(30);
        this.columnHeader = new JPanel(new BorderLayout());
        JToolBar toolbar = new JToolBar();
        toolbar.setFloatable(false);
        toolbar.setRollover(true);
        toolbar.setBorderPainted(true);
        if (Log.Dis.match) {
            this.patternText = new JTextField();
            this.patternText.setColumns(70);
            this.patternText.setHorizontalAlignment(2);
            this.patternText.setEditable(true);
            this.patternText.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    DisView.this.debugPattern = DisView.this.patternText.getText();
                    System.out.printf("Pattern: '%s'\n", DisView.this.debugPattern);
                    DisView.this.modelChanged();
                }
            });
            this.columnHeader.add((Component)this.patternText, "Center");
        }
        this.columnHeader.add((Component)toolbar, "East");
        JButton b = new JButton((Action)SystemAction.get(StepOverInstAction.class));
        b.setText(null);
        toolbar.add(b);
        b = new JButton((Action)SystemAction.get(StepInstAction.class));
        b.setText(null);
        toolbar.add(b);
        b = new JButton((Action)SystemAction.get(StepOutInstAction.class));
        b.setText(null);
        toolbar.add(b);
        b = new JButton((Action)SystemAction.get(RunToCursorInstAction.class));
        b.setText(null);
        toolbar.add(b);
        this.statusPanel = new JPanel(new GridBagLayout());
        this.statusPanel.setToolTipText(Catalog.get("TIP_DisStatus"));
        JPanel addressPanel = new JPanel(new GridBagLayout());
        this.addressLabel = new JLabel(Catalog.get("LBL_Address"));
        this.addressLabel.setToolTipText(Catalog.get("TIP_DisAddress"));
        this.addressText = new JComboBox();
        this.addressText.setEditable(true);
        this.addressText.addActionListener(new AddressTextAction());
        this.addressLabel.setLabelFor(this.addressText);
        int gridx = 0;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = gridx++;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(8, 0, 8, 0);
        addressPanel.add((Component)this.addressLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = gridx++;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(8, 4, 8, 0);
        gridBagConstraints.weightx = 1.0;
        addressPanel.add((Component)this.addressText, gridBagConstraints);
        JPanel filePanel = new JPanel(new GridBagLayout());
        this.fileLabel = new JLabel();
        this.fileLabel.setText(Catalog.get("LBL_File"));
        this.fileLabel.setToolTipText(Catalog.get("TIP_DisFile"));
        this.fileText = new JTextField();
        this.fileText.setColumns(15);
        this.fileText.setHorizontalAlignment(2);
        this.fileText.setEditable(false);
        this.fileLabel.setLabelFor(this.fileText);
        gridx = 0;
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = gridx++;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(8, 0, 8, 0);
        filePanel.add(this.fileLabel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = gridx++;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.insets = new Insets(8, 4, 8, 0);
        filePanel.add(this.fileText);
        JPanel functionPanel = new JPanel(new GridBagLayout());
        this.functionLabel = new JLabel();
        this.functionLabel.setText(Catalog.get("LBL_Function"));
        this.functionLabel.setToolTipText(Catalog.get("TIP_DisFunction"));
        this.functionText = new JTextField();
        this.functionText.setColumns(15);
        this.functionText.setHorizontalAlignment(2);
        this.functionText.setEditable(false);
        this.functionLabel.setLabelFor(this.functionText);
        gridx = 0;
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = gridx++;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(8, 0, 8, 0);
        functionPanel.add(this.functionLabel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = gridx++;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(8, 4, 8, 0);
        functionPanel.add(this.functionText);
        gridx = 0;
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = gridx++;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(8, 0, 8, 0);
        this.statusPanel.add((Component)addressPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = gridx++;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(8, 4, 8, 0);
        this.statusPanel.add((Component)filePanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = gridx++;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(8, 4, 8, 0);
        this.statusPanel.add((Component)functionPanel, gridBagConstraints);
        this.tree.add((Component)this.columnHeader, "North");
        this.tree.add((Component)this.textScrollPane, "Center");
        this.tree.add((Component)this.statusPanel, "South");
        this.createPopup();
    }

    private void createPopup() {
        this.popup = new JPopupMenu();
        this.popupListener = new PopupListener(this.popup);
        this.gutterListener = new GutterListener();
        this.menuItemGoToSource = new JMenuItem(new GoToSourceAction());
        this.popup.add(this.menuItemGoToSource);
        this.popup.addSeparator();
        this.menuItemShowCurrentStatement = new JMenuItem(new ShowCurrentStatementAction());
        this.popup.add(this.menuItemShowCurrentStatement);
        this.popup.addSeparator();
        this.menuItemAddBreakpoint = new JMenuItem(new BreakpointAction(Catalog.get("Dis_ACT_Set_Breakpoint"), true));
        this.popup.add(this.menuItemAddBreakpoint);
        this.menuItemDeleteBreakpoint = new JMenuItem(new BreakpointAction(Catalog.get("Dis_ACT_Delete_Breakpoint"), false));
        this.popup.add(this.menuItemDeleteBreakpoint);
        this.menuItemRegWindow = new JMenuItem((Action)SystemAction.get(RegistersWindowAction.class));
        this.popup.add(this.menuItemRegWindow);
        this.menuItemMemWindow = new JMenuItem((Action)SystemAction.get(MemoryWindowAction.class));
        this.popup.add(this.menuItemMemWindow);
        this.popup.addSeparator();
        this.editorPane.addMouseListener(this.popupListener);
        this.gutter.addMouseListener(this.gutterListener);
    }

    public void setController(Controller controller) {
        this.controller = controller;
    }

    public Controller getController() {
        return this.controller;
    }

    public DisFragModel getModel() {
        return this.model;
    }

    public int modelToView(long addr) throws BadLocationException {
        Integer pos = this.modelToViewMap.get(addr);
        if (pos == null) {
            throw new BadLocationException("", 0);
        }
        return pos;
    }

    private static boolean isSpace(char c) {
        return c == ' ' || c == '\t';
    }

    private void insertLineArray(String sline, LineStyle defaultStyle) {
        int lx;
        char[] line = sline.toCharArray();
        int length = line.length;
        int addrx = lx = 0;
        while (lx < length && line[lx] != ':') {
            ++lx;
        }
        if (lx == length) {
            this.insert(new String(line, addrx, length - addrx), defaultStyle);
            return;
        }
        String address = new String(line, addrx, lx - addrx + 1);
        this.insert(address, LineStyle.address);
        int labelx = ++lx;
        while (lx < length && line[lx] != ':') {
            ++lx;
        }
        if (lx == length) {
            this.insert(new String(line, labelx, length - labelx), defaultStyle);
            return;
        }
        String label = new String(line, labelx, lx - labelx + 1);
        this.insert(label, LineStyle.label);
        int opx = ++lx;
        while (lx < length && DisView.isSpace(line[lx])) {
            ++lx;
        }
        while (lx < length && !DisView.isSpace(line[lx])) {
            ++lx;
        }
        String op = new String(line, opx, lx - opx);
        this.insert(op, LineStyle.op);
        while (true) {
            int argx = ++lx;
            while (lx < length && DisView.isSpace(line[lx])) {
                ++lx;
            }
            if (lx == length) break;
            if (line[lx] == '!') {
                this.insert(new String(line, argx, length - argx), defaultStyle);
                break;
            }
            while (lx < length && !DisView.isSpace(line[lx]) && line[lx] != ',' && line[lx] != '!') {
                ++lx;
            }
            if (lx < length && line[lx] == '!') {
                this.insert(new String(line, argx, length - argx), defaultStyle);
                break;
            }
            String arg = new String(line, argx, lx - argx);
            this.insert(arg, LineStyle.args);
            if (lx >= length || line[lx] != ',') continue;
            this.insert(",", defaultStyle);
        }
    }

    private void insertLineString(String line, LineStyle defaultStyle) {
        int lx;
        int colonx1 = line.indexOf(58);
        if (colonx1 == -1) {
            this.insert(line, defaultStyle);
            return;
        }
        String address = line.substring(0, colonx1 + 1);
        this.insert(address, LineStyle.address);
        int colonx2 = line.indexOf(58, colonx1 + 1);
        if (colonx2 == -1) {
            this.insert(line.substring(colonx1 + 1), defaultStyle);
            return;
        }
        String label = line.substring(colonx1 + 1, colonx2 + 1);
        this.insert(label, LineStyle.label);
        int opx = lx = colonx2 + 1;
        while (lx < line.length() && Character.isWhitespace(line.charAt(lx))) {
            ++lx;
        }
        while (lx < line.length() && !Character.isWhitespace(line.charAt(lx))) {
            ++lx;
        }
        int eopx = lx;
        String op = line.substring(opx, eopx);
        this.insert(op, LineStyle.op);
        while (true) {
            int argx = ++lx;
            while (lx < line.length() && Character.isWhitespace(line.charAt(lx))) {
                ++lx;
            }
            if (lx == line.length()) break;
            if (line.charAt(lx) == '!') {
                this.insert(line.substring(lx), defaultStyle);
                break;
            }
            while (lx < line.length() && !Character.isWhitespace(line.charAt(lx)) && line.charAt(lx) != ',' && line.charAt(lx) != '!') {
                ++lx;
            }
            if (lx < line.length() && line.charAt(lx) == '!') {
                this.insert(line.substring(lx), defaultStyle);
                break;
            }
            int eargx = lx;
            String arg = line.substring(argx, eargx);
            this.insert(arg, LineStyle.args);
            if (lx >= line.length() || line.charAt(lx) != ',') continue;
            this.insert(",", defaultStyle);
        }
        this.insert("\n", defaultStyle);
    }

    private void insertIns(String ins, LineStyle defaultStyle) {
        Matcher im = this.insPattern.matcher(ins);
        if (im.matches()) {
            this.insert(im.group(1), LineStyle.op);
            this.insert(im.group(2), defaultStyle);
            String rargs = im.group(3);
            String[] args = this.commasPattern.split(rargs);
            for (int ax = 0; ax < args.length; ++ax) {
                String arg = args[ax].trim();
                this.insert(arg, LineStyle.args);
                if (ax + 1 >= args.length) continue;
                this.insert(", ", defaultStyle);
            }
        } else {
            this.insert(ins, LineStyle.ins);
        }
    }

    private void insertLineMatcher(String line, LineStyle defaultStyle) {
        Matcher m = this.linePattern.matcher(line);
        if (m.matches()) {
            if (Log.Dis.match) {
                for (int gx = 0; gx <= m.groupCount(); ++gx) {
                    System.out.printf("\tG[%d] '%s'\n", gx, m.group(gx));
                }
            }
            this.insert(m.group(1), defaultStyle);
            this.insert(m.group(2), LineStyle.address);
            this.insert(m.group(3), defaultStyle);
            this.insert(m.group(4), LineStyle.label);
            this.insert(m.group(5), defaultStyle);
            this.insertIns(m.group(6), defaultStyle);
            if (m.group(7) != null) {
                this.insert("\t", defaultStyle);
                this.insert(m.group(7), LineStyle.comment);
            }
            this.insert("\n", defaultStyle);
        } else {
            this.insert(line, defaultStyle);
            if (Log.Dis.match) {
                System.out.printf("\tno match\n", new Object[0]);
            }
        }
    }

    private void insertLine(String line, LineStyle defaultStyle) {
        if (Log.Dis.match) {
            System.out.printf("line %s", line);
        }
        this.insertLineArray(line, defaultStyle);
    }

    public void modelChanged() {
        try {
            this.modelToViewMap = new HashMap();
            if (this.model == null) {
                return;
            }
            StopWatch sw = new StopWatch(String.format("Dis document creation for %d lines", this.model.size()));
            sw.start();
            int carpos = this.getCaretPosition();
            this.clear();
            sw.mark("clear");
            this.linePattern = Pattern.compile("(\\s*)(0x\\p{XDigit}+:)(\\s*)(.*:)(\\s)(.*?)(!.*)*\n");
            if (this.debugPattern != null) {
                this.insPatternString = this.debugPattern;
            }
            this.insPattern = Pattern.compile(this.insPatternString);
            sw.mark("compattern");
            if (Log.Dis.match) {
                System.out.printf("============================================\n", new Object[0]);
                System.out.printf("pattern '%s'\n", "(\\s*)(0x\\p{XDigit}+:)(\\s*)(.*:)(\\s)(.*?)(!.*)*\n");
                System.out.printf("pattern '%s'\n", this.insPatternString);
            }
            StringBuilder sb = new StringBuilder();
            for (DisFragModel.Line srcLine : this.model) {
                String line = srcLine.toString();
                String addr = this.addrFromLine(line);
                if (addr != null) {
                    try {
                        long address = Address.parseAddr(addr);
                        this.modelToViewMap.put(address, this.getCaretPosition());
                    }
                    catch (NumberFormatException x) {
                        ErrorManager.getDefault().notify((Throwable)x);
                    }
                }
                LineStyle defaultStyle = this.figureStyle(line);
                if (this.checkForCurrent(line) && !this.stateModel.isVisited()) {
                    carpos = this.getCaretPosition();
                }
                if (Log.Dis.cndAsm) {
                    int badx = line.indexOf(60);
                    if (badx != -1) {
                        line = line.substring(0, badx - 1);
                    }
                    if (defaultStyle == LineStyle.Source_line) {
                        sb.append("! " + line);
                        continue;
                    }
                    sb.append(line);
                    continue;
                }
                if (defaultStyle == LineStyle.Source_line) {
                    this.insert(line, defaultStyle);
                    continue;
                }
                this.insertLine(line, defaultStyle);
            }
            if (Log.Dis.cndAsm) {
                sw.mark("setText");
                this.editorPane.setText(sb.toString());
            }
            sw.stop();
            if (Log.Dis.time) {
                sw.dump();
            }
            this.stateModel.setAddrHashMap(this.modelToViewMap);
            this.setCaretPosition(carpos);
            this.editorPane.getCaret().setVisible(true);
            this.gutter.repaint();
            this.editorPane.repaint();
        }
        catch (Throwable x) {
            x.printStackTrace();
        }
    }

    public void stateModelChanged() {
        block9: {
            if (this.stateModel == null) {
                this.fileText.setText(null);
                this.fileText.setToolTipText(null);
                this.functionText.setText(null);
            } else {
                if (this.stateModel.getFile() != null) {
                    this.fileText.setText(CndPathUtilities.getBaseName((String)this.stateModel.getFile()));
                    this.fileText.setToolTipText(this.stateModel.getFile());
                } else {
                    this.fileText.setText(null);
                    this.fileText.setToolTipText(null);
                }
                if (this.stateModel.getFunction() != null) {
                    this.functionText.setText(this.stateModel.getFunction());
                } else {
                    this.functionText.setText(null);
                }
            }
            try {
                if (!this.from_address) {
                    this.setCaretPosition(this.modelToView(this.stateModel.getPC()));
                }
            }
            catch (Exception x) {
                if (this.stateModel.getPC() == 0L) break block9;
                String start = Address.toHexString0x(this.stateModel.getPC(), true);
                this.controller.requestDis(start, 100, true);
            }
        }
        this.from_address = false;
        this.gutter.repaint();
        this.editorPane.repaint();
    }

    public void breakpointModelChanged() {
        this.gutter.repaint();
        this.editorPane.repaint();
    }

    JComponent getComponent() {
        return this.tree;
    }

    void componentActivated() {
        this.editorPane.requestFocusInWindow();
    }

    private String getLineAt(int pos) {
        Element pp = this.styledDoc.getParagraphElement(pos);
        int startPos = pp.getStartOffset();
        int endPos = pp.getEndOffset();
        int length = endPos - startPos;
        String line = null;
        try {
            line = this.styledDoc.getText(startPos, length);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return line;
    }

    private String addrFromLine(String line) {
        if (line == null) {
            return null;
        }
        if (!line.startsWith("   0x")) {
            return null;
        }
        int i = line.indexOf("0x");
        String address = line.substring(i);
        i = address.indexOf(":");
        int j = address.indexOf(" ");
        if (i > 0) {
            address = address.substring(0, i);
        } else if (j > 0) {
            address = address.substring(0, j);
        }
        return address;
    }

    private String getCurrentLine() {
        Caret caret = this.editorPane.getCaret();
        int pos = caret.getDot();
        return this.getLineAt(pos);
    }

    public String getCurrentAddress() {
        String address = this.addrFromLine(this.getCurrentLine());
        return address;
    }

    void clear() {
        try {
            this.styledDoc.remove(0, this.styledDoc.getLength());
        }
        catch (BadLocationException ble1) {
            System.err.println("View.clear(): Couldn't remove initial text from document.");
        }
    }

    private void insert(String text, LineStyle style) {
        assert (!Log.Dis.cndAsm);
        try {
            this.styledDoc.insertString(this.styledDoc.getLength(), text, this.styledDoc.getStyle(style.toString()));
        }
        catch (BadLocationException ble2) {
            System.err.println("View.clear(): Couldn't insert initial text into document.");
        }
    }

    private void setCaretPosition(int carpos) {
        try {
            Rectangle bubble = this.editorPane.modelToView(carpos);
            Rectangle viewRect = this.textScrollPane.getViewport().getViewRect();
            if (Log.Dis.bubble) {
                System.out.printf("setCaretPosition(%d)\n", carpos);
                System.out.printf("\tbubble %d[%d]%d\n", bubble.y, bubble.height, bubble.x);
                System.out.printf("\tviewRect %d[%d]%d\n", viewRect.y, viewRect.height, viewRect.y + viewRect.height);
            }
            boolean shouldScroll = false;
            if (bubble.y < viewRect.y) {
                shouldScroll = true;
            } else if (bubble.y + bubble.height > viewRect.y + viewRect.height) {
                shouldScroll = true;
            }
            if (shouldScroll) {
                int rectHeight = viewRect.height / bubble.height;
                --rectHeight;
                int x = bubble.x;
                int width = bubble.width;
                int y = bubble.y - bubble.height * (rectHeight /= 2);
                int height = bubble.height * (rectHeight * 2 + 1);
                Rectangle xBubble = new Rectangle(x, y, width, height);
                if (Log.Dis.bubble) {
                    System.out.printf("\trectHeight %d\n", rectHeight);
                    System.out.printf("\txBubble %d[%d]%d\n", xBubble.y, xBubble.height, xBubble.x);
                }
                this.editorPane.scrollRectToVisible(xBubble);
                this.textScrollPane.getRowHeader().repaint();
            }
            this.editorPane.setCaretPosition(carpos);
        }
        catch (Exception e) {
            this.editorPane.setCaretPosition(0);
        }
    }

    private int getCaretPosition() {
        return this.editorPane.getCaretPosition();
    }

    private void addStylesToDocument(StyledDocument doc) {
        Color source_line_fg_color = Color.gray;
        Color code_line_fg_color = Color.black;
        Style def = StyleContext.getDefaultStyleContext().getStyle("default");
        Style s = doc.addStyle(LineStyle.Source_line.toString(), def);
        StyleConstants.setForeground(s, source_line_fg_color);
        s = doc.addStyle(LineStyle.Code_line.toString(), def);
        StyleConstants.setForeground(s, code_line_fg_color);
        s = doc.addStyle(LineStyle.address.toString(), def);
        StyleConstants.setForeground(s, Color.red.darker());
        s = doc.addStyle(LineStyle.label.toString(), def);
        StyleConstants.setForeground(s, code_line_fg_color);
        StyleConstants.setBold(s, true);
        s = doc.addStyle(LineStyle.ins.toString(), def);
        StyleConstants.setForeground(s, new Color(0, 155, 0));
        s = doc.addStyle(LineStyle.op.toString(), def);
        StyleConstants.setForeground(s, new Color(0, 155, 0));
        s = doc.addStyle(LineStyle.args.toString(), def);
        StyleConstants.setForeground(s, new Color(46, 146, 199));
        s = doc.addStyle(LineStyle.comment.toString(), def);
        StyleConstants.setForeground(s, new Color(150, 150, 150));
    }

    private int checkForDisabledBpt(String line) {
        if (this.breakpointModel == null) {
            return 0;
        }
        String address = this.addrFromLine(line);
        if (address == null) {
            return 0;
        }
        long addr = 0L;
        try {
            addr = Address.parseAddr(address);
        }
        catch (NumberFormatException x) {
            ErrorManager.getDefault().notify((Throwable)x);
        }
        return this.breakpointModel.findDisabled(addr);
    }

    private int checkForBreakpoint(String line) {
        if (this.breakpointModel == null) {
            return 0;
        }
        String address = this.addrFromLine(line);
        if (address == null) {
            return 0;
        }
        long addr = 0L;
        try {
            addr = Address.parseAddr(address);
        }
        catch (NumberFormatException x) {
            ErrorManager.getDefault().notify((Throwable)x);
        }
        return this.breakpointModel.find(addr);
    }

    private int regIndexFromLine(String line) {
        Object reg = null;
        if (line == null) {
            return 0;
        }
        int i = line.indexOf("%");
        if (i > 0) {
            return i;
        }
        return 0;
    }

    private int[] checkForRegs(String line) {
        int[] index = new int[2];
        if (this.stateModel == null) {
            return null;
        }
        index[0] = this.regIndexFromLine(line);
        if (index[0] > 0) {
            int i = this.regIndexFromLine(line.substring(index[0] + 1));
            if (i > 0) {
                index[1] = index[0] + i;
            }
        } else {
            index[1] = 0;
        }
        return index;
    }

    private boolean checkForCurrent(String line) {
        if (this.stateModel == null) {
            return false;
        }
        String address = this.addrFromLine(line);
        if (address == null) {
            return false;
        }
        long addr = 0L;
        try {
            addr = Address.parseAddr(address);
        }
        catch (NumberFormatException x) {
            ErrorManager.getDefault().notify((Throwable)x);
        }
        return addr == this.stateModel.getPC();
    }

    private LineStyle figureStyle(String line) {
        LineStyle style_index = line.startsWith("   0x") ? LineStyle.Code_line : LineStyle.Source_line;
        return style_index;
    }

    public void setModelController(DisFragModel m, Controller c, StateModel s, BreakpointModel b) {
        if (this.model != null) {
            this.model.removeListener(this.fragListener);
        }
        if (this.breakpointModel != null) {
            this.breakpointModel.removeListener(this.breakpointListener);
        }
        if (this.stateModel != null) {
            this.stateModel.removeListener(this.stateListener);
        }
        this.model = m;
        this.controller = c;
        this.breakpointModel = b;
        this.stateModel = s;
        if (this.breakpointModel != null) {
            this.breakpointModel.addListener(this.breakpointListener);
        }
        if (this.stateModel != null) {
            this.stateModel.addListener(this.stateListener);
        }
        if (this.model != null) {
            this.model.addListener(this.fragListener);
        }
        this.breakpointModelChanged();
        this.stateModelChanged();
    }

    public void updateWindow() {
        this.modelChanged();
        this.stateModelChanged();
        this.breakpointModelChanged();
    }

    public void showCurrentStatement() {
        this.updateWindow();
    }

    public void setBreakpointModel(BreakpointModel newBreakpointModel) {
        if (this.breakpointModel != null) {
            this.breakpointModel.removeListener(this.breakpointListener);
        }
        this.breakpointModel = newBreakpointModel;
        if (this.breakpointModel != null) {
            this.breakpointModel.addListener(this.breakpointListener);
        }
        this.breakpointModelChanged();
    }

    public BreakpointModel getBreakpointModel() {
        return this.breakpointModel;
    }

    public void setStateModel(StateModel sm) {
        if (this.stateModel != null) {
            this.stateModel.removeListener(this.stateListener);
        }
        this.stateModel = sm;
        if (this.stateModel != null) {
            this.stateModel.addListener(this.stateListener);
        }
        this.stateModelChanged();
    }

    public StateModel getStateModel() {
        return this.stateModel;
    }

    private class Gutter
    extends JComponent {
        private static final int WIDTH = 20;
        private JEditorPane editorPane;
        private final String bptResource = Catalog.get("ICON_BPT_DisassemblerView");
        private final Image bptImage = ImageUtilities.loadImage((String)this.bptResource);
        private final String disBptResource = Catalog.get("ICON_Dis_BPT_DisassemblerView");
        private final Image disBptImage = ImageUtilities.loadImage((String)this.disBptResource);
        private final String pcResource = Catalog.get("ICON_CL_DisassemblerView");
        private final Image pcImage = ImageUtilities.loadImage((String)this.pcResource);
        private final String visitResource = Catalog.get("ICON_V_DisassemblerView");
        private final Image visitImage = ImageUtilities.loadImage((String)this.visitResource);
        private final String bptHitResource = Catalog.get("ICON_CLWBPT_DisassemblerView");
        private final Image bptHitImage = ImageUtilities.loadImage((String)this.bptHitResource);
        private final ViewScanner viewScanner = new ViewScanner(){

            @Override
            protected void scanLine(Graphics g, int y, int ycenter) {
                Rectangle clip = g.getClipBounds();
                Point p = new Point(0, ycenter);
                int pos = Gutter.this.editorPane.viewToModel(p);
                String line = DisView.this.getLineAt(pos);
                if (line.length() == 0) {
                    return;
                }
                int bptCount = DisView.this.checkForBreakpoint(line);
                int disBptCount = DisView.this.checkForDisabledBpt(line);
                boolean pc = DisView.this.checkForCurrent(line);
                Image image = null;
                if (bptCount > 0 && pc) {
                    image = Gutter.this.bptHitImage;
                } else if (bptCount > 0) {
                    image = Gutter.this.bptImage;
                    if (disBptCount > 0) {
                        image = Gutter.this.disBptImage;
                    }
                } else if (pc && DisView.this.stateModel.isVisited()) {
                    image = Gutter.this.visitImage;
                } else if (pc) {
                    image = Gutter.this.pcImage;
                }
                if (image != null) {
                    int imageHeight = image.getHeight(null);
                    int x = 0;
                    g.drawImage(image, x, y - DisView.this.metrics.height + (DisView.this.metrics.height - imageHeight) / 2 + 1, Gutter.this.getBackground(), null);
                }
            }
        };

        public Gutter(JEditorPane editorPane) {
            this.editorPane = editorPane;
        }

        public int getPosition(int x, int y) {
            Point p = new Point(x, y);
            return this.editorPane.viewToModel(p);
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(20, this.editorPane.getHeight());
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            Rectangle clip = g.getClipBounds();
            g.setColor(this.getBackground());
            g.fillRect(clip.x, clip.y, clip.width, clip.height);
            this.viewScanner.scan(this.editorPane, g, DisView.this.metrics);
        }
    }

    abstract class ViewScanner {
        ViewScanner() {
        }

        protected abstract void scanLine(Graphics var1, int var2, int var3);

        public void scan(JEditorPane editorPane, Graphics g, CachedFontMetrics metrics) {
            Rectangle clip = g.getClipBounds();
            Insets margin = editorPane.getMargin();
            int modulus = clip.y % metrics.height;
            int offset = margin.top + (modulus == 0 ? 0 : metrics.height - modulus) + 0;
            if (Log.Dis.gutter) {
                System.out.printf("margin.top %d  height %d  clip.y %d  %% %d  offset %d  firsty %d\n", margin.top, metrics.height, clip.y, clip.y % metrics.height, offset, clip.y + offset);
            }
            for (int yy = offset; yy < clip.height + metrics.height; yy += metrics.height) {
                int y = clip.y + yy;
                int ycenter = y - metrics.height / 2;
                if (Log.Dis.gutter) {
                    int x = clip.x;
                    g.setColor(editorPane.getForeground());
                    g.drawLine(x, y, x + clip.width, y);
                    g.setColor(Color.RED);
                    g.drawLine(x, ycenter, x + clip.width, ycenter);
                }
                this.scanLine(g, y, ycenter);
            }
        }
    }

    private static class CachedFontMetrics {
        private int ascent;
        private int descent;
        private int height;

        private CachedFontMetrics() {
        }

        private void update(JComponent component) {
            Font font = component.getFont();
            FontMetrics fm = component.getFontMetrics(font);
            this.ascent = fm.getAscent();
            this.descent = fm.getDescent();
            this.height = fm.getHeight();
        }

        public int ascent() {
            return this.ascent;
        }

        public int descent() {
            return this.descent;
        }

        public int height() {
            return this.height;
        }
    }

    private class PopupListener
    extends MouseAdapter
    implements ActionListener,
    PopupMenuListener {
        JPopupMenu popup;

        PopupListener(JPopupMenu popupMenu) {
            this.popup = popupMenu;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        private void maybeShowPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                String selected_text = DisView.this.getCurrentLine();
                DisView.this.menuItemGoToSource.setEnabled(selected_text != null);
                String address = DisView.this.addrFromLine(selected_text);
                DisView.this.menuItemAddBreakpoint.setEnabled(address != null);
                DisView.this.menuItemDeleteBreakpoint.setEnabled(address != null);
                this.popup.show(e.getComponent(), e.getX(), e.getY());
            }
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            JMenuItem source = (JMenuItem)ev.getSource();
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent e) {
        }
    }

    private class GutterListener
    extends MouseAdapter {
        private GutterListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            this.toggleBreakpoint(e.getY());
        }

        public void toggleBreakpoint(int y) {
            if (DisView.this.controller != null) {
                int pos = DisView.this.gutter.getPosition(0, y);
                String address = DisView.this.getLineAt(pos);
                if ((address = DisView.this.addrFromLine(address)) != null) {
                    DisView.this.controller.toggleBreakpoint(address);
                }
            }
        }
    }

    private class BreakpointAction
    extends AbstractAction {
        private boolean add;

        public BreakpointAction(String bptString, boolean add) {
            super(bptString, new ImageIcon("cut.gif"));
            this.add = add;
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            String address;
            if (DisView.this.controller != null && (address = DisView.this.addrFromLine(DisView.this.getCurrentLine())) != null) {
                if (this.add) {
                    DisView.this.controller.setBreakpoint(address, true);
                } else {
                    DisView.this.controller.setBreakpoint(address, false);
                }
            }
        }
    }

    class ShowCurrentStatementAction
    extends AbstractAction {
        public ShowCurrentStatementAction() {
            super(Catalog.get("Dis_ACT_Show_Current_Statement"), new ImageIcon("open.gif"));
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            DisView.this.showCurrentStatement();
        }
    }

    static class GoToSourceAction
    extends AbstractAction {
        public GoToSourceAction() {
            super(Catalog.get("Dis_ACT_Go_To_Source"), new ImageIcon("open.gif"));
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
        }
    }

    class AddressTextAction
    extends AbstractAction
    implements ActionListener {
        AddressTextAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String ac = actionEvent.getActionCommand();
            if (ac.equals("comboBoxChanged") || ac.equals("comboBoxEdited")) {
                boolean found = false;
                JComboBox cb = (JComboBox)actionEvent.getSource();
                String start = (String)cb.getSelectedItem();
                for (int i = 0; i < DisView.this.addressText.getItemCount(); ++i) {
                    if (start.compareTo((String)DisView.this.addressText.getItemAt(i)) != 0) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    DisView.this.addressText.addItem(start);
                }
                DisView.this.from_address = true;
                DisView.this.controller.requestDis(start, 100, true);
            }
        }
    }

    static enum LineStyle {
        Source_line,
        Code_line,
        address,
        label,
        ins,
        op,
        args,
        comment;

    }
}

