/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common2.debugger.debugging;

import java.awt.datatransfer.Transferable;
import java.io.IOException;
import org.netbeans.modules.cnd.debugger.common2.debugger.Frame;
import org.netbeans.modules.cnd.debugger.common2.debugger.Thread;
import org.netbeans.modules.cnd.debugger.common2.values.VariableValue;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.spi.viewmodel.ExtendedNodeModel;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.datatransfer.PasteType;

public abstract class DebuggingNodeModel
implements ExtendedNodeModel {
    private static final String THREAD_ICON_PATH = "org/netbeans/modules/cnd/debugger/common2/icons/";
    private static final String THREAD_ICON_NORMAL = "org/netbeans/modules/cnd/debugger/common2/icons/thread";
    private static final String THREAD_ICON_EVENT = "org/netbeans/modules/cnd/debugger/common2/icons/thread_hit";
    private static final String THREAD_ICON_CURRENT_NORMAL = "org/netbeans/modules/cnd/debugger/common2/icons/thread_current";
    private static final String THREAD_ICON_CURRENT_EVENT = "org/netbeans/modules/cnd/debugger/common2/icons/thread_current_hit";
    private static final String FRAME_ICON_PATH = "org/netbeans/modules/debugger/resources";
    private static final String FRAME_ICON_BASE = "org/netbeans/modules/debugger/resources/callStackView/NonCurrentFrame";
    private static final String FRAME_ICON_BASE_CURRENT = "org/netbeans/modules/debugger/resources/callStackView/CurrentFrame";
    private static final String FRAME_ICON_EMPTY = "org/netbeans/modules/cnd/debugger/common2/icons/empty";
    private static final String FRAME_ICON_SIGNAL_HANDLER = "org/netbeans/modules/cnd/debugger/common2/icons/signal_handler_frame";
    private static final String FRAME_ICON_USER_CALL = "org/netbeans/modules/cnd/debugger/common2/icons/user_call_frame";

    protected DebuggingNodeModel() {
    }

    public String getDisplayName(Object node) throws UnknownTypeException {
        if (node instanceof Thread) {
            Thread thread = (Thread)node;
            if (thread.isCurrent()) {
                return VariableValue.bold(thread.getName());
            }
            return thread.getName();
        }
        if (node instanceof Frame) {
            Frame frame = (Frame)node;
            CndUtils.assertNotNull((Object)frame.getThread(), (String)("frame " + frame.getLocationName() + " has no parent thread"));
            if (frame.isCurrent() && frame.getThread().isCurrent()) {
                return VariableValue.bold(frame.getLocationName());
            }
            return frame.getLocationName();
        }
        return "";
    }

    public String getIconBase(Object node) throws UnknownTypeException {
        if (node instanceof Thread) {
            Thread t = (Thread)node;
            if (t.hasEvent()) {
                if (t.isCurrent()) {
                    return THREAD_ICON_CURRENT_EVENT;
                }
                return THREAD_ICON_EVENT;
            }
            if (t.isCurrent()) {
                return THREAD_ICON_CURRENT_NORMAL;
            }
            return THREAD_ICON_NORMAL;
        }
        if (node instanceof Frame) {
            Frame f = (Frame)node;
            if (f.isCurrent() && f.getThread().isCurrent()) {
                return FRAME_ICON_BASE_CURRENT;
            }
            if (f.isSignalHandler()) {
                return FRAME_ICON_SIGNAL_HANDLER;
            }
            if (f.isUserCall()) {
                return FRAME_ICON_USER_CALL;
            }
            if (f.isSpecial()) {
                return FRAME_ICON_EMPTY;
            }
            return FRAME_ICON_BASE;
        }
        return "";
    }

    public String getIconBaseWithExtension(Object node) throws UnknownTypeException {
        if (node instanceof Thread) {
            return this.getIconBase(node) + ".png";
        }
        if (node instanceof Frame) {
            return this.getIconBase(node) + ".gif";
        }
        throw new UnknownTypeException(node);
    }

    public String getShortDescription(Object node) throws UnknownTypeException {
        return "";
    }

    public void addModelListener(ModelListener l) {
    }

    public void removeModelListener(ModelListener l) {
    }

    public boolean canCopy(Object node) throws UnknownTypeException {
        return false;
    }

    public boolean canCut(Object node) throws UnknownTypeException {
        return false;
    }

    public boolean canRename(Object node) throws UnknownTypeException {
        return false;
    }

    public Transferable clipboardCopy(Object node) throws IOException, UnknownTypeException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Transferable clipboardCut(Object node) throws IOException, UnknownTypeException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setName(Object node, String name) throws UnknownTypeException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public PasteType[] getPasteTypes(Object node, Transferable t) throws UnknownTypeException {
        return null;
    }
}

