/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.notifications.center;

import java.awt.Component;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import javax.swing.Action;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.netbeans.modules.notifications.NotificationImpl;
import org.netbeans.modules.notifications.Utils;
import org.netbeans.modules.notifications.center.NotificationTableModel;
import org.netbeans.swing.etable.ETable;
import org.netbeans.swing.etable.ETableColumn;
import org.netbeans.swing.etable.ETableColumnModel;
import org.openide.awt.NotificationDisplayer;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class NotificationTable
extends ETable {
    private final List<ProcessKeyEventListener> keyListeners = new ArrayList<ProcessKeyEventListener>();

    NotificationTable() {
        super((TableModel)new NotificationTableModel());
        this.init();
    }

    private void init() {
        this.setRowSelectionAllowed(true);
        this.setColumnSelectionAllowed(false);
        this.getTableHeader().setResizingAllowed(true);
        this.setAutoResizeMode(1);
        this.setSelectionMode(0);
        this.setFillsViewportHeight(true);
        ETableColumnModel colModel = (ETableColumnModel)this.getColumnModel();
        ETableColumn ecol = (ETableColumn)colModel.getColumn(0);
        ecol.setHeaderValue((Object)NbBundle.getMessage(NotificationTable.class, (String)"LBL_NotificationPriority"));
        ecol.setCellRenderer((TableCellRenderer)new NotificationPriorityRenderer());
        ecol = (ETableColumn)colModel.getColumn(2);
        ecol.setHeaderValue((Object)NbBundle.getMessage(NotificationTable.class, (String)"LBL_NotificationTimestamp"));
        ecol.setCellRenderer((TableCellRenderer)new NotificationDateRenderer());
        colModel.setColumnSorted(ecol, false, 1);
        ecol = (ETableColumn)colModel.getColumn(3);
        ecol.setHeaderValue((Object)NbBundle.getMessage(NotificationTable.class, (String)"LBL_NotificationCategory"));
        ecol.setCellRenderer((TableCellRenderer)new NotificationCategoryRenderer());
        ecol = (ETableColumn)colModel.getColumn(1);
        ecol.setHeaderValue((Object)NbBundle.getMessage(NotificationTable.class, (String)"LBL_NotificationMessage"));
        ecol.setCellRenderer((TableCellRenderer)new NotificationRenderer());
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e)) {
                    JPopupMenu popup;
                    NotificationTable table = NotificationTable.this;
                    int r = table.rowAtPoint(e.getPoint());
                    if (r >= 0 && r < table.getRowCount()) {
                        table.setRowSelectionInterval(r, r);
                    } else {
                        table.clearSelection();
                    }
                    int modelIndex = table.convertRowIndexToModel(table.getSelectedRow());
                    if (modelIndex < 0) {
                        popup = Utilities.actionsToPopup((Action[])Utils.getGlobalNotificationActions(), (Component)((Object)((NotificationTable)((Object)e.getSource()))));
                    } else {
                        NotificationTableModel model = (NotificationTableModel)NotificationTable.this.getModel();
                        NotificationImpl notification = model.getEntry(modelIndex);
                        popup = Utilities.actionsToPopup((Action[])Utils.getNotificationActions(notification), (Component)((Object)((NotificationTable)((Object)e.getSource()))));
                    }
                    popup.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
        this.getInputMap().put(KeyStroke.getKeyStroke(127, 0), "delete");
    }

    protected void processKeyEvent(KeyEvent e) {
        this.fireProcessKeyEvent(e);
        if (!e.isConsumed()) {
            super.processKeyEvent(e);
        }
    }

    void addProcessKeyEventListener(ProcessKeyEventListener listener) {
        this.keyListeners.add(listener);
    }

    void removeProcessKeyEventListener(ProcessKeyEventListener listener) {
        this.keyListeners.remove(listener);
    }

    private void fireProcessKeyEvent(KeyEvent e) {
        for (ProcessKeyEventListener l : this.keyListeners) {
            l.processKeyEvent(e);
        }
    }

    void showNextSelection(boolean forward) {
        int selectedRow = this.getSelectedRow();
        int lastRowIndex = this.getRowCount() - 1;
        ListSelectionModel selection = this.getSelectionModel();
        int toSelect = forward ? selectedRow + 1 : selectedRow - 1;
        if (toSelect < 0) {
            toSelect = lastRowIndex;
        } else if (toSelect > lastRowIndex) {
            toSelect = 0;
        }
        selection.setSelectionInterval(toSelect, toSelect);
    }

    void showDefaultSelection() {
        int selectedRow = this.getSelectedRow();
        if (selectedRow == -1) {
            this.getSelectionModel().setSelectionInterval(0, 0);
        }
    }

    static interface ProcessKeyEventListener {
        public void processKeyEvent(KeyEvent var1);
    }

    private class NotificationRenderer
    extends DefaultTableCellRenderer {
        private NotificationRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            NotificationImpl notification = this.getNotification(table, row);
            if (!notification.isRead()) {
                this.setFont(this.getFont().deriveFont(1));
            }
            return this;
        }

        NotificationImpl getNotification(JTable table, int row) {
            NotificationTableModel model = (NotificationTableModel)table.getModel();
            NotificationImpl notification = model.getEntry(table.convertRowIndexToModel(row));
            return notification;
        }
    }

    private class NotificationCategoryRenderer
    extends NotificationRenderer {
        private NotificationCategoryRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            this.setToolTipText(this.getNotification(table, row).getCategory().getDescription());
            return this;
        }
    }

    private class NotificationDateRenderer
    extends NotificationRenderer {
        private NotificationDateRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            this.setText(Utils.getFormatedDate((Calendar)value));
            this.setToolTipText(Utils.getFullFormatedDate((Calendar)value));
            return this;
        }
    }

    private class NotificationPriorityRenderer
    extends NotificationRenderer {
        private NotificationPriorityRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (value != null) {
                this.setIcon(((NotificationDisplayer.Priority)value).getIcon());
                this.setText("");
                this.setToolTipText(((NotificationDisplayer.Priority)value).name());
            }
            return this;
        }
    }
}

