/**
 * DOMError is an interface that describes an error.
 */
var DOMError = {
}
/**
 * The severity of the error described by the DOMError is warning. A SEVERITY_WARNING will not cause the processing to stop, unless DOMErrorHandler.handleError() returns false.
 * @syntax DOMError.SEVERITY_WARNING
 * @returns {Number} 
 * @static
 */
DOMError.SEVERITY_WARNING = new Number();

/**
 * An implementation specific string describing the error that occurred.
 * @syntax dOMError.message
 * @returns {String} 
 */
DOMError.prototype.message = new String();

/**
 * The related DOMError.type dependent data if any.
 * @syntax dOMError.relatedData
 * @returns {DOMObject} 
 */
DOMError.prototype.relatedData = new DOMObject();

/**
 * The related platform dependent exception if any.
 * @syntax dOMError.relatedException
 * @returns {DOMObject} 
 */
DOMError.prototype.relatedException = new DOMObject();

/**
 * The location of the error.
 * @syntax dOMError.location
 * @returns {DOMLocator} 
 */
DOMError.prototype.location = new DOMLocator();

/**
 * The severity of the error described by the DOMError is error. A SEVERITY_ERROR may not cause the processing to stop if the error can be recovered, unless DOMErrorHandler.handleError() returns false.
 * @syntax DOMError.SEVERITY_ERROR
 * @returns {Number} 
 * @static
 */
DOMError.SEVERITY_ERROR = new Number();

/**
 * The severity of the error, either SEVERITY_WARNING, SEVERITY_ERROR, or SEVERITY_FATAL_ERROR.
 * @syntax dOMError.severity
 * @returns {Number} 
 */
DOMError.prototype.severity = new Number();

/**
 * A DOMString indicating which related data is expected in relatedData. Users should refer to the specification of the error in order to find its DOMString type and relatedData definitions if any. Note: As an example, Document.normalizeDocument() does generate warnings when the "split-cdata-sections" parameter is in use. Therefore, the method generates a SEVERITY_WARNING with type "cdata-sections-splitted" and the first CDATASection node in document order resulting from the split is returned by the relatedData attribute.
 * @syntax dOMError.type
 * @returns {String} 
 */
DOMError.prototype.type = new String();

/**
 * The severity of the error described by the DOMError is fatal error. A SEVERITY_FATAL_ERROR will cause the normal processing to stop. The return value of DOMErrorHandler.handleError() is ignored unless the implementation chooses to continue, in which case the behavior becomes undefined.
 * @syntax DOMError.SEVERITY_FATAL_ERROR
 * @returns {Number} 
 * @static
 */
DOMError.SEVERITY_FATAL_ERROR = new Number();

/**
 * Represents the DOMError prototype object.
 * @syntax DOMError.prototype
 * @static
 */
DOMError.prototype;

