/**
 * The TypeInfo interface represents a type referenced from Element or Attr nodes, specified in the schemas associated with the document. The type is a pair of a namespace URI and name properties, and depends on the document's schema.If the document's schema is an XML DTD [XML 1.0], the values are computed as follows:If the document's schema is an XML Schema [XML Schema Part 1], the values are computed as follows using the post-schema-validation infoset contributions (also called PSVI contributions):Note: Other schema languages are outside the scope of the W3C and therefore should define how to represent their type systems using TypeInfo.
 */
var TypeInfo = {
}
/**
 * The name of a type declared for the associated element or attribute, or null if unknown.
 * @syntax typeInfo.typeName
 * @returns {String} 
 */
TypeInfo.prototype.typeName = new String();

/**
 * If the document's schema is an XML Schema [XML Schema Part 1], this constant represents the union if simple types are involved. The reference type definition is derived by union from the other type definition if there exists two type definitions T1 and T2 such as the reference type definition is derived from T1 by DERIVATION_RESTRICTION or DERIVATION_EXTENSION, T2 is derived from the other type definition by DERIVATION_RESTRICTION, T1 has {variety} union, and one of the {member type definitions} is T2. Note that T1 could be the same as the reference type definition, and T2 could be the same as the other type definition.
 * @syntax TypeInfo.DERIVATION_UNION
 * @returns {Number} 
 * @static
 */
TypeInfo.DERIVATION_UNION = new Number();

/**
 * The namespace of the type declared for the associated element or attribute or null if the element does not have declaration or if no namespace information is available.
 * @syntax typeInfo.typeNamespace
 * @returns {String} 
 */
TypeInfo.prototype.typeNamespace = new String();

/**
 * If the document's schema is an XML Schema [XML Schema Part 1], this constant represents the derivation by restriction if complex types are involved, or a restriction if simple types are involved. The reference type definition is derived by restriction from the other type definition if the other type definition is the same as the reference type definition, or if the other type definition can be reached recursively following the {base type definition} property from the reference type definition, and all the derivation methods involved are restriction.
 * @syntax TypeInfo.DERIVATION_RESTRICTION
 * @returns {Number} 
 * @static
 */
TypeInfo.DERIVATION_RESTRICTION = new Number();

/**
 * This method returns if there is a derivation between the reference type definition, i.e. the TypeInfo on which the method is being called, and the other type definition, i.e. the one passed as parameters.
 * @syntax typeInfo.isDerivedFrom(typeNamespaceArg, typeNameArg, derivationMethod)
 * @param {String} typeNamespaceArg the namespace of the other type definition.
 * @param {String} typeNameArg the name of the other type definition.
 * @param {Number} derivationMethod the type of derivation and conditions applied between two types, as described in the list of constants provided in this interface.
 * @returns {boolean} If the document's schema is a DTD or no schema is associated with the document, this method will always return false. If the document's schema is an XML Schema, the method will true if the reference type definition is derived from the other type definition according to the derivation parameter. If the value of the parameter is 0 (no bit is set to 1 for the derivationMethod parameter), the method will return true if the other type definition can be reached by recursing any combination of {base type definition}, {item type definition}, or {member type definitions} from the reference type definition.
 */
TypeInfo.prototype.isDerivedFrom = function(typeNamespaceArg,  typeNameArg,  derivationMethod) {};

/**
 * If the document's schema is an XML Schema [XML Schema Part 1], this constant represents the derivation by extension. The reference type definition is derived by extension from the other type definition if the other type definition can be reached recursively following the {base type definition} property from the reference type definition, and at least one of the derivation methods involved is an extension.
 * @syntax TypeInfo.DERIVATION_EXTENSION
 * @returns {Number} 
 * @static
 */
TypeInfo.DERIVATION_EXTENSION = new Number();

/**
 * If the document's schema is an XML Schema [XML Schema Part 1], this constant represents the list. The reference type definition is derived by list from the other type definition if there exists two type definitions T1 and T2 such as the reference type definition is derived from T1 by DERIVATION_RESTRICTION or DERIVATION_EXTENSION, T2 is derived from the other type definition by DERIVATION_RESTRICTION, T1 has {variety} list, and T2 is the {item type definition}. Note that T1 could be the same as the reference type definition, and T2 could be the same as the other type definition.
 * @syntax TypeInfo.DERIVATION_LIST
 * @returns {Number} 
 * @static
 */
TypeInfo.DERIVATION_LIST = new Number();

/**
 * Represents the TypeInfo prototype object.
 * @syntax TypeInfo.prototype
 * @static
 */
TypeInfo.prototype;

