/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.extension.filter;

import java.util.List;
import java.util.Vector;
import javax.swing.table.DefaultTableModel;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.extension.filter.Filter;

public class AllFilterTableModel
extends DefaultTableModel {
    private static final long serialVersionUID = 1L;
    private static final String[] columnNames = new String[]{Constant.messages.getString("filter.table.name"), Constant.messages.getString("filter.table.enabled"), ""};
    private List<Filter> allFilters = new Vector<Filter>();

    private void setAllFilters(List<Filter> allFilters) {
        this.allFilters = allFilters;
    }

    public void setTable(List<Filter> allFilters) {
        this.setAllFilters(allFilters);
        this.fireTableDataChanged();
    }

    @Override
    public Class<?> getColumnClass(int c) {
        if (c == 1) {
            return Boolean.class;
        }
        return String.class;
    }

    @Override
    public String getColumnName(int col) {
        return columnNames[col];
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        boolean result = false;
        Filter filter = this.getAllFilters().get(row);
        switch (col) {
            case 0: {
                result = false;
                break;
            }
            case 1: {
                result = true;
                break;
            }
            case 2: {
                result = filter.isPropertyExists();
            }
        }
        return result;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        Filter filter = this.allFilters.get(row);
        switch (col) {
            case 0: {
                break;
            }
            case 1: {
                filter.setEnabled((Boolean)value);
                this.fireTableCellUpdated(row, col);
                break;
            }
        }
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public int getRowCount() {
        return this.getAllFilters().size();
    }

    @Override
    public Object getValueAt(int row, int col) {
        Object result = null;
        Filter filter = this.getAllFilters().get(row);
        switch (col) {
            case 0: {
                result = filter.getName();
                break;
            }
            case 1: {
                result = filter.isEnabled();
                break;
            }
            case 2: {
                if (filter.isPropertyExists()) {
                    result = "...";
                    break;
                }
                result = "";
                break;
            }
            default: {
                result = "";
            }
        }
        return result;
    }

    void setAllFilterEnabled(boolean enabled) {
        for (int i = 0; i < this.getAllFilters().size(); ++i) {
            Filter filter = this.getAllFilters().get(i);
            filter.setEnabled(enabled);
        }
        this.fireTableDataChanged();
    }

    public List<Filter> getAllFilters() {
        if (this.allFilters == null) {
            this.allFilters = new Vector<Filter>();
        }
        return this.allFilters;
    }
}

