/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.spider;

import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Pattern;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.log4j.Logger;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.network.ConnectionParam;
import org.parosproxy.paros.network.HttpMessage;
import org.parosproxy.paros.network.HttpSender;
import org.zaproxy.zap.extension.spider.ExtensionSpider;
import org.zaproxy.zap.model.Context;
import org.zaproxy.zap.spider.SpiderController;
import org.zaproxy.zap.spider.SpiderListener;
import org.zaproxy.zap.spider.SpiderParam;
import org.zaproxy.zap.spider.SpiderTask;
import org.zaproxy.zap.spider.SpiderTaskResult;
import org.zaproxy.zap.spider.filters.DefaultFetchFilter;
import org.zaproxy.zap.spider.filters.DefaultParseFilter;
import org.zaproxy.zap.spider.filters.FetchFilter;
import org.zaproxy.zap.spider.filters.ParseFilter;
import org.zaproxy.zap.spider.parser.SpiderParser;
import org.zaproxy.zap.users.User;

public class Spider {
    private SpiderParam spiderParam;
    private ConnectionParam connectionParam;
    private Model model;
    private List<SpiderListener> listeners;
    private volatile boolean paused;
    private volatile boolean stopped;
    private ReentrantLock pauseLock = new ReentrantLock();
    private SpiderController controller;
    private Condition pausedCondition = this.pauseLock.newCondition();
    private ExecutorService threadPool;
    private DefaultFetchFilter defaultFetchFilter;
    private LinkedHashSet<URI> seedList;
    private ExtensionSpider extension;
    private static final Logger log = Logger.getLogger(Spider.class);
    private HttpSender httpSender;
    private int tasksDoneCount;
    private int tasksTotalCount;
    private Context scanContext;
    private User scanUser;
    private long timeStarted;
    private boolean initialized;
    private static final Pattern svnUrlPattern = Pattern.compile("\\.svn/");
    private static final Pattern gitUrlPattern = Pattern.compile("\\.git/");
    private final String id;

    @Deprecated
    public Spider(ExtensionSpider extension, SpiderParam spiderParam, ConnectionParam connectionParam, Model model, Context scanContext) {
        this("?", extension, spiderParam, connectionParam, model, scanContext);
    }

    public Spider(String id, ExtensionSpider extension, SpiderParam spiderParam, ConnectionParam connectionParam, Model model, Context scanContext) {
        log.info((Object)"Spider initializing...");
        this.id = id;
        this.spiderParam = spiderParam;
        this.connectionParam = connectionParam;
        this.model = model;
        this.extension = extension;
        this.controller = new SpiderController(this, extension.getCustomParsers());
        this.listeners = new LinkedList<SpiderListener>();
        this.seedList = new LinkedHashSet();
        this.scanContext = scanContext;
        this.init();
    }

    private void init() {
        this.paused = false;
        this.stopped = true;
        this.tasksDoneCount = 0;
        this.tasksTotalCount = 0;
        this.initialized = false;
        this.defaultFetchFilter = new DefaultFetchFilter();
        this.addFetchFilter(this.defaultFetchFilter);
        for (FetchFilter fetchFilter : this.extension.getCustomFetchFilters()) {
            this.addFetchFilter(fetchFilter);
        }
        this.addParseFilter(new DefaultParseFilter(this.spiderParam, this.extension.getMessages()));
        for (ParseFilter parseFilter : this.extension.getCustomParseFilters()) {
            this.addParseFilter(parseFilter);
        }
        this.defaultFetchFilter.setScanContext(this.scanContext);
        this.defaultFetchFilter.setDomainsAlwaysInScope(this.spiderParam.getDomainsAlwaysInScopeEnabled());
    }

    public void addSeed(HttpMessage msg) {
        URI uri = msg.getRequestHeader().getURI();
        this.addSeed(uri);
    }

    public void addSeed(URI uri) {
        String host = null;
        try {
            host = uri.getHost();
            this.defaultFetchFilter.addScopeRegex(host);
        }
        catch (URIException e) {
            log.error((Object)("There was an error while adding seed value: " + uri), (Throwable)e);
            return;
        }
        this.seedList.add(uri);
        if (this.getSpiderParam().isParseRobotsTxt()) {
            this.addRootFileSeed(uri, "robots.txt");
        }
        if (this.getSpiderParam().isParseSitemapXml()) {
            this.addRootFileSeed(uri, "sitemap.xml");
        }
        if (this.getSpiderParam().isParseSVNEntries()) {
            this.addFileSeed(uri, ".svn/entries", svnUrlPattern);
            this.addFileSeed(uri, ".svn/wc.db", svnUrlPattern);
        }
        if (this.getSpiderParam().isParseGit()) {
            this.addFileSeed(uri, ".git/index", gitUrlPattern);
        }
    }

    private void addRootFileSeed(URI baseUri, String fileName) {
        String seed = Spider.buildUri(baseUri.getScheme(), baseUri.getRawHost(), baseUri.getPort(), "/" + fileName);
        try {
            this.seedList.add(new URI(seed, true));
        }
        catch (Exception e) {
            log.warn((Object)("Error while creating [" + fileName + "] seed: " + seed), (Throwable)e);
        }
    }

    private static String buildUri(String scheme, char[] host, int port, String path) {
        StringBuilder strBuilder = new StringBuilder(150);
        strBuilder.append(scheme).append("://").append(host);
        if (!Spider.isDefaultPort(scheme, port)) {
            strBuilder.append(':').append(port);
        }
        strBuilder.append(path);
        return strBuilder.toString();
    }

    private void addFileSeed(URI baseUri, String fileName, Pattern condition) {
        String pathminusfilename;
        String name;
        String fullpath = baseUri.getEscapedPath();
        if (fullpath == null) {
            fullpath = "";
        }
        if ((name = baseUri.getEscapedName()) == null) {
            name = "";
        }
        if ((pathminusfilename = fullpath.substring(0, fullpath.lastIndexOf(name))).isEmpty()) {
            pathminusfilename = "/";
        }
        if (condition.matcher(pathminusfilename).find()) {
            return;
        }
        String uri = Spider.buildUri(baseUri.getScheme(), baseUri.getRawHost(), baseUri.getPort(), pathminusfilename + fileName);
        try {
            this.seedList.add(new URI(uri, true));
        }
        catch (Exception e) {
            log.warn((Object)("Error while creating a seed URI for file [" + fileName + "] from [" + baseUri + "] using [" + uri + "]:"), (Throwable)e);
        }
    }

    private static boolean isDefaultPort(String scheme, int port) {
        if (port == -1) {
            return true;
        }
        if ("http".equalsIgnoreCase(scheme)) {
            return port == 80;
        }
        if ("https".equalsIgnoreCase(scheme)) {
            return port == 443;
        }
        return false;
    }

    public void setExcludeList(List<String> excludeList) {
        log.debug((Object)("New Exclude list: " + excludeList));
        this.defaultFetchFilter.setExcludeRegexes(excludeList);
    }

    public void addFetchFilter(FetchFilter filter) {
        this.controller.addFetchFilter(filter);
    }

    public void addParseFilter(ParseFilter filter) {
        this.controller.addParseFilter(filter);
    }

    protected HttpSender getHttpSender() {
        return this.httpSender;
    }

    protected SpiderParam getSpiderParam() {
        return this.spiderParam;
    }

    protected ConnectionParam getConnectionParam() {
        return this.connectionParam;
    }

    protected SpiderController getController() {
        return this.controller;
    }

    protected Model getModel() {
        return this.model;
    }

    protected synchronized void submitTask(SpiderTask task) {
        block4: {
            if (this.isStopped()) {
                log.debug((Object)("Submitting task skipped (" + task + ") as the Spider process is stopped."));
                return;
            }
            if (this.isTerminated()) {
                log.debug((Object)("Submitting task skipped (" + task + ") as the Spider process is terminated."));
                return;
            }
            ++this.tasksTotalCount;
            try {
                this.threadPool.execute(task);
            }
            catch (RejectedExecutionException e) {
                if (!log.isDebugEnabled()) break block4;
                log.debug((Object)("Submitted task was rejected (" + task + "), spider state: [stopped=" + this.isStopped() + ", terminated=" + this.isTerminated() + "]."));
            }
        }
    }

    protected ExtensionSpider getExtensionSpider() {
        return this.extension;
    }

    public void start() {
        log.info((Object)"Starting spider...");
        this.timeStarted = System.currentTimeMillis();
        this.fetchFilterSeeds();
        if (this.seedList == null || this.seedList.isEmpty()) {
            log.warn((Object)"No seeds available for the Spider. Cancelling scan...");
            this.notifyListenersSpiderComplete(false);
            this.notifyListenersSpiderProgress(100, 0, 0);
            return;
        }
        if (this.scanUser != null) {
            log.info((Object)("Scan will be performed from the point of view of User: " + this.scanUser.getName()));
        }
        this.controller.init();
        this.stopped = false;
        this.paused = false;
        this.initialized = false;
        this.threadPool = Executors.newFixedThreadPool(this.spiderParam.getThreadCount(), new SpiderThreadFactory("ZAP-SpiderThreadPool-" + this.id + "-thread-"));
        this.httpSender = new HttpSender(this.connectionParam, this.connectionParam.isHttpStateEnabled() ? true : !this.spiderParam.isAcceptCookies(), 3);
        this.httpSender.setFollowRedirect(false);
        for (URI uri : this.seedList) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Adding seed for spider: " + uri));
            }
            this.controller.addSeed(uri, "GET");
        }
        this.initialized = true;
    }

    private void fetchFilterSeeds() {
        if (this.seedList == null || this.seedList.isEmpty()) {
            return;
        }
        Iterator it = this.seedList.iterator();
        block0: while (it.hasNext()) {
            URI seed = (URI)it.next();
            for (FetchFilter filter : this.controller.getFetchFilters()) {
                FetchFilter.FetchStatus filterReason = filter.checkFilter(seed);
                if (filterReason == FetchFilter.FetchStatus.VALID) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Seed: " + seed + " was filtered with reason: " + (Object)((Object)filterReason)));
                }
                it.remove();
                continue block0;
            }
        }
    }

    public void stop() {
        if (this.stopped) {
            return;
        }
        this.stopped = true;
        log.info((Object)"Stopping spidering process by request.");
        if (this.paused) {
            this.resume();
        }
        this.threadPool.shutdown();
        try {
            if (!this.threadPool.awaitTermination(2L, TimeUnit.SECONDS)) {
                log.warn((Object)"Failed to await for all spider threads to stop in the given time (2s)...");
                for (Runnable task : this.threadPool.shutdownNow()) {
                    ((SpiderTask)task).cleanup();
                }
            }
        }
        catch (InterruptedException ignore) {
            log.warn((Object)"Interrupted while awaiting for all spider threads to stop...");
        }
        if (this.httpSender != null) {
            this.getHttpSender().shutdown();
            this.httpSender = null;
        }
        this.controller.reset();
        this.threadPool = null;
        this.notifyListenersSpiderComplete(false);
    }

    private void complete() {
        if (this.stopped) {
            return;
        }
        log.info((Object)"Spidering process is complete. Shutting down...");
        this.stopped = true;
        if (this.httpSender != null) {
            this.getHttpSender().shutdown();
            this.httpSender = null;
        }
        this.controller.reset();
        new Thread(new Runnable(){

            @Override
            public void run() {
                if (Spider.this.threadPool != null) {
                    Spider.this.threadPool.shutdown();
                }
                Spider.this.notifyListenersSpiderComplete(true);
                Spider.this.controller.reset();
                Spider.this.threadPool = null;
            }
        }, "ZAP-SpiderShutdownThread-" + this.id).start();
    }

    public void pause() {
        this.pauseLock.lock();
        try {
            this.paused = true;
        }
        finally {
            this.pauseLock.unlock();
        }
    }

    public void resume() {
        this.pauseLock.lock();
        try {
            this.paused = false;
            this.pausedCondition.signalAll();
        }
        finally {
            this.pauseLock.unlock();
        }
    }

    public void setScanAsUser(User user) {
        this.scanUser = user;
    }

    protected User getScanUser() {
        return this.scanUser;
    }

    protected void preTaskExecution() {
        this.checkPauseAndWait();
    }

    protected void checkPauseAndWait() {
        this.pauseLock.lock();
        try {
            while (this.paused && !this.stopped) {
                this.pausedCondition.await();
            }
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            this.pauseLock.unlock();
        }
    }

    protected synchronized void postTaskExecution() {
        if (this.stopped) {
            return;
        }
        ++this.tasksDoneCount;
        int percentageComplete = this.tasksDoneCount * 100 / this.tasksTotalCount;
        this.notifyListenersSpiderProgress(percentageComplete, this.tasksDoneCount, this.tasksTotalCount - this.tasksDoneCount);
        if (this.tasksDoneCount == this.tasksTotalCount && this.initialized) {
            this.complete();
        }
    }

    public boolean isPaused() {
        return this.paused;
    }

    public boolean isStopped() {
        if (!this.stopped && this.spiderParam.getMaxDuration() > 0 && TimeUnit.MILLISECONDS.toMinutes(System.currentTimeMillis() - this.timeStarted) > (long)this.spiderParam.getMaxDuration()) {
            log.info((Object)("Spidering process has exceeded maxDuration of " + this.spiderParam.getMaxDuration() + " minute(s)"));
            this.complete();
        }
        return this.stopped;
    }

    public boolean isTerminated() {
        return this.threadPool.isTerminated();
    }

    public void addSpiderListener(SpiderListener listener) {
        this.listeners.add(listener);
    }

    public void removeSpiderListener(SpiderListener listener) {
        this.listeners.remove(listener);
    }

    protected synchronized void notifyListenersSpiderProgress(int percentageComplete, int numberCrawled, int numberToCrawl) {
        for (SpiderListener l : this.listeners) {
            l.spiderProgress(percentageComplete, numberCrawled, numberToCrawl);
        }
    }

    protected synchronized void notifyListenersFoundURI(String uri, String method, FetchFilter.FetchStatus status) {
        for (SpiderListener l : this.listeners) {
            l.foundURI(uri, method, status);
        }
    }

    protected synchronized void notifyListenersSpiderTaskResult(SpiderTaskResult result) {
        for (SpiderListener l : this.listeners) {
            l.notifySpiderTaskResult(result);
        }
    }

    protected synchronized void notifyListenersSpiderComplete(boolean successful) {
        for (SpiderListener l : this.listeners) {
            l.spiderComplete(successful);
        }
    }

    public void addCustomParser(SpiderParser sp) {
        this.controller.addSpiderParser(sp);
    }

    private static class SpiderThreadFactory
    implements ThreadFactory {
        private final AtomicInteger threadNumber = new AtomicInteger(1);
        private final String namePrefix;
        private final ThreadGroup group;

        public SpiderThreadFactory(String namePrefix) {
            this.namePrefix = namePrefix;
            SecurityManager s = System.getSecurityManager();
            this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
            if (t.isDaemon()) {
                t.setDaemon(false);
            }
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }
    }
}

