/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.xtal;

import javajs.util.DF;
import javajs.util.PT;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.util.Logger;

public class DmolReader
extends AtomSetCollectionReader {
    private float[] unitCellData;
    private Double totE;
    private boolean geomOpt;

    protected boolean checkLine() throws Exception {
        if (this.line.contains("** GEOMETRY OPTIMIZATION IN DELOCALIZED COORDINATES **")) {
            this.geomOpt = true;
        } else if (this.line.contains("INCOOR, atomic coordinates")) {
            this.geomOpt = false;
        } else if (!this.geomOpt ? this.line.contains("$cell vectors") : this.line.contains("Lattice:")) {
            this.readCellParam();
        } else if (!this.geomOpt ? this.line.contains("$coordinates") : this.line.contains("Input Coordinates")) {
            this.readCoord();
        } else if (this.line.contains(" Total Energy")) {
            this.readEnergy();
        } else if (this.line.contains("Frequencies (cm-1)")) {
            this.readFreq();
        }
        return true;
    }

    private void readCellParam() throws Exception {
        this.unitCellData = new float[9];
        int i = 0;
        for (int n = 0; n < 3; ++n) {
            String[] tokens = PT.getTokens((String)this.rd());
            this.unitCellData[i++] = this.parseFloatStr(!this.geomOpt ? tokens[0] : tokens[4]) * 0.5291772f;
            this.unitCellData[i++] = this.parseFloatStr(!this.geomOpt ? tokens[1] : tokens[5]) * 0.5291772f;
            this.unitCellData[i++] = this.parseFloatStr(!this.geomOpt ? tokens[2] : tokens[6]) * 0.5291772f;
        }
    }

    private void newAtomSet() throws Exception {
        this.applySymmetryAndSetTrajectory();
        this.asc.newAtomSet();
        if (this.totE != null) {
            this.setEnergy();
        }
        this.doApplySymmetry = true;
        if (this.unitCellData != null) {
            this.addExplicitLatticeVector(0, this.unitCellData, 0);
            this.addExplicitLatticeVector(1, this.unitCellData, 3);
            this.addExplicitLatticeVector(2, this.unitCellData, 6);
            this.setSpaceGroupName("P1");
        }
        this.setFractionalCoordinates(false);
    }

    private void readCoord() throws Exception {
        this.newAtomSet();
        if (this.geomOpt) {
            this.readLines(2);
        }
        while (this.rd() != null && !this.geomOpt ? !this.line.contains("$end") : !this.line.contains("-----")) {
            String[] tokens = this.getTokens();
            Atom atom = this.asc.addNewAtom();
            atom.atomName = !this.geomOpt ? tokens[0] : tokens[1];
            float factor = (float)(!this.geomOpt ? 0.529177188873291 : 1.0);
            float x = this.parseFloatStr(!this.geomOpt ? tokens[1] : tokens[2]) * factor;
            float y = this.parseFloatStr(!this.geomOpt ? tokens[2] : tokens[3]) * factor;
            float z = this.parseFloatStr(!this.geomOpt ? tokens[3] : tokens[4]) * factor;
            atom.set(x, y, z);
            this.setAtomCoord(atom);
        }
    }

    private void readEnergy() throws Exception {
        this.rd();
        if (this.line.contains("Ef")) {
            this.totE = Double.parseDouble(PT.getTokens((String)this.line.substring(this.line.indexOf("Ef") + 1, this.line.indexOf("Ha")))[1]);
        }
    }

    private void setEnergy() {
        this.asc.setAtomSetEnergy("" + this.totE, this.totE.floatValue());
        this.asc.setInfo("Energy", (Object)this.totE);
        this.asc.setAtomSetName("E = " + this.totE + " Hartree");
    }

    private void readFreq() throws Exception {
        int lastAtomCount = 0;
        int ac = this.asc.getLastAtomSetAtomCount();
        while (this.rd() != null && this.line.charAt(1) == ' ') {
            String[] tokens = this.getTokens();
            int frequencyCount = tokens.length / 2;
            float[] frequencies = new float[frequencyCount];
            int i = 1;
            int n = 0;
            while (i < tokens.length) {
                frequencies[n] = this.parseFloatStr(tokens[i]);
                if (this.debugging) {
                    Logger.debug((String)(this.vibrationNumber + n + " frequency=" + frequencies[n]));
                }
                i += 2;
                ++n;
            }
            boolean[] ignore = new boolean[frequencyCount];
            int iAtom0 = 0;
            for (int i2 = 0; i2 < frequencyCount; ++i2) {
                boolean bl = ignore[i2] = !this.doGetVibration(++this.vibrationNumber);
                if (ignore[i2]) continue;
                this.applySymmetryAndSetTrajectory();
                lastAtomCount = this.cloneLastAtomSet(ac, null);
                if (i2 == 0) {
                    iAtom0 = this.asc.getLastAtomSetAtomIndex();
                }
                this.asc.setAtomSetFrequency(this.vibrationNumber, null, null, String.valueOf(frequencies[i2]), null);
                this.asc.setAtomSetName(DF.formatDecimal((float)frequencies[i2], (int)2) + " cm-1");
            }
            this.rd();
            this.fillFrequencyData(iAtom0, ac, lastAtomCount, ignore, false, 5, 13, null, 0, null);
            this.readLines(2);
        }
    }
}

