/*
 * Decompiled with CFR 0.152.
 */
package net.sf.bt747.j2se.app.trackgraph;

import info.monitorenter.gui.chart.IAxis;
import info.monitorenter.gui.chart.IAxisLabelFormatter;
import info.monitorenter.gui.chart.ITrace2D;
import info.monitorenter.gui.chart.TracePoint2D;
import info.monitorenter.gui.chart.ZoomableChart;
import info.monitorenter.gui.chart.axis.AAxis;
import info.monitorenter.gui.chart.axis.AxisLinear;
import info.monitorenter.gui.chart.labelformatters.LabelFormatterDate;
import info.monitorenter.gui.chart.traces.Trace2DSimple;
import java.awt.Color;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TrackDisplay
extends ZoomableChart {
    private AAxis timeAxis = new AxisLinear();
    private AAxis heightAxis = new AxisLinear();
    private AAxis speedAxis = new AxisLinear();
    private ITrace2D traceHeight;
    private ITrace2D traceSpeed;

    public TrackDisplay() {
        this.timeAxis.setFormatter((IAxisLabelFormatter)new LabelFormatterDate());
        this.speedAxis.getAxisTitle().setTitleColor(Color.RED);
        this.heightAxis.getAxisTitle().setTitleColor(Color.GREEN);
        this.timeAxis.getAxisTitle().setTitle("Time");
        this.heightAxis.getAxisTitle().setTitle("Height");
        this.speedAxis.getAxisTitle().setTitle("Speed");
        this.setAxisXBottom(this.timeAxis);
        this.setAxisYLeft(this.heightAxis);
        this.setAxisYRight(this.speedAxis);
    }

    public final void showHeightTrack(Iterator<TracePoint2D> iterator) {
        TrackDisplay trackDisplay = this;
        if (trackDisplay.traceHeight != null) {
            trackDisplay.removeTrace(trackDisplay.traceHeight);
        }
        this.traceHeight = new Trace2DSimple();
        this.traceHeight.setColor(Color.GREEN);
        this.traceHeight.setName("");
        while (iterator.hasNext()) {
            this.traceHeight.addPoint(iterator.next());
        }
        this.addTrace(this.traceHeight, (IAxis)this.timeAxis, (IAxis)this.heightAxis);
    }

    public final void showSpeedTrack(Iterator<TracePoint2D> iterator) {
        TrackDisplay trackDisplay = this;
        if (trackDisplay.traceSpeed != null) {
            trackDisplay.removeTrace(trackDisplay.traceSpeed);
        }
        this.traceSpeed = new Trace2DSimple();
        this.traceSpeed.setColor(Color.RED);
        this.traceSpeed.setName("");
        while (iterator.hasNext()) {
            this.traceSpeed.addPoint(iterator.next());
        }
        this.addTrace(this.traceSpeed, (IAxis)this.timeAxis, (IAxis)this.speedAxis);
    }
}

