/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.monitoring.exporter.http;

import java.io.IOException;
import java.util.Objects;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.ResponseListener;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.xcontent.DeprecationHandler;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.XContent;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;

class HttpExportBulkResponseListener
implements ResponseListener {
    private static final Logger logger = Loggers.getLogger(HttpExportBulkResponseListener.class);
    public static final HttpExportBulkResponseListener INSTANCE = new HttpExportBulkResponseListener(XContentType.JSON.xContent());
    private final XContent xContent;

    HttpExportBulkResponseListener(XContent xContent) {
        this.xContent = Objects.requireNonNull(xContent);
    }

    public void onSuccess(Response response) {
        try (XContentParser parser = this.xContent.createParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, response.getEntity().getContent());){
            XContentParser.Token token = parser.nextToken();
            if (token == XContentParser.Token.START_OBJECT) {
                String currentFieldName = null;
                while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                    if (token == XContentParser.Token.FIELD_NAME) {
                        currentFieldName = parser.currentName();
                        continue;
                    }
                    if (token.isValue()) {
                        if (!"errors".equals(currentFieldName) || parser.booleanValue()) continue;
                        return;
                    }
                    if (token != XContentParser.Token.START_ARRAY) continue;
                    this.parseErrors(parser);
                    return;
                }
            }
        }
        catch (IOException | RuntimeException e) {
            this.onError("unexpected exception while verifying bulk response", e);
        }
    }

    private void parseErrors(XContentParser parser) throws IOException {
        XContentParser.Token token;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (!token.isValue() || !"error".equals(currentFieldName)) continue;
            this.onItemError(parser.text());
        }
    }

    public void onFailure(Exception exception) {
        this.onError("bulk request failed unexpectedly", exception);
    }

    void onError(String msg, Throwable cause) {
        logger.warn(msg, cause);
    }

    void onItemError(String text) {
        logger.warn("unexpected error while indexing monitoring document: [{}]", (Object)text);
    }
}

