/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.freecol.common.FreeColException;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.DOMMessage;
import net.sf.freecol.common.networking.MessageHandler;
import org.w3c.dom.Element;

public final class Client {
    private static final Logger logger = Logger.getLogger(Client.class.getName());
    private final Connection c;
    private final String host;
    private final int port;

    public Client(String host, int port, MessageHandler handler, String name) throws IOException {
        this.host = host;
        this.port = port;
        this.c = new Connection(host, port, handler, name);
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public Connection getConnection() {
        return this.c;
    }

    public void setMessageHandler(MessageHandler mh) {
        this.c.setMessageHandler(mh);
    }

    public void disconnect() {
        this.c.close();
    }

    public void send(DOMMessage message) throws IOException {
        this.c.send(message.toXMLElement());
    }

    public void send(Element element) throws IOException {
        this.c.send(element);
    }

    public void sendAndWait(DOMMessage message) throws IOException {
        this.c.sendAndWait(message.toXMLElement());
    }

    public void sendAndWait(Element element) throws IOException {
        this.c.sendAndWait(element);
    }

    public Element ask(DOMMessage message) throws IOException {
        return this.c.ask(message.toXMLElement());
    }

    public Element ask(Element element) throws IOException {
        return this.c.ask(element);
    }

    public Element handleReply(Element reply) {
        if (reply != null) {
            try {
                return this.c.getMessageHandler().handle(this.c, reply);
            }
            catch (FreeColException e) {
                logger.log(Level.WARNING, "Could not handle reply: " + reply, e);
            }
        }
        return null;
    }
}

