/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.openapi.util.RecursionGuard;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiLambdaExpressionType;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethodReferenceType;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.PsiTypeVisitorEx;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.impl.source.resolve.graphInference.PsiPolyExpressionUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaVarTypeUtil {
    public static final RecursionGuard ourVarGuard = RecursionManager.createGuard("var.guard");

    public static PsiType getUpwardProjection(@NotNull PsiType t) {
        if (t == null) {
            JavaVarTypeUtil.$$$reportNull$$$0(0);
        }
        return t.accept(new UpwardProjectionTypeVisitor());
    }

    public static PsiType getDownwardProjection(@NotNull PsiType type2) {
        if (type2 == null) {
            JavaVarTypeUtil.$$$reportNull$$$0(1);
        }
        return type2.accept(new DownwardProjectionTypeVisitor());
    }

    private static boolean mentionsRestrictedTypeVariables(PsiType type2) {
        return type2.accept(new PsiTypeVisitor<Boolean>(){

            @Override
            public Boolean visitType(PsiType type2) {
                return false;
            }

            @Override
            public Boolean visitCapturedWildcardType(PsiCapturedWildcardType capturedWildcardType) {
                return true;
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "t";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/impl/source/JavaVarTypeUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getUpwardProjection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getDownwardProjection";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class DownwardProjectionTypeVisitor
    extends PsiTypeVisitor<PsiType> {
        private DownwardProjectionTypeVisitor() {
        }

        @Override
        public PsiType visitType(PsiType type2) {
            return type2;
        }

        @Override
        public PsiType visitCapturedWildcardType(PsiCapturedWildcardType capturedWildcardType) {
            return capturedWildcardType.getLowerBound().accept(this);
        }

        @Override
        public PsiType visitArrayType(PsiArrayType arrayType) {
            PsiType projection = arrayType.getComponentType().accept(this);
            if (projection == PsiType.NULL) {
                return PsiType.NULL;
            }
            return projection.createArrayType();
        }

        @Override
        public PsiType visitIntersectionType(PsiIntersectionType intersectionType) {
            PsiType[] conjuncts = (PsiType[])Arrays.stream(intersectionType.getConjuncts()).map(conjunct -> conjunct.accept(this)).toArray(PsiType[]::new);
            if (ArrayUtil.find(conjuncts, PsiType.NULL) > -1) {
                return PsiType.NULL;
            }
            return PsiIntersectionType.createIntersection(conjuncts);
        }

        @Override
        public PsiType visitLambdaExpressionType(PsiLambdaExpressionType lambdaExpressionType) {
            return lambdaExpressionType;
        }

        @Override
        public PsiType visitMethodReferenceType(PsiMethodReferenceType methodReferenceType) {
            return methodReferenceType;
        }

        @Override
        public PsiType visitClassType(PsiClassType classType) {
            PsiClassType.ClassResolveResult result2 = classType.resolveGenerics();
            PsiClass aClass2 = result2.getElement();
            if (aClass2 != null) {
                PsiSubstitutor substitutor2 = result2.getSubstitutor();
                PsiSubstitutor targetSubstitutor = PsiSubstitutor.EMPTY;
                for (PsiTypeParameter parameter : PsiUtil.typeParametersIterable(aClass2)) {
                    PsiType ai = substitutor2.substitute(parameter);
                    if (ai == null) {
                        return PsiType.NULL;
                    }
                    if (!JavaVarTypeUtil.mentionsRestrictedTypeVariables(ai)) {
                        targetSubstitutor = targetSubstitutor.put(parameter, ai);
                        continue;
                    }
                    if (ai instanceof PsiWildcardType) {
                        if (((PsiWildcardType)ai).isExtends()) {
                            PsiType extendsBound = ((PsiWildcardType)ai).getExtendsBound();
                            PsiType projection = extendsBound.accept(this);
                            if (projection == PsiType.NULL) {
                                return PsiType.NULL;
                            }
                            targetSubstitutor = targetSubstitutor.put(parameter, PsiWildcardType.createExtends(parameter.getManager(), projection));
                            continue;
                        }
                        if (((PsiWildcardType)ai).isSuper()) {
                            PsiType superBound = ((PsiWildcardType)ai).getSuperBound();
                            targetSubstitutor = targetSubstitutor.put(parameter, JavaVarTypeUtil.getUpwardProjection(superBound));
                            continue;
                        }
                        return PsiType.NULL;
                    }
                    return PsiType.NULL;
                }
                return JavaPsiFacade.getInstance(aClass2.getProject()).getElementFactory().createType(aClass2, targetSubstitutor);
            }
            return PsiType.NULL;
        }
    }

    private static class UpwardProjectionTypeVisitor
    extends PsiTypeVisitorEx<PsiType> {
        private static final RecursionGuard upwardGuard = RecursionManager.createGuard("upwardProjectionGuard");

        private UpwardProjectionTypeVisitor() {
        }

        @Override
        public PsiType visitType(PsiType type2) {
            return type2;
        }

        @Override
        @Nullable
        public PsiType visitCapturedWildcardType(PsiCapturedWildcardType capturedWildcardType) {
            return capturedWildcardType.getUpperBound().accept(this);
        }

        @Override
        public PsiType visitArrayType(PsiArrayType arrayType) {
            PsiType componentType = arrayType.getComponentType();
            return componentType.accept(this).createArrayType();
        }

        @Override
        @Nullable
        public PsiType visitLambdaExpressionType(PsiLambdaExpressionType lambdaExpressionType) {
            return lambdaExpressionType;
        }

        @Override
        public PsiType visitMethodReferenceType(PsiMethodReferenceType methodReferenceType) {
            return methodReferenceType;
        }

        @Override
        public PsiType visitIntersectionType(PsiIntersectionType intersectionType) {
            return PsiIntersectionType.createIntersection((PsiType[])Arrays.stream(intersectionType.getConjuncts()).map(conjunct -> conjunct.accept(this)).toArray(PsiType[]::new));
        }

        @Override
        public PsiType visitClassType(PsiClassType classType) {
            PsiClassType.ClassResolveResult result2 = classType.resolveGenerics();
            PsiClass aClass2 = result2.getElement();
            if (aClass2 != null) {
                PsiManager manager = aClass2.getManager();
                PsiSubstitutor targetSubstitutor = PsiSubstitutor.EMPTY;
                PsiSubstitutor substitutor2 = result2.getSubstitutor();
                for (PsiTypeParameter parameter : PsiUtil.typeParametersIterable(aClass2)) {
                    PsiType ai = substitutor2.substitute(parameter);
                    targetSubstitutor = targetSubstitutor.put(parameter, ai);
                    if (ai == null || !JavaVarTypeUtil.mentionsRestrictedTypeVariables(ai)) continue;
                    if (ai instanceof PsiWildcardType) {
                        if (((PsiWildcardType)ai).isExtends()) {
                            targetSubstitutor = targetSubstitutor.put(parameter, PsiWildcardType.createExtends(manager, ((PsiWildcardType)ai).getExtendsBound().accept(this)));
                        }
                        if (!((PsiWildcardType)ai).isSuper()) continue;
                        targetSubstitutor = targetSubstitutor.put(parameter, UpwardProjectionTypeVisitor.createDownwardProjection(manager, ((PsiWildcardType)ai).getSuperBound()));
                        continue;
                    }
                    PsiType U = upwardGuard.doPreventingRecursion(ai, true, () -> ai.accept(this));
                    if (U == null) {
                        targetSubstitutor = targetSubstitutor.put(parameter, PsiWildcardType.createUnbounded(manager));
                        continue;
                    }
                    if (!U.equalsToText("java.lang.Object") && UpwardProjectionTypeVisitor.tryUpperBound(aClass2, parameter, U)) {
                        targetSubstitutor = targetSubstitutor.put(parameter, PsiWildcardType.createExtends(manager, U));
                        continue;
                    }
                    targetSubstitutor = targetSubstitutor.put(parameter, UpwardProjectionTypeVisitor.createDownwardProjection(manager, ai));
                }
                return JavaPsiFacade.getInstance(aClass2.getProject()).getElementFactory().createType(aClass2, targetSubstitutor);
            }
            return classType;
        }

        private static PsiWildcardType createDownwardProjection(PsiManager manager, PsiType bound) {
            PsiType downwardProjection = JavaVarTypeUtil.getDownwardProjection(bound);
            return downwardProjection != PsiType.NULL ? PsiWildcardType.createSuper(manager, downwardProjection) : PsiWildcardType.createUnbounded(manager);
        }

        private static boolean tryUpperBound(PsiClass aClass2, PsiTypeParameter parameter, PsiType U) {
            PsiType[] extendsListTypes = parameter.getExtendsListTypes();
            if (extendsListTypes.length == 0) {
                return true;
            }
            PsiType bi = PsiIntersectionType.createIntersection(extendsListTypes);
            return PsiPolyExpressionUtil.mentionsTypeParameters(bi, ContainerUtil.newHashSet(aClass2.getTypeParameters())) != false || !U.isAssignableFrom(bi);
        }
    }
}

