/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.attach.spi;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.lib.profiler.common.integration.IntegrationUtils;
import org.netbeans.modules.profiler.attach.providers.TargetPlatformEnum;

public abstract class AbstractRemotePackExporter {
    private static final Map<String, String> scriptMapper = new HashMap<String, String>(){
        {
            this.put(IntegrationUtils.PLATFORM_LINUX_AMD64_OS, "linuxamd64");
            this.put(IntegrationUtils.PLATFORM_LINUX_OS, "linux");
            this.put(IntegrationUtils.PLATFORM_LINUX_ARM_OS, "linuxarm");
            this.put(IntegrationUtils.PLATFORM_LINUX_ARM_VFP_HFLT_OS, "linuxarmvfphflt");
            this.put(IntegrationUtils.PLATFORM_MAC_OS, "mac");
            this.put(IntegrationUtils.PLATFORM_SOLARIS_AMD64_OS, "solamd64");
            this.put(IntegrationUtils.PLATFORM_SOLARIS_INTEL_OS, "solx86");
            this.put(IntegrationUtils.PLATFORM_SOLARIS_SPARC_OS, "solsparc");
            this.put(IntegrationUtils.PLATFORM_SOLARIS_SPARC64_OS, "solsparcv9");
            this.put(IntegrationUtils.PLATFORM_WINDOWS_AMD64_OS, "winamd64");
            this.put(IntegrationUtils.PLATFORM_WINDOWS_OS, "win");
        }
    };
    private static final Map<String, String> jdkMapper = new HashMap<String, String>(){
        {
            this.put(TargetPlatformEnum.JDK5.toString(), "15");
            this.put(TargetPlatformEnum.JDK6.toString(), "15");
            this.put(TargetPlatformEnum.JDK7.toString(), "15");
            this.put(TargetPlatformEnum.JDK8.toString(), "15");
            this.put(TargetPlatformEnum.JDK9.toString(), "15");
            this.put(TargetPlatformEnum.JDK10.toString(), "15");
            this.put(TargetPlatformEnum.JDK_CVM.toString(), "cvm");
        }
    };

    protected final String getPlatformShort(String string) {
        return scriptMapper.get(string);
    }

    protected final String getJVMShort(String string) {
        return jdkMapper.get(string);
    }

    public abstract String export(String var1, String var2, String var3) throws IOException;

    public abstract String getRemotePackPath(String var1, String var2);
}

