#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: io-streams
version: 1.5.0.1
id: io-streams-1.5.0.1-2bVNxAA2r1O57zSFpx0loj
key: io-streams-1.5.0.1-2bVNxAA2r1O57zSFpx0loj
license: BSD-3-Clause
maintainer: Gregory Collins <greg@gregorycollins.net>
synopsis: Simple, composable, and easy-to-use stream I/O
description:
    /Overview/
    .
    The io-streams library contains simple and easy-to-use primitives for I/O
    using streams. Most users will want to import the top-level convenience
    module "System.IO.Streams", which re-exports most of the library:
    .
    @
    import           System.IO.Streams (InputStream, OutputStream)
    import qualified System.IO.Streams as Streams
    @
    .
    For first-time users, @io-streams@ comes with an included tutorial, which can
    be found in the "System.IO.Streams.Tutorial" module.
    .
    /Features/
    .
    The @io-streams@ user API has two basic types: @InputStream a@ and
    @OutputStream a@, and three fundamental I/O primitives:
    .
    @
    \-\- read an item from an input stream
    Streams.read :: InputStream a -> IO (Maybe a)
    .
    \-\- push an item back to an input stream
    Streams.unRead :: a -> InputStream a -> IO ()
    .
    \-\- write to an output stream
    Streams.write :: Maybe a -> OutputStream a -> IO ()
    @
    .
    Streams can be transformed by composition and hooked together with provided combinators:
    .
    @
    ghci> Streams.fromList [1,2,3::Int] >>= Streams.map (*10) >>= Streams.toList
    [10,20,30]
    @
    .
    Stream composition leaves the original stream accessible:
    .
    @
    ghci> input \<- Streams.fromByteString \"long string\"
    ghci> wrapped \<- Streams.takeBytes 4 input
    ghci> Streams.read wrapped
    Just \"long\"
    ghci> Streams.read wrapped
    Nothing
    ghci> Streams.read input
    Just \" string\"
    @
    .
    Simple types and operations in the IO monad mean straightforward and simple
    exception handling and resource cleanup using Haskell standard library
    facilities like '\''Control.Exception.bracket'\''.
    .
    @io-streams@ comes with:
    .
    * functions to use files, handles, concurrent channels, sockets, lists,
    vectors, and more as streams.
    .
    * a variety of combinators for wrapping and transforming streams, including
    compression and decompression using zlib, controlling precisely how many
    bytes are read from or written to a stream, buffering output using
    bytestring builders, folds, maps, filters, zips, etc.
    .
    * support for parsing from streams using @attoparsec@.
    .
    * support for spawning processes and communicating with them using streams.
category: Data, Network, IO-Streams
abi: c29d11fe530951aff4dc7b9acd92aa68
exposed: True
exposed-modules:
    System.IO.Streams System.IO.Streams.Attoparsec
    System.IO.Streams.Attoparsec.ByteString
    System.IO.Streams.Attoparsec.Text System.IO.Streams.Builder
    System.IO.Streams.ByteString System.IO.Streams.Combinators
    System.IO.Streams.Concurrent System.IO.Streams.Core
    System.IO.Streams.Debug System.IO.Streams.File
    System.IO.Streams.Handle System.IO.Streams.Internal
    System.IO.Streams.List System.IO.Streams.Network
    System.IO.Streams.Process System.IO.Streams.Text
    System.IO.Streams.Tutorial System.IO.Streams.Vector
    System.IO.Streams.Zlib
hidden-modules: System.IO.Streams.Internal.Attoparsec
                System.IO.Streams.Internal.Network
                System.IO.Streams.Internal.Search
import-dirs: /usr/lib/ghc-8.4.3/site-local/io-streams-1.5.0.1
library-dirs: /usr/lib/ghc-8.4.3/site-local/io-streams-1.5.0.1
dynamic-library-dirs: /usr/lib
data-dir: /usr/share/arm-linux-ghc-8.4.3/io-streams-1.5.0.1
hs-libraries: HSio-streams-1.5.0.1-2bVNxAA2r1O57zSFpx0loj
depends:
    base-4.11.1.0 attoparsec-0.13.2.2-5oKqcFqqk8HLoRElqn64fK
    bytestring-0.10.8.2 network-2.7.0.2-8yE8vwBlEy1KZPVD4sTAn
    primitive-0.6.4.0-39Pwmm1zkQX6bM7xFUT3Jc process-1.6.3.0
    text-1.2.3.0 time-1.8.0.2 transformers-0.5.5.0
    vector-0.12.0.1-1fezwShzdEfG3Hp1Pmvjkq
    zlib-bindings-0.1.1.5-CMc0gmEf9KxDLMXiCfo5nN
abi-depends: base-4.11.1.0=a3fb1645bafaa89172454c2eea8dfdc9
             attoparsec-0.13.2.2-5oKqcFqqk8HLoRElqn64fK=fff7ae21f45c1b0af12007963cebbf81
             bytestring-0.10.8.2=9faa89cf4769cbd12751f8644ca9e618
             network-2.7.0.2-8yE8vwBlEy1KZPVD4sTAn=90fa8650caae170586ac66be24e6a39f
             primitive-0.6.4.0-39Pwmm1zkQX6bM7xFUT3Jc=0a8d9e3ca28de3a4ac62e5f0044fa23c
             process-1.6.3.0=b58285e21ceee9f67d7be28ddb8b2627
             text-1.2.3.0=9752fd647a108be49a4cb0c2a4456f2b
             time-1.8.0.2=042930fb6746cbaf3bc794f817f8a6b2
             transformers-0.5.5.0=4f41484af13f560f1d83ed79e1be4572
             vector-0.12.0.1-1fezwShzdEfG3Hp1Pmvjkq=8ec9732a4c43da9ed60d7a7b8971b540
             zlib-bindings-0.1.1.5-CMc0gmEf9KxDLMXiCfo5nN=3377dd69ba23f1aa073743bd2499c269
haddock-interfaces: /usr/share/doc/haskell-io-streams/html/io-streams.haddock
haddock-html: /usr/share/doc/haskell-io-streams/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

