#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: idris
version: 1.3.0
id: idris-1.3.0-5xx6ReAA4evA70rX7SRU5w
key: idris-1.3.0-5xx6ReAA4evA70rX7SRU5w
license: BSD-3-Clause
maintainer: Edwin Brady <eb@cs.st-andrews.ac.uk>
author: Edwin Brady
stability: Beta
homepage: http://www.idris-lang.org/
synopsis: Functional Programming Language with Dependent Types
description:
    Idris is a general purpose language with full dependent types.
    It is compiled, with eager evaluation.
    Dependent types allow types to be predicated on values,
    meaning that some aspects of a program'\''s behaviour can be
    specified precisely in the type. The language is closely
    related to Epigram and Agda. There is a tutorial at
    <http://www.idris-lang.org/documentation>.
    Features include:
    .
    * Full, first class, dependent types with dependent pattern matching
    .
    * where clauses, with rule, case expressions,
    pattern matching let and lambda bindings
    .
    * Interfaces (similar to type classes), monad comprehensions
    .
    * do notation, idiom brackets, syntactic conveniences for lists,
    tuples, dependent pairs
    .
    * Totality checking
    .
    * Coinductive types
    .
    * Indentation significant syntax, extensible syntax
    .
    * Cumulative universes
    .
    * Simple foreign function interface (to C)
    .
    * Hugs style interactive environment
category: Compilers/Interpreters, Dependent Types
abi: f478f91ec6eabdbf3f18fe2e19a8efa8
exposed: True
exposed-modules:
    IRTS.Bytecode IRTS.CodegenC IRTS.CodegenCommon
    IRTS.CodegenJavaScript IRTS.Compiler IRTS.Defunctionalise
    IRTS.DumpBC IRTS.Exports IRTS.Inliner IRTS.JavaScript.AST
    IRTS.JavaScript.Codegen IRTS.JavaScript.LangTransforms
    IRTS.JavaScript.Name IRTS.JavaScript.PrimOp
    IRTS.JavaScript.Specialize IRTS.Lang IRTS.LangOpts IRTS.Portable
    IRTS.Simplified IRTS.System Idris.ASTUtils Idris.AbsSyntax
    Idris.AbsSyntaxTree Idris.Apropos Idris.CaseSplit Idris.Chaser
    Idris.CmdOptions Idris.Colours Idris.Completion Idris.Core.Binary
    Idris.Core.CaseTree Idris.Core.Constraints Idris.Core.DeepSeq
    Idris.Core.Elaborate Idris.Core.Evaluate Idris.Core.Execute
    Idris.Core.ProofState Idris.Core.ProofTerm Idris.Core.TT
    Idris.Core.Typecheck Idris.Core.Unify Idris.Core.WHNF
    Idris.Coverage Idris.DSL Idris.DataOpts Idris.DeepSeq
    Idris.Delaborate Idris.Directives Idris.Docs Idris.Docstrings
    Idris.Elab.AsPat Idris.Elab.Clause Idris.Elab.Data
    Idris.Elab.Implementation Idris.Elab.Interface Idris.Elab.Provider
    Idris.Elab.Quasiquote Idris.Elab.Record Idris.Elab.Rewrite
    Idris.Elab.RunElab Idris.Elab.Term Idris.Elab.Transform
    Idris.Elab.Type Idris.Elab.Utils Idris.Elab.Value Idris.ElabDecls
    Idris.Erasure Idris.ErrReverse Idris.Error Idris.Help Idris.IBC
    Idris.IdeMode Idris.IdrisDoc Idris.Imports Idris.Info
    Idris.Info.Show Idris.Inliner Idris.Interactive Idris.Main
    Idris.ModeCommon Idris.Options Idris.Output Idris.Package
    Idris.Package.Common Idris.Package.Parser Idris.Parser
    Idris.Parser.Data Idris.Parser.Expr Idris.Parser.Helpers
    Idris.Parser.Ops Idris.Parser.Stack Idris.PartialEval
    Idris.Primitives Idris.ProofSearch Idris.Prover Idris.Providers
    Idris.REPL Idris.REPL.Browse Idris.REPL.Commands Idris.REPL.Parser
    Idris.Reflection Idris.Termination Idris.Transforms
    Idris.TypeSearch Idris.Unlit Idris.WhoCalls Util.DynamicLinker
    Util.ScreenSize Util.System
hidden-modules: Util.Pretty Util.Net Paths_idris Version_idris
                Tools_idris BuildFlags_idris
import-dirs: /usr/lib/ghc-8.4.3/site-local/idris-1.3.0
library-dirs: /usr/lib/ghc-8.4.3/site-local/idris-1.3.0
dynamic-library-dirs: /usr/lib
data-dir: /usr/share/idris
hs-libraries: HSidris-1.3.0-5xx6ReAA4evA70rX7SRU5w
extra-libraries:
    gmp
depends:
    base-4.11.1.0 aeson-1.4.0.0-2fzGzKiyJUwJpJnaq3iWXS
    annotated-wl-pprint-0.7.0-5EJhaPPvnKODWMqVOHKqvI
    ansi-terminal-0.8.0.4-4zlOvCKnE9eI77dRbIqIB1
    ansi-wl-pprint-0.6.8.2-6AdIxh22sHDEM4okAgCrQl array-0.5.2.0
    base64-bytestring-1.0.0.1-4OCIe2BZn8jKI191JIXI37 binary-0.8.5.1
    blaze-html-0.9.1.1-EgxdH3AtVL83pCluZdDgeJ
    blaze-markup-0.8.2.1-FFkiru1HsegAfMrnqJMDug bytestring-0.10.8.2
    cheapskate-0.1.1-5190j010uHtL8pDxz1xyE3
    code-page-0.1.3-78bf3rlibAi1l7KbTfbq3V containers-0.5.11.0
    deepseq-1.4.3.0 directory-1.3.1.5 filepath-1.4.2
    fingertree-0.1.4.1-HmFEiqqfleoCidIW1IniJ7 haskeline-0.7.4.2
    ieee754-0.8.0-KmEF4YGiqmIDu40b1SLx46
    megaparsec-6.5.0-9fDsdAcGz2jKB79whUasUP mtl-2.2.2
    network-2.7.0.2-8yE8vwBlEy1KZPVD4sTAn
    optparse-applicative-0.14.2.0-AIlRv3oqRnL3QRzeNDiQLx pretty-1.1.3.6
    process-1.6.3.0 regex-tdfa-1.2.3.1-az1JL7mhmZBLFmoReK21K
    safe-0.3.17-HEmZRpXGD3s2ywM3rHJ1ur
    split-0.2.3.3-DYHuRk05Zl3FsXrGVgC4fG
    terminal-size-0.3.2.1-KN6K6Ef1GMWIEqS2qb6D5y text-1.2.3.0
    time-1.8.0.2 transformers-0.5.5.0
    uniplate-1.6.12-6qL4xKqlm0u98UwpIwKcfK
    unordered-containers-0.2.9.0-KfM11vwfv9j3BnvMvjdQDd
    utf8-string-1.0.1.1-LRSjvSC6FZkKPp48Qszoj8
    vector-0.12.0.1-1fezwShzdEfG3Hp1Pmvjkq
    vector-binary-instances-0.2.4-DozAADK9jE3EJNfe3MCYFT
    zip-archive-0.3.3-L4ZC1cFPAYN6WrYIJru0lg
    fsnotify-0.3.0.1-HQztvTKbc3fK0tDptA2c5
    async-2.2.1-B6m2kYywRJu7nicgTBxsJe unix-2.7.2.2
    libffi-0.1-KciznLKKFMTLZ0dw70VJSt
abi-depends: base-4.11.1.0=a3fb1645bafaa89172454c2eea8dfdc9
             aeson-1.4.0.0-2fzGzKiyJUwJpJnaq3iWXS=1a1b9e384095a5a09c623b25305bd94d
             annotated-wl-pprint-0.7.0-5EJhaPPvnKODWMqVOHKqvI=9b20128a6c9fe2f756d9a70be779da0b
             ansi-terminal-0.8.0.4-4zlOvCKnE9eI77dRbIqIB1=3720aeddf087c27668b5c651df34c2d3
             ansi-wl-pprint-0.6.8.2-6AdIxh22sHDEM4okAgCrQl=9d4f369601ee2b22ce73b0afa89e8002
             array-0.5.2.0=dc85b03ee806d784249cc791da6109c3
             base64-bytestring-1.0.0.1-4OCIe2BZn8jKI191JIXI37=65adc4f5f54a1c07291b4ebc49756c05
             binary-0.8.5.1=0c28e4e382bf1405fd468e0d2a2b58e5
             blaze-html-0.9.1.1-EgxdH3AtVL83pCluZdDgeJ=26d7d7bc6469699c9d8f038081c294ce
             blaze-markup-0.8.2.1-FFkiru1HsegAfMrnqJMDug=71b515c6e3bfb99ff0075cc129b1fc3b
             bytestring-0.10.8.2=9faa89cf4769cbd12751f8644ca9e618
             cheapskate-0.1.1-5190j010uHtL8pDxz1xyE3=b94eb6bc151e17cfbea514d5596033cb
             code-page-0.1.3-78bf3rlibAi1l7KbTfbq3V=ac79c284619ed805973e8a29b0490575
             containers-0.5.11.0=94bb4831ae701bd40855b2dc2d65cf7c
             deepseq-1.4.3.0=34da2d42d10eacba0aad99c95b538637
             directory-1.3.1.5=f5fa3aef63d61d9b32ef25d211ef137f
             filepath-1.4.2=2408ba322304c0a06810db2d7363214a
             fingertree-0.1.4.1-HmFEiqqfleoCidIW1IniJ7=9893952c5073babf8034ac3342c0c615
             haskeline-0.7.4.2=e6153d219f5fb7b64fb712b63f016a25
             ieee754-0.8.0-KmEF4YGiqmIDu40b1SLx46=9f6b114ae6eb47237e10ea290c9398cc
             megaparsec-6.5.0-9fDsdAcGz2jKB79whUasUP=4897ba923263a1dfa00db5b44d9c1de5
             mtl-2.2.2=0b3b35c3b96c7607606ed10087c4aa4a
             network-2.7.0.2-8yE8vwBlEy1KZPVD4sTAn=90fa8650caae170586ac66be24e6a39f
             optparse-applicative-0.14.2.0-AIlRv3oqRnL3QRzeNDiQLx=122fe1d9115c41827cd61505838d2602
             pretty-1.1.3.6=3c31686bd534e1773b954ae82713db97
             process-1.6.3.0=b58285e21ceee9f67d7be28ddb8b2627
             regex-tdfa-1.2.3.1-az1JL7mhmZBLFmoReK21K=98feb6ae4c5e833326f77c1995f4743b
             safe-0.3.17-HEmZRpXGD3s2ywM3rHJ1ur=42026212d0dad8beaed25fde58365be8
             split-0.2.3.3-DYHuRk05Zl3FsXrGVgC4fG=cdf77c47c599317cfa01d2d98185c5d3
             terminal-size-0.3.2.1-KN6K6Ef1GMWIEqS2qb6D5y=e02b4a9f9e625ad33d6a73f3ba82bfb9
             text-1.2.3.0=9752fd647a108be49a4cb0c2a4456f2b
             time-1.8.0.2=042930fb6746cbaf3bc794f817f8a6b2
             transformers-0.5.5.0=4f41484af13f560f1d83ed79e1be4572
             uniplate-1.6.12-6qL4xKqlm0u98UwpIwKcfK=5ce9ecb4c4bd2a035e84875708f762ba
             unordered-containers-0.2.9.0-KfM11vwfv9j3BnvMvjdQDd=4d1dd6bd73dbf55dc13ef767664a6e82
             utf8-string-1.0.1.1-LRSjvSC6FZkKPp48Qszoj8=03d2b6edbbe4042d502eabc2ba3840fc
             vector-0.12.0.1-1fezwShzdEfG3Hp1Pmvjkq=8ec9732a4c43da9ed60d7a7b8971b540
             vector-binary-instances-0.2.4-DozAADK9jE3EJNfe3MCYFT=a05eda2525e053256908ffd96812f0de
             zip-archive-0.3.3-L4ZC1cFPAYN6WrYIJru0lg=c613914dcefe342d62ec256103a2cbf4
             fsnotify-0.3.0.1-HQztvTKbc3fK0tDptA2c5=8b087956bb200e1108343ebceb0c2977
             async-2.2.1-B6m2kYywRJu7nicgTBxsJe=32776142fda961cc693aa4db742773f9
             unix-2.7.2.2=f81aa481840dadf9c364a1cea96978c0
             libffi-0.1-KciznLKKFMTLZ0dw70VJSt=fcdb79951df3b23d7fe0b4923f7b2ffb
haddock-interfaces: /usr/share/doc/idris/html/idris.haddock
haddock-html: /usr/share/doc/idris/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

