/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.lm.values;

import edu.berkeley.nlp.lm.array.CustomWidthArray;
import edu.berkeley.nlp.lm.bits.BitList;
import edu.berkeley.nlp.lm.bits.BitStream;
import edu.berkeley.nlp.lm.collections.Indexer;
import edu.berkeley.nlp.lm.collections.LongToIntHashMap;
import edu.berkeley.nlp.lm.util.Annotations;
import edu.berkeley.nlp.lm.util.Logger;
import edu.berkeley.nlp.lm.values.ProbBackoffPair;
import edu.berkeley.nlp.lm.values.ProbBackoffValueContainer;
import edu.berkeley.nlp.lm.values.RankedValueContainer;
import edu.berkeley.nlp.lm.values.ValueContainer;
import java.util.List;

public final class CompressibleProbBackoffValueContainer
extends RankedValueContainer<ProbBackoffPair>
implements ProbBackoffValueContainer {
    private static final long serialVersionUID = 964277160049236607L;
    @Annotations.PrintMemoryCount
    final float[] backoffsForRank;
    @Annotations.PrintMemoryCount
    final float[] probsForRank;
    private int backoffWidth = -1;
    private transient Indexer<Float> probIndexer = new Indexer();
    private transient Indexer<Float> backoffIndexer = new Indexer();

    public CompressibleProbBackoffValueContainer(LongToIntHashMap countCounter, int valueRadix, boolean storePrefixes, long[] numNgramsForEachOrder) {
        super(valueRadix, storePrefixes, numNgramsForEachOrder);
        Logger.startTrack("Storing values", new Object[0]);
        boolean hasDefaultVal = countCounter.get(this.getDefaultVal().asLong(), -1) >= 0;
        List<LongToIntHashMap.Entry> objectsSortedByValue = countCounter.getObjectsSortedByValue(true);
        LongToIntHashMap probSorter = new LongToIntHashMap();
        LongToIntHashMap backoffSorter = new LongToIntHashMap();
        for (LongToIntHashMap.Entry e : objectsSortedByValue) {
            probSorter.incrementCount((long)Float.floatToIntBits(ProbBackoffPair.probOf(e.key)) & 0xFFFFFFFFL, e.value);
            backoffSorter.incrementCount((long)Float.floatToIntBits(ProbBackoffPair.backoffOf(e.key)) & 0xFFFFFFFFL, e.value);
        }
        for (LongToIntHashMap.Entry probEntry : probSorter.getObjectsSortedByValue(true)) {
            this.probIndexer.getIndex(Float.valueOf(Float.intBitsToFloat((int)probEntry.key)));
            if (hasDefaultVal || this.probIndexer.size() != 10) continue;
            this.probIndexer.getIndex(Float.valueOf(this.getDefaultVal().prob));
        }
        if (!hasDefaultVal && this.probIndexer.size() < 10) {
            this.probIndexer.getIndex(Float.valueOf(this.getDefaultVal().prob));
        }
        for (LongToIntHashMap.Entry backoffEntry : backoffSorter.getObjectsSortedByValue(true)) {
            this.backoffIndexer.getIndex(Float.valueOf(Float.intBitsToFloat((int)backoffEntry.key)));
            if (hasDefaultVal || this.backoffIndexer.size() != 10) continue;
            this.backoffIndexer.getIndex(Float.valueOf(this.getDefaultVal().backoff));
        }
        if (!hasDefaultVal && this.backoffIndexer.size() < 10) {
            this.backoffIndexer.getIndex(Float.valueOf(this.getDefaultVal().backoff));
        }
        this.probsForRank = new float[this.probIndexer.size()];
        int a = 0;
        for (float f : this.probIndexer.getObjects()) {
            this.probsForRank[a++] = f;
        }
        this.backoffsForRank = new float[this.backoffIndexer.size()];
        int b = 0;
        for (float f : this.backoffIndexer.getObjects()) {
            this.backoffsForRank[b++] = f;
        }
        this.backoffWidth = CustomWidthArray.numBitsNeeded(this.backoffIndexer.size());
        this.valueWidth = CustomWidthArray.numBitsNeeded(this.probIndexer.size()) + this.backoffWidth;
        Logger.logss("Storing count indices using " + this.valueWidth + " bits.");
        Logger.endTrack();
    }

    private long combine(int dprobIndex, int dbackoffIndex) {
        assert (dprobIndex >= 0);
        assert (dbackoffIndex >= 0);
        return (long)dprobIndex << this.backoffWidth | (long)dbackoffIndex;
    }

    private int backoffRankOf(long val) {
        return (int)(val & (1L << this.backoffWidth) - 1L);
    }

    private int probRankOf(long val) {
        return (int)(val >>> this.backoffWidth);
    }

    public CompressibleProbBackoffValueContainer(int valueRadix, boolean storePrefixIndexes, long[] numNgramsForEachOrder, float[] probsForRank, float[] backoffsForRank, Indexer<Float> probIndexer, int wordWidth, Indexer<Float> backoffIndexer, int backoffWidth) {
        super(valueRadix, storePrefixIndexes, numNgramsForEachOrder);
        this.backoffsForRank = backoffsForRank;
        this.probIndexer = probIndexer;
        this.backoffIndexer = backoffIndexer;
        this.probsForRank = probsForRank;
        this.valueWidth = wordWidth;
        this.backoffWidth = backoffWidth;
    }

    public CompressibleProbBackoffValueContainer createFreshValues(long[] numNgramsForEachOrder_) {
        return new CompressibleProbBackoffValueContainer(this.valueRadix, this.storeSuffixIndexes, numNgramsForEachOrder_, this.probsForRank, this.backoffsForRank, this.probIndexer, this.valueWidth, this.backoffIndexer, this.backoffWidth);
    }

    @Override
    public final float getProb(int ngramOrder, long index) {
        return this.getCount(ngramOrder, index, false);
    }

    public final long getInternalVal(int ngramOrder, long index) {
        return this.valueRanks[ngramOrder].get(index);
    }

    public final float getProb(CustomWidthArray valueRanksForOrder, long index) {
        return this.getCount(valueRanksForOrder, index, false);
    }

    @Override
    public void getFromOffset(long index, int ngramOrder, @Annotations.OutputParameter ProbBackoffPair outputVal) {
        long rank = this.getRank(ngramOrder, index);
        this.getFromRank(rank, outputVal);
    }

    private float getCount(int ngramOrder, long index, boolean backoff) {
        long rank = this.getRank(ngramOrder, index);
        return this.getFromRank(rank, backoff);
    }

    private float getCount(CustomWidthArray valueRanksForOrder, long index, boolean backoff) {
        long rank = valueRanksForOrder.get(index);
        return this.getFromRank(rank, backoff);
    }

    private float getFromRank(long val, boolean backoff) {
        return backoff ? this.backoffsForRank[this.backoffRankOf(val)] : this.probsForRank[this.probRankOf(val)];
    }

    @Override
    public final float getBackoff(int ngramOrder, long index) {
        return this.getCount(ngramOrder, index, true);
    }

    public final float getBackoff(CustomWidthArray valueRanksForNgramOrder, long index) {
        return this.getCount(valueRanksForNgramOrder, index, true);
    }

    @Override
    protected ProbBackoffPair getDefaultVal() {
        return new ProbBackoffPair(Float.NaN, Float.NaN);
    }

    @Override
    protected void getFromRank(long rank, @Annotations.OutputParameter ProbBackoffPair outputVal) {
        outputVal.prob = this.getFromRank(rank, false);
        outputVal.backoff = this.getFromRank(rank, true);
    }

    @Override
    public ProbBackoffPair getScratchValue() {
        return new ProbBackoffPair(Float.NaN, Float.NaN);
    }

    @Override
    public void setFromOtherValues(ValueContainer<ProbBackoffPair> o) {
        super.setFromOtherValues(o);
        this.backoffIndexer = ((CompressibleProbBackoffValueContainer)o).backoffIndexer;
        this.probIndexer = ((CompressibleProbBackoffValueContainer)o).probIndexer;
    }

    @Override
    public void trim() {
        super.trim();
        this.probIndexer = null;
        this.backoffIndexer = null;
    }

    @Override
    protected long getCountRank(long val) {
        return this.combine(this.probIndexer.getIndex(Float.valueOf(ProbBackoffPair.probOf(val))), this.backoffIndexer.getIndex(Float.valueOf(ProbBackoffPair.backoffOf(val))));
    }

    @Override
    public BitList getCompressed(long offset, int ngramOrder) {
        long rank = this.getRank(ngramOrder, offset);
        BitList probBits = this.valueCoder.compress(this.probRankOf(rank));
        if (ngramOrder < this.numNgramsForEachOrder.length - 1) {
            probBits.addAll(this.valueCoder.compress(this.backoffRankOf(rank)));
        }
        return probBits;
    }

    @Override
    public final void decompress(BitStream bits, int ngramOrder, boolean justConsume, @Annotations.OutputParameter ProbBackoffPair outputVal) {
        long backoffRank;
        long probRank = this.valueCoder.decompress(bits);
        long l = backoffRank = ngramOrder < this.numNgramsForEachOrder.length - 1 ? this.valueCoder.decompress(bits) : -1L;
        if (justConsume) {
            return;
        }
        if (outputVal != null) {
            outputVal.prob = this.probsForRank[(int)probRank];
            outputVal.backoff = ngramOrder < this.numNgramsForEachOrder.length - 1 ? this.backoffsForRank[(int)backoffRank] : 0.0f;
        }
    }
}

