/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.frame.individual;

import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.model.inference.ReasonerPreferences;
import org.protege.editor.owl.ui.editor.OWLIndividualSetEditor;
import org.protege.editor.owl.ui.editor.OWLObjectEditor;
import org.protege.editor.owl.ui.frame.AbstractOWLFrameSection;
import org.protege.editor.owl.ui.frame.OWLFrame;
import org.protege.editor.owl.ui.frame.OWLFrameSectionRow;
import org.protege.editor.owl.ui.frame.individual.OWLSameIndividualsAxiomFrameSectionRow;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;

public class OWLSameIndividualsAxiomFrameSection
extends AbstractOWLFrameSection<OWLNamedIndividual, OWLSameIndividualAxiom, Set<OWLNamedIndividual>> {
    public static final String LABEL = "Same Individual As";

    public OWLSameIndividualsAxiomFrameSection(OWLEditorKit editorKit, OWLFrame<? extends OWLNamedIndividual> frame) {
        super(editorKit, LABEL, LABEL, frame);
    }

    @Override
    protected void clear() {
    }

    @Override
    protected void refill(OWLOntology ontology) {
        for (OWLSameIndividualAxiom ax : ontology.getSameIndividualAxioms((OWLIndividual)this.getRootObject())) {
            this.addRow(new OWLSameIndividualsAxiomFrameSectionRow(this.getOWLEditorKit(), this, ontology, (OWLNamedIndividual)this.getRootObject(), ax));
        }
    }

    @Override
    protected void refillInferred() {
        this.getOWLModelManager().getReasonerPreferences().executeTask(ReasonerPreferences.OptionalInferenceTask.SHOW_INFERRED_SAMEAS_INDIVIDUAL_ASSERTIONS, () -> {
            if (!this.getOWLModelManager().getReasoner().isConsistent()) {
                return;
            }
            Set<OWLIndividual> existingSameIndividuals = this.getCurrentlyDisplayedSameIndividuals();
            HashSet<Object> newSameIndividuals = new HashSet<Object>();
            for (OWLNamedIndividual i : this.getCurrentReasoner().getSameIndividuals((OWLNamedIndividual)this.getRootObject()).getEntities()) {
                if (i.equals(this.getRootObject()) || existingSameIndividuals.contains(i)) continue;
                newSameIndividuals.add(i);
            }
            if (!newSameIndividuals.isEmpty()) {
                newSameIndividuals.add(this.getRootObject());
                this.addRow(new OWLSameIndividualsAxiomFrameSectionRow(this.getOWLEditorKit(), this, null, (OWLNamedIndividual)this.getRootObject(), this.getOWLDataFactory().getOWLSameIndividualAxiom(newSameIndividuals)));
            }
        });
    }

    public Set<OWLIndividual> getCurrentlyDisplayedSameIndividuals() {
        HashSet<OWLIndividual> existingSameIndividuals = new HashSet<OWLIndividual>();
        for (OWLFrameSectionRow existingRow : this.getRows()) {
            OWLSameIndividualAxiom existingAxiom = (OWLSameIndividualAxiom)existingRow.getAxiom();
            for (OWLIndividual existingSameIndividual : existingAxiom.getIndividuals()) {
                existingSameIndividuals.add(existingSameIndividual);
            }
        }
        return existingSameIndividuals;
    }

    @Override
    protected OWLSameIndividualAxiom createAxiom(Set<OWLNamedIndividual> object) {
        object.add((OWLNamedIndividual)this.getRootObject());
        OWLSameIndividualAxiom ax = this.getOWLDataFactory().getOWLSameIndividualAxiom(object);
        return ax;
    }

    @Override
    public OWLObjectEditor<Set<OWLNamedIndividual>> getObjectEditor() {
        return new OWLIndividualSetEditor(this.getOWLEditorKit());
    }

    @Override
    public boolean checkEditorResults(OWLObjectEditor<Set<OWLNamedIndividual>> editor) {
        Set<OWLNamedIndividual> equivalents = editor.getEditedObject();
        return !equivalents.contains(this.getRootObject());
    }

    @Override
    protected boolean isResettingChange(OWLOntologyChange change) {
        if (!change.isAxiomChange()) {
            return false;
        }
        OWLAxiom axiom = change.getAxiom();
        if (axiom instanceof OWLSameIndividualAxiom) {
            return ((OWLSameIndividualAxiom)axiom).getIndividuals().contains(this.getRootObject());
        }
        return false;
    }

    @Override
    public Comparator<OWLFrameSectionRow<OWLNamedIndividual, OWLSameIndividualAxiom, Set<OWLNamedIndividual>>> getRowComparator() {
        return null;
    }
}

