/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib;

import com.dickimawbooks.texparserlib.ActiveChar;
import com.dickimawbooks.texparserlib.BgChar;
import com.dickimawbooks.texparserlib.Comment;
import com.dickimawbooks.texparserlib.ControlSequence;
import com.dickimawbooks.texparserlib.DoubleParam;
import com.dickimawbooks.texparserlib.EgChar;
import com.dickimawbooks.texparserlib.Eol;
import com.dickimawbooks.texparserlib.FixedUnit;
import com.dickimawbooks.texparserlib.FontEncoding;
import com.dickimawbooks.texparserlib.Group;
import com.dickimawbooks.texparserlib.Ignoreable;
import com.dickimawbooks.texparserlib.Letter;
import com.dickimawbooks.texparserlib.MathGroup;
import com.dickimawbooks.texparserlib.Other;
import com.dickimawbooks.texparserlib.Par;
import com.dickimawbooks.texparserlib.Param;
import com.dickimawbooks.texparserlib.SbChar;
import com.dickimawbooks.texparserlib.SkippedEols;
import com.dickimawbooks.texparserlib.SkippedSpaces;
import com.dickimawbooks.texparserlib.SpChar;
import com.dickimawbooks.texparserlib.Space;
import com.dickimawbooks.texparserlib.Tab;
import com.dickimawbooks.texparserlib.TeXApp;
import com.dickimawbooks.texparserlib.TeXDimension;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXPath;
import com.dickimawbooks.texparserlib.TeXSyntaxException;
import com.dickimawbooks.texparserlib.TeXUnit;
import com.dickimawbooks.texparserlib.Writeable;
import com.dickimawbooks.texparserlib.generic.BigOperator;
import com.dickimawbooks.texparserlib.generic.BinarySymbol;
import com.dickimawbooks.texparserlib.generic.GreekSymbol;
import com.dickimawbooks.texparserlib.generic.MathSymbol;
import com.dickimawbooks.texparserlib.generic.Symbol;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;

public abstract class TeXParserListener {
    protected TeXParser parser;

    public abstract void beginParse(File var1, Charset var2) throws IOException;

    public abstract void endParse(File var1) throws IOException;

    public ControlSequence getControlSequence(String string) {
        ControlSequence controlSequence = this.getParser().getControlSequence(string);
        return controlSequence == null ? this.createUndefinedCs(string) : controlSequence;
    }

    public abstract ControlSequence createUndefinedCs(String var1);

    public abstract ActiveChar getActiveChar(int var1);

    public abstract BgChar getBgChar(int var1);

    public abstract EgChar getEgChar(int var1);

    public abstract Eol getEol();

    public abstract Par getPar();

    public abstract Space getSpace();

    public abstract Param getParam(int var1);

    public abstract DoubleParam getDoubleParam(Param var1);

    public abstract Tab getTab();

    public abstract Letter getLetter(int var1);

    public abstract Other getOther(int var1);

    public abstract BigOperator createBigOperator(String var1, int var2, int var3);

    public abstract Symbol createSymbol(String var1, int var2);

    public abstract ControlSequence createSymbol(String var1, int var2, FontEncoding var3);

    public abstract GreekSymbol createGreekSymbol(String var1, int var2);

    public abstract BinarySymbol createBinarySymbol(String var1, int var2);

    public abstract MathSymbol createMathSymbol(String var1, int var2);

    public abstract Group createGroup();

    public abstract Group createGroup(String var1);

    public abstract TeXObjectList createString(String var1);

    public abstract MathGroup createMathGroup();

    public abstract SpChar createSpChar();

    public abstract SbChar createSbChar();

    public abstract Comment createComment();

    public abstract SkippedSpaces createSkippedSpaces();

    public abstract SkippedEols createSkippedEols();

    public abstract float getPageDimension(int var1);

    public TeXUnit createUnit(String string) throws TeXSyntaxException {
        if (string.equals("em")) {
            return TeXUnit.EM;
        }
        if (string.equals("ex")) {
            return TeXUnit.EX;
        }
        if (string.equals("mu")) {
            return TeXUnit.MU;
        }
        if (string.equals("fil")) {
            return TeXUnit.FIL;
        }
        if (string.equals("fill")) {
            return TeXUnit.FILL;
        }
        if (string.equals("filll")) {
            return TeXUnit.FILLL;
        }
        try {
            return new FixedUnit(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new TeXSyntaxException(this.getParser(), "tex.error.missing_unit", string);
        }
    }

    public abstract float emToPt(float var1);

    public abstract float exToPt(float var1);

    public abstract void skipping(Ignoreable var1) throws IOException;

    public abstract void subscript(TeXObject var1) throws IOException;

    public abstract void superscript(TeXObject var1) throws IOException;

    public abstract void overwithdelims(TeXObject var1, TeXObject var2, TeXObject var3, TeXObject var4) throws IOException;

    public abstract void abovewithdelims(TeXObject var1, TeXObject var2, TeXDimension var3, TeXObject var4, TeXObject var5) throws IOException;

    public abstract boolean input(TeXPath var1) throws IOException;

    public abstract Charset getCharSet();

    public abstract TeXObjectList special(String var1) throws IOException;

    public abstract void verb(String var1, boolean var2, int var3, String var4) throws IOException;

    public abstract void addFileReference(TeXPath var1);

    public abstract void href(String var1, TeXObject var2) throws IOException;

    public abstract Writeable getWriteable();

    public abstract TeXApp getTeXApp();

    protected abstract void addPredefined();

    public void setParser(TeXParser teXParser) {
        this.parser = teXParser;
        this.addPredefined();
    }

    public TeXParser getParser() {
        return this.parser;
    }
}

