/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.propertysheet;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.FocusListener;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxEditor;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.plaf.LabelUI;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.basic.BasicComboPopup;
import javax.swing.plaf.basic.ComboPopup;
import javax.swing.plaf.metal.MetalComboBoxIcon;
import javax.swing.plaf.synth.SynthLabelUI;
import org.openide.explorer.propertysheet.ComboBoxAutoCompleteSupport;
import org.openide.explorer.propertysheet.PropUtils;
import org.openide.util.Utilities;

class CleanComboUI
extends BasicComboBoxUI {
    private JButton button = null;
    private boolean tableUI;
    private ComboPopup popup = null;
    private final boolean isGtk = "GTK".equals(UIManager.getLookAndFeel().getID());

    public CleanComboUI(boolean bl) {
        this.tableUI = bl;
    }

    @Override
    protected void installDefaults() {
        LookAndFeel.installColorsAndFont(this.comboBox, "ComboBox.background", "ComboBox.foreground", "ComboBox.font");
        if (this.tableUI) {
            this.comboBox.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 0));
        } else {
            this.comboBox.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(PropUtils.getShadowColor()), BorderFactory.createEmptyBorder(0, 2, 0, 0)));
        }
        CleanComboUI.installComboDefaults(this.comboBox);
    }

    @Override
    protected ComboPopup createPopup() {
        this.popup = new CleanComboPopup(this.comboBox);
        return this.popup;
    }

    @Override
    protected void installKeyboardActions() {
        super.installKeyboardActions();
        if ("Aqua".equals(UIManager.getLookAndFeel().getID())) {
            this.comboBox.getInputMap().put(KeyStroke.getKeyStroke(10, 0), "enterPressed");
        }
        if (!this.tableUI) {
            this.comboBox.getInputMap().put(KeyStroke.getKeyStroke(32, 0), "showPopup");
            this.comboBox.getActionMap().put("showPopup", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (!CleanComboUI.this.comboBox.isPopupVisible()) {
                        CleanComboUI.this.comboBox.showPopup();
                    }
                }
            });
        }
        if ("Aqua".equals(UIManager.getLookAndFeel().getID()) && "10.5".compareTo(System.getProperty("os.version")) <= 0) {
            AbstractAction abstractAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    CleanComboUI.this.selectPreviousPossibleValue();
                }
            };
            AbstractAction abstractAction2 = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    CleanComboUI.this.selectNextPossibleValue();
                }
            };
            this.comboBox.getInputMap().put(KeyStroke.getKeyStroke(38, 0), "selectPrevious");
            this.comboBox.getInputMap().put(KeyStroke.getKeyStroke(40, 0), "selectNext");
            this.comboBox.getActionMap().put("selectPrevious", abstractAction);
            this.comboBox.getActionMap().put("selectNext", abstractAction2);
            JComponent jComponent = (JComponent)this.comboBox.getEditor().getEditorComponent();
            jComponent.getInputMap().put(KeyStroke.getKeyStroke(38, 0), "selectPrevious");
            jComponent.getInputMap().put(KeyStroke.getKeyStroke(40, 0), "selectNext");
            jComponent.getActionMap().put("selectPrevious", abstractAction);
            jComponent.getActionMap().put("selectNext", abstractAction2);
        }
    }

    @Override
    protected JButton createArrowButton() {
        Icon icon = UIManager.getIcon("ComboBox.icon");
        if (icon == null) {
            icon = "Aqua".equals(UIManager.getLookAndFeel().getID()) ? new AquaComboIcon() : new MetalComboBoxIcon();
        }
        this.button = new JButton(icon);
        this.button.setFocusable(false);
        this.button.setContentAreaFilled(false);
        this.button.setBorderPainted(false);
        this.button.setBorder(null);
        return this.button;
    }

    @Override
    protected Insets getInsets() {
        Insets insets = super.getInsets();
        insets.right += 2;
        return insets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        super.paint(graphics, jComponent);
        if (jComponent.hasFocus() && !this.tableUI) {
            Color color = graphics.getColor();
            try {
                graphics.setColor(PropUtils.getShadowColor());
                graphics.drawRect(2, 2, jComponent.getWidth() - 5, jComponent.getHeight() - 5);
            }
            finally {
                graphics.setColor(color);
            }
        }
    }

    @Override
    protected FocusListener createFocusListener() {
        return super.createFocusListener();
    }

    @Override
    public void paintCurrentValue(Graphics graphics, Rectangle rectangle, boolean bl) {
        ListCellRenderer<Object> listCellRenderer = this.comboBox.getRenderer();
        if (this.listBox == null || listCellRenderer == null) {
            return;
        }
        Component component = listCellRenderer.getListCellRendererComponent(this.listBox, this.comboBox.getSelectedItem(), -1, bl && !this.isPopupVisible(this.comboBox), false);
        component.setFont(this.comboBox.getFont());
        component.setForeground(this.comboBox.isEnabled() ? this.comboBox.getForeground() : PropUtils.getDisabledForeground());
        component.setBackground(this.comboBox.getBackground());
        boolean bl2 = false;
        if (component instanceof JPanel) {
            bl2 = true;
        }
        LabelUI labelUI = null;
        if (component instanceof JLabel && this.isGtk) {
            labelUI = ((JLabel)component).getUI();
            ((JLabel)component).setUI(new SolidBackgroundLabelUI());
        }
        this.currentValuePane.paintComponent(graphics, component, this.comboBox, rectangle.x, rectangle.y, rectangle.width, rectangle.height, bl2);
        if (labelUI != null) {
            ((JLabel)component).setUI(labelUI);
        }
    }

    @Override
    protected Rectangle rectangleForCurrentValue() {
        Rectangle rectangle = super.rectangleForCurrentValue();
        if (this.editor != null) {
            ++rectangle.x;
            ++rectangle.y;
            --rectangle.width;
            --rectangle.height;
        }
        return rectangle;
    }

    @Override
    protected ComboBoxEditor createEditor() {
        return new CleanComboBoxEditor();
    }

    private static void installComboDefaults(JComponent jComponent) {
        Font font;
        Color color = UIManager.getColor("ComboBox.background");
        if (color == null) {
            color = UIManager.getColor("text");
        }
        if (color != null) {
            jComponent.setBackground(color);
        }
        if ((color = UIManager.getColor("ComboBox.foreground")) == null) {
            color = UIManager.getColor("textText");
        }
        if (color != null) {
            jComponent.setForeground(color);
        }
        if ((font = UIManager.getFont("ComboBox.font")) != null) {
            jComponent.setFont(font);
        }
    }

    private static class SolidBackgroundLabelUI
    extends SynthLabelUI {
        private SolidBackgroundLabelUI() {
        }

        @Override
        public void update(Graphics graphics, JComponent jComponent) {
            Color color = jComponent.getBackground();
            if (color != null && jComponent.isBackgroundSet()) {
                Color color2 = graphics.getColor();
                graphics.setColor(color);
                graphics.fillRect(0, 0, jComponent.getWidth(), jComponent.getHeight());
                graphics.setColor(color2);
            }
            this.paint(graphics, jComponent);
        }
    }

    private static class AquaComboIcon
    implements Icon {
        private AquaComboIcon() {
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            n = (component.getWidth() - this.getIconWidth()) / 2;
            n2 = (component.getHeight() - this.getIconHeight()) / 2;
            graphics.setColor(UIManager.getColor("Button.Foreground"));
            graphics.drawLine(n + 3, n2, n + 3, n2);
            graphics.drawLine(n + 2, n2 + 1, n + 2 + 2, n2 + 1);
            graphics.drawLine(n + 1, n2 + 2, n + 1 + 4, n2 + 2);
            graphics.drawLine(n, n2 + 3, n + 6, n2 + 3);
            graphics.drawLine(n, n2 + 7, n + 6, n2 + 7);
            graphics.drawLine(n + 1, n2 + 8, n + 1 + 4, n2 + 8);
            graphics.drawLine(n + 2, n2 + 9, n + 2 + 2, n2 + 9);
            graphics.drawLine(n + 3, n2 + 10, n + 3, n2 + 10);
        }

        @Override
        public int getIconWidth() {
            return 7;
        }

        @Override
        public int getIconHeight() {
            return 11;
        }
    }

    static class CleanComboBoxEditor
    extends BasicComboBoxEditor {
        public CleanComboBoxEditor() {
            this.editor = new JTextField();
            Color color = UIManager.getColor("Table.selectionBackground");
            if (color == null) {
                color = Color.BLACK;
            }
            this.editor.setBorder(BorderFactory.createLineBorder(color));
        }
    }

    private static class CleanComboPopup
    extends BasicComboPopup {
        public CleanComboPopup(JComboBox jComboBox) {
            super(jComboBox);
            CleanComboUI.installComboDefaults(this);
        }

        @Override
        protected Rectangle computePopupBounds(int n, int n2, int n3, int n4) {
            if (ComboBoxAutoCompleteSupport.isAutoCompleteInstalled(this.comboBox)) {
                return super.computePopupBounds(n, n2, n3, n4);
            }
            Dimension dimension = this.list.getPreferredSize();
            Rectangle rectangle = Utilities.getUsableScreenBounds();
            if (n3 < dimension.width) {
                n3 = Math.min(dimension.width, rectangle.width - n);
            }
            if (n4 < dimension.height) {
                n4 = Math.min(rectangle.height - n2, dimension.height);
            }
            if (n + n3 > rectangle.width - n) {
                n -= rectangle.width - n3;
            }
            Rectangle rectangle2 = new Rectangle(n, n2, n3, n4);
            return rectangle2;
        }
    }
}

