/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.bean;

import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.eclipse.sisu.bean.BeanProperty;
import org.eclipse.sisu.bean.BeanPropertyField;
import org.eclipse.sisu.bean.BeanPropertySetter;

final class BeanPropertyIterator<T>
implements Iterator<BeanProperty<T>> {
    private final Iterator<Member> memberIterator;
    private BeanProperty<T> nextProperty;

    BeanPropertyIterator(Iterable<Member> members) {
        this.memberIterator = members.iterator();
    }

    @Override
    public boolean hasNext() {
        while (this.nextProperty == null) {
            if (!this.memberIterator.hasNext()) {
                return false;
            }
            Member member = this.memberIterator.next();
            int modifiers = member.getModifiers();
            if (Modifier.isStatic(modifiers) || Modifier.isAbstract(modifiers) || member.isSynthetic()) continue;
            if (member instanceof Method) {
                if (!BeanPropertyIterator.isSetter(member)) continue;
                this.nextProperty = new BeanPropertySetter((Method)member);
                continue;
            }
            if (!(member instanceof Field)) continue;
            this.nextProperty = new BeanPropertyField((Field)member);
        }
        return true;
    }

    @Override
    public BeanProperty<T> next() {
        if (this.hasNext()) {
            BeanProperty<T> property = this.nextProperty;
            this.nextProperty = null;
            return property;
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private static boolean isSetter(Member member) {
        String name2 = member.getName();
        return name2.startsWith("set") && name2.length() > 3 && Character.isUpperCase(name2.charAt(3)) && ((Method)member).getParameterTypes().length == 1;
    }
}

