/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import java.util.Map;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.delete.DeleteAction;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.get.GetAction;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.ml.action.DeleteCalendarEventAction;
import org.elasticsearch.xpack.core.ml.calendars.Calendar;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.ml.job.JobManager;
import org.elasticsearch.xpack.ml.job.persistence.JobProvider;

public class TransportDeleteCalendarEventAction
extends HandledTransportAction<DeleteCalendarEventAction.Request, DeleteCalendarEventAction.Response> {
    private final Client client;
    private final JobProvider jobProvider;
    private final JobManager jobManager;

    @Inject
    public TransportDeleteCalendarEventAction(Settings settings, ThreadPool threadPool, TransportService transportService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, Client client, JobProvider jobProvider, JobManager jobManager) {
        super(settings, "cluster:admin/xpack/ml/calendars/events/delete", threadPool, transportService, actionFilters, indexNameExpressionResolver, DeleteCalendarEventAction.Request::new);
        this.client = client;
        this.jobProvider = jobProvider;
        this.jobManager = jobManager;
    }

    protected void doExecute(DeleteCalendarEventAction.Request request, ActionListener<DeleteCalendarEventAction.Response> listener) {
        String eventId = request.getEventId();
        ActionListener calendarListener = ActionListener.wrap(calendar -> {
            GetRequest getRequest = new GetRequest(".ml-meta", "doc", eventId);
            ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"ml", (Action)GetAction.INSTANCE, (ActionRequest)getRequest, (ActionListener)ActionListener.wrap(getResponse -> {
                if (!getResponse.isExists()) {
                    listener.onFailure((Exception)new ResourceNotFoundException("No event with id [" + eventId + "]", new Object[0]));
                    return;
                }
                Map source = getResponse.getSourceAsMap();
                String calendarId = (String)source.get(Calendar.ID.getPreferredName());
                if (calendarId == null) {
                    listener.onFailure((Exception)ExceptionsHelper.badRequestException((String)("Event [" + eventId + "] does not have a valid " + Calendar.ID.getPreferredName()), (Object[])new Object[0]));
                    return;
                }
                if (!calendarId.equals(request.getCalendarId())) {
                    listener.onFailure((Exception)ExceptionsHelper.badRequestException((String)("Event [" + eventId + "] has " + Calendar.ID.getPreferredName() + " [" + calendarId + "] which does not match the request " + Calendar.ID.getPreferredName() + " [" + request.getCalendarId() + "]"), (Object[])new Object[0]));
                    return;
                }
                this.deleteEvent(eventId, (Calendar)calendar, listener);
            }, arg_0 -> ((ActionListener)listener).onFailure(arg_0)));
        }, arg_0 -> listener.onFailure(arg_0));
        this.jobProvider.calendar(request.getCalendarId(), (ActionListener<Calendar>)calendarListener);
    }

    private void deleteEvent(final String eventId, final Calendar calendar, final ActionListener<DeleteCalendarEventAction.Response> listener) {
        DeleteRequest deleteRequest = new DeleteRequest(".ml-meta", "doc", eventId);
        deleteRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
        ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"ml", (Action)DeleteAction.INSTANCE, (ActionRequest)deleteRequest, (ActionListener)new ActionListener<DeleteResponse>(){

            public void onResponse(DeleteResponse response) {
                if (response.status() == RestStatus.NOT_FOUND) {
                    listener.onFailure((Exception)new ResourceNotFoundException("No event with id [" + eventId + "]", new Object[0]));
                } else {
                    TransportDeleteCalendarEventAction.this.jobManager.updateProcessOnCalendarChanged(calendar.getJobIds());
                    listener.onResponse((Object)new DeleteCalendarEventAction.Response(true));
                }
            }

            public void onFailure(Exception e) {
                listener.onFailure((Exception)ExceptionsHelper.serverError((String)("Could not delete event [" + eventId + "]"), (Throwable)e));
            }
        });
    }
}

