/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.datafeed.extractor.scroll;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.document.DocumentField;
import org.elasticsearch.search.SearchHit;
import org.joda.time.base.BaseDateTime;

abstract class ExtractedField {
    protected final String alias;
    protected final String name;
    private final ExtractionMethod extractionMethod;

    protected ExtractedField(String alias, String name, ExtractionMethod extractionMethod) {
        this.alias = Objects.requireNonNull(alias);
        this.name = Objects.requireNonNull(name);
        this.extractionMethod = Objects.requireNonNull(extractionMethod);
    }

    public String getAlias() {
        return this.alias;
    }

    public String getName() {
        return this.name;
    }

    public ExtractionMethod getExtractionMethod() {
        return this.extractionMethod;
    }

    public abstract Object[] value(SearchHit var1);

    public static ExtractedField newTimeField(String name, ExtractionMethod extractionMethod) {
        if (extractionMethod == ExtractionMethod.SOURCE) {
            throw new IllegalArgumentException("time field cannot be extracted from source");
        }
        return new TimeField(name, extractionMethod);
    }

    public static ExtractedField newField(String name, ExtractionMethod extractionMethod) {
        return ExtractedField.newField(name, name, extractionMethod);
    }

    public static ExtractedField newField(String alias, String name, ExtractionMethod extractionMethod) {
        switch (extractionMethod) {
            case DOC_VALUE: 
            case SCRIPT_FIELD: {
                return new FromFields(alias, name, extractionMethod);
            }
            case SOURCE: {
                return new FromSource(alias, name, extractionMethod);
            }
        }
        throw new IllegalArgumentException("Invalid extraction method [" + (Object)((Object)extractionMethod) + "]");
    }

    private static class FromSource
    extends ExtractedField {
        private String[] namePath;

        FromSource(String alias, String name, ExtractionMethod extractionMethod) {
            super(alias, name, extractionMethod);
            this.namePath = name.split("\\.");
        }

        @Override
        public Object[] value(SearchHit hit) {
            Object values;
            int level;
            Map<String, Object> source = hit.getSourceAsMap();
            for (level = 0; source != null && level < this.namePath.length - 1; ++level) {
                source = FromSource.getNextLevel(source, this.namePath[level]);
            }
            if (source != null && (values = source.get(this.namePath[level])) != null) {
                if (values instanceof List) {
                    List asList = (List)values;
                    return asList.toArray(new Object[asList.size()]);
                }
                return new Object[]{values};
            }
            return new Object[0];
        }

        private static Map<String, Object> getNextLevel(Map<String, Object> source, String key) {
            Object nextLevel = source.get(key);
            if (nextLevel instanceof Map) {
                return (Map)source.get(key);
            }
            return null;
        }
    }

    private static class TimeField
    extends FromFields {
        TimeField(String name, ExtractionMethod extractionMethod) {
            super(name, name, extractionMethod);
        }

        @Override
        public Object[] value(SearchHit hit) {
            Object[] value = super.value(hit);
            if (value.length != 1) {
                return value;
            }
            if (value[0] instanceof String) {
                value[0] = Long.parseLong((String)value[0]);
            } else if (value[0] instanceof BaseDateTime) {
                value[0] = ((BaseDateTime)value[0]).getMillis();
            } else {
                throw new IllegalStateException("Unexpected value for a time field: " + value[0].getClass());
            }
            return value;
        }
    }

    private static class FromFields
    extends ExtractedField {
        FromFields(String alias, String name, ExtractionMethod extractionMethod) {
            super(alias, name, extractionMethod);
        }

        @Override
        public Object[] value(SearchHit hit) {
            DocumentField keyValue = hit.field(this.name);
            if (keyValue != null) {
                List values = keyValue.getValues();
                return values.toArray(new Object[values.size()]);
            }
            return new Object[0];
        }
    }

    public static enum ExtractionMethod {
        SOURCE,
        DOC_VALUE,
        SCRIPT_FIELD;

    }
}

