/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security;

import java.util.EnumSet;
import org.elasticsearch.bootstrap.BootstrapCheck;
import org.elasticsearch.bootstrap.BootstrapContext;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.license.License;
import org.elasticsearch.license.LicenseService;

final class FIPS140LicenseBootstrapCheck
implements BootstrapCheck {
    static final EnumSet<License.OperationMode> ALLOWED_LICENSE_OPERATION_MODES = EnumSet.of(License.OperationMode.PLATINUM, License.OperationMode.TRIAL);
    private final boolean isInFipsMode;

    FIPS140LicenseBootstrapCheck(boolean isInFipsMode) {
        this.isInFipsMode = isInFipsMode;
    }

    public BootstrapCheck.BootstrapCheckResult check(BootstrapContext context) {
        License license;
        if (this.isInFipsMode && (license = LicenseService.getLicense((MetaData)context.metaData)) != null && !ALLOWED_LICENSE_OPERATION_MODES.contains(license.operationMode())) {
            return BootstrapCheck.BootstrapCheckResult.failure((String)"FIPS mode is only allowed with a Platinum or Trial license");
        }
        return BootstrapCheck.BootstrapCheckResult.success();
    }
}

