/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.audit.index;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.state.ClusterStateResponse;
import org.elasticsearch.action.admin.indices.template.put.PutIndexTemplateRequest;
import org.elasticsearch.action.bulk.BulkProcessor;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexRequestBuilder;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.metadata.AliasOrIndex;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.MappingMetaData;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.component.LifecycleListener;
import org.elasticsearch.common.network.NetworkAddress;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.gateway.GatewayService;
import org.elasticsearch.node.Node;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportMessage;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.XPackClientPlugin;
import org.elasticsearch.xpack.core.security.SecurityField;
import org.elasticsearch.xpack.core.security.authc.Authentication;
import org.elasticsearch.xpack.core.security.authc.AuthenticationToken;
import org.elasticsearch.xpack.core.security.user.SystemUser;
import org.elasticsearch.xpack.core.security.user.User;
import org.elasticsearch.xpack.core.security.user.XPackUser;
import org.elasticsearch.xpack.core.template.TemplateUtils;
import org.elasticsearch.xpack.security.audit.AuditLevel;
import org.elasticsearch.xpack.security.audit.AuditTrail;
import org.elasticsearch.xpack.security.audit.AuditUtil;
import org.elasticsearch.xpack.security.audit.index.IndexNameResolver;
import org.elasticsearch.xpack.security.rest.RemoteHostHeader;
import org.elasticsearch.xpack.security.support.SecurityIndexManager;
import org.elasticsearch.xpack.security.transport.filter.SecurityIpFilterRule;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class IndexAuditTrail
extends AbstractComponent
implements AuditTrail,
ClusterStateListener {
    public static final String NAME = "index";
    public static final String DOC_TYPE = "doc";
    public static final String INDEX_TEMPLATE_NAME = "security_audit_log";
    private static final int DEFAULT_BULK_SIZE = 1000;
    private static final int MAX_BULK_SIZE = 10000;
    private static final int DEFAULT_MAX_QUEUE_SIZE = 10000;
    private static final TimeValue DEFAULT_FLUSH_INTERVAL = TimeValue.timeValueSeconds((long)1L);
    private static final IndexNameResolver.Rollover DEFAULT_ROLLOVER = IndexNameResolver.Rollover.DAILY;
    private static final Setting<IndexNameResolver.Rollover> ROLLOVER_SETTING = new Setting(SecurityField.setting((String)"audit.index.rollover"), s -> DEFAULT_ROLLOVER.name(), s -> IndexNameResolver.Rollover.valueOf(s.toUpperCase(Locale.ENGLISH)), new Setting.Property[]{Setting.Property.NodeScope});
    private static final Setting<Integer> QUEUE_SIZE_SETTING = Setting.intSetting((String)SecurityField.setting((String)"audit.index.queue_max_size"), (int)10000, (int)1, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    private static final String DEFAULT_CLIENT_NAME = "security-audit-client";
    private static final List<String> DEFAULT_EVENT_INCLUDES = Arrays.asList(AuditLevel.ACCESS_DENIED.toString(), AuditLevel.ACCESS_GRANTED.toString(), AuditLevel.ANONYMOUS_ACCESS_DENIED.toString(), AuditLevel.AUTHENTICATION_FAILED.toString(), AuditLevel.REALM_AUTHENTICATION_FAILED.toString(), AuditLevel.CONNECTION_DENIED.toString(), AuditLevel.CONNECTION_GRANTED.toString(), AuditLevel.TAMPERED_REQUEST.toString(), AuditLevel.RUN_AS_DENIED.toString(), AuditLevel.RUN_AS_GRANTED.toString(), AuditLevel.AUTHENTICATION_SUCCESS.toString());
    private static final String FORBIDDEN_INDEX_SETTING = "index.mapper.dynamic";
    private static final Setting<Settings> INDEX_SETTINGS = Setting.groupSetting((String)SecurityField.setting((String)"audit.index.settings.index."), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    private static final Setting<List<String>> INCLUDE_EVENT_SETTINGS = Setting.listSetting((String)SecurityField.setting((String)"audit.index.events.include"), DEFAULT_EVENT_INCLUDES, Function.identity(), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    private static final Setting<List<String>> EXCLUDE_EVENT_SETTINGS = Setting.listSetting((String)SecurityField.setting((String)"audit.index.events.exclude"), Collections.emptyList(), Function.identity(), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    private static final Setting<Boolean> INCLUDE_REQUEST_BODY = Setting.boolSetting((String)SecurityField.setting((String)"audit.index.events.emit_request_body"), (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    private static final Setting<Settings> REMOTE_CLIENT_SETTINGS = Setting.groupSetting((String)SecurityField.setting((String)"audit.index.client."), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    private static final Setting<Integer> BULK_SIZE_SETTING = Setting.intSetting((String)SecurityField.setting((String)"audit.index.bulk_size"), (int)1000, (int)1, (int)10000, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    private static final Setting<TimeValue> FLUSH_TIMEOUT_SETTING = Setting.timeSetting((String)SecurityField.setting((String)"audit.index.flush_interval"), (TimeValue)DEFAULT_FLUSH_INTERVAL, (TimeValue)TimeValue.timeValueMillis((long)1L), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    private final AtomicReference<State> state = new AtomicReference<State>(State.INITIALIZED);
    private final String nodeName;
    private final Client client;
    private final QueueConsumer queueConsumer;
    private final ThreadPool threadPool;
    private final ClusterService clusterService;
    private final boolean indexToRemoteCluster;
    private final EnumSet<AuditLevel> events;
    private final IndexNameResolver.Rollover rollover;
    private final boolean includeRequestBody;
    private BulkProcessor bulkProcessor;
    private String nodeHostName;
    private String nodeHostAddress;

    @Override
    public String name() {
        return NAME;
    }

    public IndexAuditTrail(Settings settings, Client client, ThreadPool threadPool, ClusterService clusterService) {
        super(settings);
        this.threadPool = threadPool;
        this.clusterService = clusterService;
        this.nodeName = (String)Node.NODE_NAME_SETTING.get(settings);
        int maxQueueSize = (Integer)QUEUE_SIZE_SETTING.get(settings);
        this.queueConsumer = new QueueConsumer(EsExecutors.threadName((Settings)settings, (String)"audit-queue-consumer"), this.createQueue(maxQueueSize));
        this.rollover = (IndexNameResolver.Rollover)((Object)ROLLOVER_SETTING.get(settings));
        this.events = AuditLevel.parse((List)INCLUDE_EVENT_SETTINGS.get(settings), (List)EXCLUDE_EVENT_SETTINGS.get(settings));
        this.indexToRemoteCluster = ((Settings)REMOTE_CLIENT_SETTINGS.get(settings)).names().size() > 0;
        this.includeRequestBody = (Boolean)INCLUDE_REQUEST_BODY.get(settings);
        this.client = !this.indexToRemoteCluster ? ClientHelper.clientWithOrigin((Client)client, (String)"security") : this.initializeRemoteClient(settings, this.logger);
        clusterService.addListener((ClusterStateListener)this);
        clusterService.addLifecycleListener(new LifecycleListener(){

            public void beforeStop() {
                IndexAuditTrail.this.stop();
            }
        });
    }

    public State state() {
        return this.state.get();
    }

    public void clusterChanged(ClusterChangedEvent event) {
        try {
            if (this.state() == State.INITIALIZED && this.canStart(event)) {
                this.threadPool.generic().execute((Runnable)new AbstractRunnable(){

                    public void onFailure(Exception throwable) {
                        IndexAuditTrail.this.logger.error("failed to start index audit trail services", (Throwable)throwable);
                        assert (false) : "security lifecycle services startup failed";
                    }

                    public void doRun() {
                        IndexAuditTrail.this.start();
                    }
                });
            }
        }
        catch (Exception e) {
            this.logger.error("failed to start index audit trail", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canStart(ClusterChangedEvent event) {
        if (this.indexToRemoteCluster) {
            return true;
        }
        IndexAuditTrail indexAuditTrail = this;
        synchronized (indexAuditTrail) {
            return this.canStart(event.state());
        }
    }

    private boolean canStart(ClusterState clusterState) {
        if (clusterState.blocks().hasGlobalBlock(GatewayService.STATE_NOT_RECOVERED_BLOCK)) {
            this.logger.debug("index audit trail waiting until gateway has recovered from disk");
            return false;
        }
        if (!TemplateUtils.checkTemplateExistsAndVersionMatches((String)INDEX_TEMPLATE_NAME, (String)"security-version", (ClusterState)clusterState, (Logger)this.logger, arg_0 -> ((Version)Version.CURRENT).onOrAfter(arg_0))) {
            this.logger.debug("security audit index template [{}] is not up to date", (Object)INDEX_TEMPLATE_NAME);
            return false;
        }
        String index = this.getIndexName();
        IndexMetaData metaData = clusterState.metaData().index(index);
        if (metaData == null) {
            this.logger.debug("security audit index [{}] does not exist, so service can start", (Object)index);
            return true;
        }
        if (clusterState.routingTable().index(index).allPrimaryShardsActive()) {
            this.logger.debug("security audit index [{}] all primary shards started, so service can start", (Object)index);
            return true;
        }
        this.logger.debug("security audit index [{}] does not have all primary shards started, so service cannot start", (Object)index);
        return false;
    }

    private String getIndexName() {
        Message first = this.peek();
        String index = first == null ? IndexNameResolver.resolve(".security_audit_log", DateTime.now((DateTimeZone)DateTimeZone.UTC), this.rollover) : IndexNameResolver.resolve(".security_audit_log", first.timestamp, this.rollover);
        return index;
    }

    public void start() {
        if (this.state.compareAndSet(State.INITIALIZED, State.STARTING)) {
            this.nodeHostName = this.clusterService.localNode().getHostName();
            this.nodeHostAddress = this.clusterService.localNode().getHostAddress();
            if (this.indexToRemoteCluster) {
                this.client.admin().cluster().prepareState().execute((ActionListener)new ActionListener<ClusterStateResponse>(){

                    public void onResponse(ClusterStateResponse clusterStateResponse) {
                        IndexAuditTrail.this.logger.trace("remote cluster state is [{}] [{}]", (Object)clusterStateResponse.getClusterName(), (Object)clusterStateResponse.getState());
                        if (IndexAuditTrail.this.canStart(clusterStateResponse.getState())) {
                            IndexAuditTrail.this.updateCurrentIndexMappingsIfNecessary(clusterStateResponse.getState());
                        } else if (!TemplateUtils.checkTemplateExistsAndVersionMatches((String)IndexAuditTrail.INDEX_TEMPLATE_NAME, (String)"security-version", (ClusterState)clusterStateResponse.getState(), (Logger)IndexAuditTrail.this.logger, arg_0 -> ((Version)Version.CURRENT).onOrAfter(arg_0))) {
                            IndexAuditTrail.this.putTemplate(IndexAuditTrail.customAuditIndexSettings(IndexAuditTrail.this.settings, IndexAuditTrail.this.logger), e -> {
                                IndexAuditTrail.this.logger.error("failed to put audit trail template", (Throwable)e);
                                IndexAuditTrail.this.transitionStartingToInitialized();
                            });
                        } else {
                            String indexName = IndexAuditTrail.this.getIndexName();
                            IndexAuditTrail.this.client.admin().cluster().prepareHealth(new String[0]).setIndices(new String[]{indexName}).setWaitForYellowStatus().execute(ActionListener.wrap(x -> {
                                IndexAuditTrail.this.logger.debug("have yellow status on remote index [{}] ", (Object)indexName);
                                IndexAuditTrail.this.transitionStartingToInitialized();
                                IndexAuditTrail.this.start();
                            }, e -> {
                                IndexAuditTrail.this.logger.error("failed to get wait for yellow status on remote index [" + indexName + "]", (Throwable)e);
                                IndexAuditTrail.this.transitionStartingToInitialized();
                            }));
                        }
                    }

                    public void onFailure(Exception e) {
                        IndexAuditTrail.this.transitionStartingToInitialized();
                        IndexAuditTrail.this.logger.error("failed to get remote cluster state", (Throwable)e);
                    }
                });
            } else {
                this.updateCurrentIndexMappingsIfNecessary(this.clusterService.state());
            }
        }
    }

    void updateCurrentIndexMappingsIfNecessary(ClusterState state) {
        String index = this.getIndexName();
        AliasOrIndex aliasOrIndex = (AliasOrIndex)state.getMetaData().getAliasAndIndexLookup().get(index);
        if (aliasOrIndex != null) {
            List indices = aliasOrIndex.getIndices();
            if (aliasOrIndex.isAlias() && indices.size() > 1) {
                throw new IllegalStateException("Alias [" + index + "] points to more than one index: " + indices.stream().map(imd -> imd.getIndex().getName()).collect(Collectors.toList()));
            }
            IndexMetaData indexMetaData = (IndexMetaData)indices.get(0);
            MappingMetaData docMapping = indexMetaData.mapping(DOC_TYPE);
            if (docMapping == null) {
                if (this.indexToRemoteCluster || state.nodes().isLocalNodeElectedMaster()) {
                    this.putAuditIndexMappingsAndStart(index);
                } else {
                    this.logger.trace("audit index [{}] is missing mapping for type [{}]", (Object)index, (Object)DOC_TYPE);
                    this.transitionStartingToInitialized();
                }
            } else {
                Map meta = (Map)docMapping.sourceAsMap().get("_meta");
                if (meta == null) {
                    this.logger.info("Missing _meta field in mapping [{}] of index [{}]", (Object)docMapping.type(), (Object)index);
                    throw new IllegalStateException("Cannot read security-version string in index " + index);
                }
                String versionString = (String)meta.get("security-version");
                if (versionString != null && Version.fromString((String)versionString).onOrAfter(Version.CURRENT)) {
                    this.innerStart();
                } else if (this.indexToRemoteCluster || state.nodes().isLocalNodeElectedMaster()) {
                    this.putAuditIndexMappingsAndStart(index);
                } else if (versionString == null) {
                    this.logger.trace("audit index [{}] mapping is missing meta field [{}]", (Object)index, (Object)"security-version");
                    this.transitionStartingToInitialized();
                } else {
                    this.logger.trace("audit index [{}] has the incorrect version [{}]", (Object)index, (Object)versionString);
                    this.transitionStartingToInitialized();
                }
            }
        } else {
            this.innerStart();
        }
    }

    private void putAuditIndexMappingsAndStart(String index) {
        this.putAuditIndexMappings(index, (String)this.getPutIndexTemplateRequest(Settings.EMPTY).mappings().get(DOC_TYPE), (ActionListener<Void>)ActionListener.wrap(ignore -> {
            this.logger.trace("updated mappings on audit index [{}]", (Object)index);
            this.innerStart();
        }, e -> {
            this.logger.error((org.apache.logging.log4j.message.Message)new ParameterizedMessage("failed to update mappings on audit index [{}]", (Object)index), (Throwable)e);
            this.transitionStartingToInitialized();
        }));
    }

    private void transitionStartingToInitialized() {
        if (!this.state.compareAndSet(State.STARTING, State.INITIALIZED)) {
            String message = "state transition from starting to initialized failed, current value: " + (Object)((Object)this.state.get());
            assert (false) : message;
            this.logger.error(message);
        }
    }

    void innerStart() {
        this.initializeBulkProcessor();
        this.queueConsumer.start();
        if (!this.state.compareAndSet(State.STARTING, State.STARTED)) {
            String message = "state transition from starting to started failed, current value: " + (Object)((Object)this.state.get());
            assert (false) : message;
            this.logger.error(message);
        } else {
            this.logger.trace("successful state transition from starting to started, current value: [{}]", (Object)this.state.get());
        }
    }

    public synchronized void stop() {
        if (this.state.compareAndSet(State.STARTED, State.STOPPING)) {
            this.queueConsumer.close();
        }
        if (this.state() != State.STOPPED) {
            try {
                if (this.bulkProcessor != null && !this.bulkProcessor.awaitClose(10L, TimeUnit.SECONDS)) {
                    this.logger.warn("index audit trail failed to store all pending events after waiting for 10s");
                }
            }
            catch (InterruptedException exc) {
                Thread.currentThread().interrupt();
            }
            finally {
                if (this.indexToRemoteCluster) {
                    this.client.close();
                }
                this.state.set(State.STOPPED);
            }
        }
    }

    @Override
    public void authenticationSuccess(String realm, User user, RestRequest request) {
        if (this.events.contains((Object)AuditLevel.AUTHENTICATION_SUCCESS)) {
            try {
                this.enqueue(this.message("authentication_success", (Tuple<String, String>)new Tuple((Object)realm, (Object)realm), user, null, request), "authentication_success");
            }
            catch (Exception e) {
                this.logger.warn("failed to index audit event: [authentication_success]", (Throwable)e);
            }
        }
    }

    @Override
    public void authenticationSuccess(String realm, User user, String action, TransportMessage message) {
        if (this.events.contains((Object)AuditLevel.AUTHENTICATION_SUCCESS)) {
            try {
                this.enqueue(this.message("authentication_success", action, user, null, (Tuple<String, String>)new Tuple((Object)realm, (Object)realm), null, message), "authentication_success");
            }
            catch (Exception e) {
                this.logger.warn("failed to index audit event: [authentication_success]", (Throwable)e);
            }
        }
    }

    @Override
    public void anonymousAccessDenied(String action, TransportMessage message) {
        if (this.events.contains((Object)AuditLevel.ANONYMOUS_ACCESS_DENIED)) {
            try {
                this.enqueue(this.message("anonymous_access_denied", action, null, null, null, AuditUtil.indices(message), message), "anonymous_access_denied");
            }
            catch (Exception e) {
                this.logger.warn("failed to index audit event: [anonymous_access_denied]", (Throwable)e);
            }
        }
    }

    @Override
    public void anonymousAccessDenied(RestRequest request) {
        if (this.events.contains((Object)AuditLevel.ANONYMOUS_ACCESS_DENIED)) {
            try {
                this.enqueue(this.message("anonymous_access_denied", null, null, null, null, request), "anonymous_access_denied");
            }
            catch (Exception e) {
                this.logger.warn("failed to index audit event: [anonymous_access_denied]", (Throwable)e);
            }
        }
    }

    @Override
    public void authenticationFailed(String action, TransportMessage message) {
        if (this.events.contains((Object)AuditLevel.AUTHENTICATION_FAILED)) {
            try {
                this.enqueue(this.message("authentication_failed", action, null, null, null, AuditUtil.indices(message), message), "authentication_failed");
            }
            catch (Exception e) {
                this.logger.warn("failed to index audit event: [authentication_failed]", (Throwable)e);
            }
        }
    }

    @Override
    public void authenticationFailed(RestRequest request) {
        if (this.events.contains((Object)AuditLevel.AUTHENTICATION_FAILED)) {
            try {
                this.enqueue(this.message("authentication_failed", null, null, null, null, request), "authentication_failed");
            }
            catch (Exception e) {
                this.logger.warn("failed to index audit event: [authentication_failed]", (Throwable)e);
            }
        }
    }

    @Override
    public void authenticationFailed(AuthenticationToken token, String action, TransportMessage message) {
        if (this.events.contains((Object)AuditLevel.AUTHENTICATION_FAILED) && !XPackUser.is((String)token.principal())) {
            try {
                this.enqueue(this.message("authentication_failed", action, token, null, AuditUtil.indices(message), message), "authentication_failed");
            }
            catch (Exception e) {
                this.logger.warn("failed to index audit event: [authentication_failed]", (Throwable)e);
            }
        }
    }

    @Override
    public void authenticationFailed(AuthenticationToken token, RestRequest request) {
        if (this.events.contains((Object)AuditLevel.AUTHENTICATION_FAILED) && !XPackUser.is((String)token.principal())) {
            try {
                this.enqueue(this.message("authentication_failed", null, token, null, null, request), "authentication_failed");
            }
            catch (Exception e) {
                this.logger.warn("failed to index audit event: [authentication_failed]", (Throwable)e);
            }
        }
    }

    @Override
    public void authenticationFailed(String realm, AuthenticationToken token, String action, TransportMessage message) {
        if (this.events.contains((Object)AuditLevel.REALM_AUTHENTICATION_FAILED) && !XPackUser.is((String)token.principal())) {
            try {
                this.enqueue(this.message("realm_authentication_failed", action, token, realm, AuditUtil.indices(message), message), "realm_authentication_failed");
            }
            catch (Exception e) {
                this.logger.warn("failed to index audit event: [authentication_failed]", (Throwable)e);
            }
        }
    }

    @Override
    public void authenticationFailed(String realm, AuthenticationToken token, RestRequest request) {
        if (this.events.contains((Object)AuditLevel.REALM_AUTHENTICATION_FAILED) && !XPackUser.is((String)token.principal())) {
            try {
                this.enqueue(this.message("realm_authentication_failed", null, token, realm, null, request), "realm_authentication_failed");
            }
            catch (Exception e) {
                this.logger.warn("failed to index audit event: [authentication_failed]", (Throwable)e);
            }
        }
    }

    @Override
    public void accessGranted(Authentication authentication, String action, TransportMessage message, String[] roleNames) {
        boolean shouldLog;
        User user = authentication.getUser();
        boolean isSystem = SystemUser.is((User)user) || XPackUser.is((User)user);
        boolean logSystemAccessGranted = isSystem && this.events.contains((Object)AuditLevel.SYSTEM_ACCESS_GRANTED);
        boolean bl = shouldLog = logSystemAccessGranted || !isSystem && this.events.contains((Object)AuditLevel.ACCESS_GRANTED);
        if (shouldLog) {
            try {
                assert (authentication.getAuthenticatedBy() != null);
                String authRealmName = authentication.getAuthenticatedBy().getName();
                String lookRealmName = authentication.getLookedUpBy() == null ? null : authentication.getLookedUpBy().getName();
                this.enqueue(this.message("access_granted", action, user, roleNames, (Tuple<String, String>)new Tuple((Object)authRealmName, (Object)lookRealmName), AuditUtil.indices(message), message), "access_granted");
            }
            catch (Exception e) {
                this.logger.warn("failed to index audit event: [access_granted]", (Throwable)e);
            }
        }
    }

    @Override
    public void accessDenied(Authentication authentication, String action, TransportMessage message, String[] roleNames) {
        if (this.events.contains((Object)AuditLevel.ACCESS_DENIED) && !XPackUser.is((User)authentication.getUser())) {
            try {
                assert (authentication.getAuthenticatedBy() != null);
                String authRealmName = authentication.getAuthenticatedBy().getName();
                String lookRealmName = authentication.getLookedUpBy() == null ? null : authentication.getLookedUpBy().getName();
                this.enqueue(this.message("access_denied", action, authentication.getUser(), roleNames, (Tuple<String, String>)new Tuple((Object)authRealmName, (Object)lookRealmName), AuditUtil.indices(message), message), "access_denied");
            }
            catch (Exception e) {
                this.logger.warn("failed to index audit event: [access_denied]", (Throwable)e);
            }
        }
    }

    @Override
    public void tamperedRequest(RestRequest request) {
        if (this.events.contains((Object)AuditLevel.TAMPERED_REQUEST)) {
            try {
                this.enqueue(this.message("tampered_request", null, null, null, null, request), "tampered_request");
            }
            catch (Exception e) {
                this.logger.warn("failed to index audit event: [tampered_request]", (Throwable)e);
            }
        }
    }

    @Override
    public void tamperedRequest(String action, TransportMessage message) {
        if (this.events.contains((Object)AuditLevel.TAMPERED_REQUEST)) {
            try {
                this.enqueue(this.message("tampered_request", action, null, null, null, AuditUtil.indices(message), message), "tampered_request");
            }
            catch (Exception e) {
                this.logger.warn("failed to index audit event: [tampered_request]", (Throwable)e);
            }
        }
    }

    @Override
    public void tamperedRequest(User user, String action, TransportMessage request) {
        if (this.events.contains((Object)AuditLevel.TAMPERED_REQUEST) && !XPackUser.is((User)user)) {
            try {
                this.enqueue(this.message("tampered_request", action, user, null, null, AuditUtil.indices(request), request), "tampered_request");
            }
            catch (Exception e) {
                this.logger.warn("failed to index audit event: [tampered_request]", (Throwable)e);
            }
        }
    }

    @Override
    public void connectionGranted(InetAddress inetAddress, String profile, SecurityIpFilterRule rule) {
        if (this.events.contains((Object)AuditLevel.CONNECTION_GRANTED)) {
            try {
                this.enqueue(this.message("ip_filter", "connection_granted", inetAddress, profile, rule), "connection_granted");
            }
            catch (Exception e) {
                this.logger.warn("failed to index audit event: [connection_granted]", (Throwable)e);
            }
        }
    }

    @Override
    public void connectionDenied(InetAddress inetAddress, String profile, SecurityIpFilterRule rule) {
        if (this.events.contains((Object)AuditLevel.CONNECTION_DENIED)) {
            try {
                this.enqueue(this.message("ip_filter", "connection_denied", inetAddress, profile, rule), "connection_denied");
            }
            catch (Exception e) {
                this.logger.warn("failed to index audit event: [connection_denied]", (Throwable)e);
            }
        }
    }

    @Override
    public void runAsGranted(Authentication authentication, String action, TransportMessage message, String[] roleNames) {
        if (this.events.contains((Object)AuditLevel.RUN_AS_GRANTED)) {
            try {
                assert (authentication.getAuthenticatedBy() != null);
                String authRealmName = authentication.getAuthenticatedBy().getName();
                String lookRealmName = authentication.getLookedUpBy() == null ? null : authentication.getLookedUpBy().getName();
                this.enqueue(this.message("run_as_granted", action, authentication.getUser(), roleNames, (Tuple<String, String>)new Tuple((Object)authRealmName, (Object)lookRealmName), null, message), "run_as_granted");
            }
            catch (Exception e) {
                this.logger.warn("failed to index audit event: [run_as_granted]", (Throwable)e);
            }
        }
    }

    @Override
    public void runAsDenied(Authentication authentication, String action, TransportMessage message, String[] roleNames) {
        if (this.events.contains((Object)AuditLevel.RUN_AS_DENIED)) {
            try {
                assert (authentication.getAuthenticatedBy() != null);
                String authRealmName = authentication.getAuthenticatedBy().getName();
                String lookRealmName = authentication.getLookedUpBy() == null ? null : authentication.getLookedUpBy().getName();
                this.enqueue(this.message("run_as_denied", action, authentication.getUser(), roleNames, (Tuple<String, String>)new Tuple((Object)authRealmName, (Object)lookRealmName), null, message), "run_as_denied");
            }
            catch (Exception e) {
                this.logger.warn("failed to index audit event: [run_as_denied]", (Throwable)e);
            }
        }
    }

    @Override
    public void runAsDenied(Authentication authentication, RestRequest request, String[] roleNames) {
        if (this.events.contains((Object)AuditLevel.RUN_AS_DENIED)) {
            try {
                assert (authentication.getAuthenticatedBy() != null);
                String authRealmName = authentication.getAuthenticatedBy().getName();
                String lookRealmName = authentication.getLookedUpBy() == null ? null : authentication.getLookedUpBy().getName();
                this.enqueue(this.message("run_as_denied", (Tuple<String, String>)new Tuple((Object)authRealmName, (Object)lookRealmName), authentication.getUser(), roleNames, request), "run_as_denied");
            }
            catch (Exception e) {
                this.logger.warn("failed to index audit event: [run_as_denied]", (Throwable)e);
            }
        }
    }

    private Message message(String type, @Nullable String action, @Nullable User user, @Nullable String[] roleNames, @Nullable Tuple<String, String> realms, @Nullable Set<String> indices, TransportMessage message) throws Exception {
        Message msg = new Message().start();
        this.common("transport", type, msg.builder);
        IndexAuditTrail.originAttributes(message, msg.builder, this.clusterService.localNode(), this.threadPool.getThreadContext());
        if (action != null) {
            msg.builder.field("action", action);
        }
        this.addUserAndRealmFields(msg.builder, type, user, realms);
        if (roleNames != null) {
            msg.builder.array("roles", roleNames);
        }
        if (indices != null) {
            msg.builder.array("indices", indices.toArray(Strings.EMPTY_ARRAY));
        }
        msg.builder.field("request", message.getClass().getSimpleName());
        return msg.end();
    }

    private void addUserAndRealmFields(XContentBuilder builder, String type, @Nullable User user, @Nullable Tuple<String, String> realms) throws IOException {
        if (user != null) {
            if (user.isRunAs()) {
                if ("run_as_granted".equals(type) || "run_as_denied".equals(type)) {
                    builder.field("principal", user.authenticatedUser().principal());
                    builder.field("run_as_principal", user.principal());
                    if (realms != null) {
                        builder.field("realm", (String)realms.v1());
                        builder.field("run_as_realm", (String)realms.v2());
                    }
                } else {
                    builder.field("principal", user.principal());
                    builder.field("run_by_principal", user.authenticatedUser().principal());
                    if (realms != null) {
                        builder.field("realm", (String)realms.v2());
                        builder.field("run_by_realm", (String)realms.v1());
                    }
                }
            } else {
                builder.field("principal", user.principal());
                if (realms != null) {
                    builder.field("realm", (String)realms.v1());
                }
            }
        }
    }

    private Message message(String type, @Nullable String action, @Nullable AuthenticationToken token, @Nullable String realm, @Nullable Set<String> indices, TransportMessage message) throws Exception {
        Message msg = new Message().start();
        this.common("transport", type, msg.builder);
        IndexAuditTrail.originAttributes(message, msg.builder, this.clusterService.localNode(), this.threadPool.getThreadContext());
        if (action != null) {
            msg.builder.field("action", action);
        }
        if (token != null) {
            msg.builder.field("principal", token.principal());
        }
        if (realm != null) {
            msg.builder.field("realm", realm);
        }
        if (indices != null) {
            msg.builder.array("indices", indices.toArray(Strings.EMPTY_ARRAY));
        }
        msg.builder.field("request", message.getClass().getSimpleName());
        return msg.end();
    }

    private Message message(String type, @Nullable String action, @Nullable AuthenticationToken token, @Nullable String realm, @Nullable Set<String> indices, RestRequest request) throws Exception {
        Message msg = new Message().start();
        this.common("rest", type, msg.builder);
        if (action != null) {
            msg.builder.field("action", action);
        }
        if (token != null) {
            msg.builder.field("principal", token.principal());
        }
        if (realm != null) {
            msg.builder.field("realm", realm);
        }
        if (indices != null) {
            msg.builder.array("indices", indices.toArray(Strings.EMPTY_ARRAY));
        }
        if (this.includeRequestBody) {
            msg.builder.field("request_body", AuditUtil.restRequestContent(request));
        }
        msg.builder.field("origin_type", "rest");
        SocketAddress address = request.getRemoteAddress();
        if (address instanceof InetSocketAddress) {
            msg.builder.field("origin_address", NetworkAddress.format((InetAddress)((InetSocketAddress)request.getRemoteAddress()).getAddress()));
        } else {
            msg.builder.field("origin_address", (Object)address);
        }
        msg.builder.field("uri", request.uri());
        return msg.end();
    }

    private Message message(String type, @Nullable Tuple<String, String> realms, @Nullable User user, @Nullable String[] roleNames, RestRequest request) throws Exception {
        Message msg = new Message().start();
        this.common("rest", type, msg.builder);
        this.addUserAndRealmFields(msg.builder, type, user, realms);
        if (roleNames != null) {
            msg.builder.array("roles", roleNames);
        }
        if (this.includeRequestBody) {
            msg.builder.field("request_body", AuditUtil.restRequestContent(request));
        }
        msg.builder.field("origin_type", "rest");
        SocketAddress address = request.getRemoteAddress();
        if (address instanceof InetSocketAddress) {
            msg.builder.field("origin_address", NetworkAddress.format((InetAddress)((InetSocketAddress)request.getRemoteAddress()).getAddress()));
        } else {
            msg.builder.field("origin_address", (Object)address);
        }
        msg.builder.field("uri", request.uri());
        return msg.end();
    }

    private Message message(String layer, String type, InetAddress originAddress, String profile, SecurityIpFilterRule rule) throws IOException {
        Message msg = new Message().start();
        this.common(layer, type, msg.builder);
        msg.builder.field("origin_address", NetworkAddress.format((InetAddress)originAddress));
        msg.builder.field("transport_profile", profile);
        msg.builder.field("rule", (ToXContent)rule);
        return msg.end();
    }

    private XContentBuilder common(String layer, String type, XContentBuilder builder) throws IOException {
        builder.field("node_name", this.nodeName);
        builder.field("node_host_name", this.nodeHostName);
        builder.field("node_host_address", this.nodeHostAddress);
        builder.field("layer", layer);
        builder.field("event_type", type);
        return builder;
    }

    private static XContentBuilder originAttributes(TransportMessage message, XContentBuilder builder, DiscoveryNode localNode, ThreadContext threadContext) throws IOException {
        InetSocketAddress restAddress = RemoteHostHeader.restRemoteAddress(threadContext);
        if (restAddress != null) {
            builder.field("origin_type", "rest");
            builder.field("origin_address", NetworkAddress.format((InetAddress)restAddress.getAddress()));
            return builder;
        }
        TransportAddress address = message.remoteAddress();
        if (address != null) {
            builder.field("origin_type", "transport");
            builder.field("origin_address", NetworkAddress.format((InetAddress)address.address().getAddress()));
            return builder;
        }
        builder.field("origin_type", "local_node");
        builder.field("origin_address", localNode.getHostAddress());
        return builder;
    }

    void enqueue(Message message, String type) {
        boolean accepted;
        State currentState = this.state();
        if (currentState != State.STOPPING && currentState != State.STOPPED && !(accepted = this.queueConsumer.offer(message))) {
            this.logger.warn("failed to index audit event: [{}]. internal queue is full, which may be caused by a high indexing rate or issue with the destination", (Object)type);
        }
    }

    Message peek() {
        return this.queueConsumer.peek();
    }

    Client initializeRemoteClient(Settings settings, Logger logger) {
        int clientProcessors;
        Settings clientSettings = (Settings)REMOTE_CLIENT_SETTINGS.get(settings);
        List hosts = clientSettings.getAsList("hosts");
        if (hosts.isEmpty()) {
            throw new ElasticsearchException("missing required setting [" + REMOTE_CLIENT_SETTINGS.getKey() + ".hosts] for remote audit log indexing", new Object[0]);
        }
        int processors = (Integer)EsExecutors.PROCESSORS_SETTING.get(settings);
        if (EsExecutors.PROCESSORS_SETTING.exists(clientSettings) && (clientProcessors = ((Integer)EsExecutors.PROCESSORS_SETTING.get(clientSettings)).intValue()) != processors) {
            String message = String.format(Locale.ROOT, "explicit processor setting [%d] for audit trail remote client does not match inherited processor setting [%d]", clientProcessors, processors);
            throw new IllegalStateException(message);
        }
        if (clientSettings.get("cluster.name", "").isEmpty()) {
            throw new ElasticsearchException("missing required setting [" + REMOTE_CLIENT_SETTINGS.getKey() + ".cluster.name] for remote audit log indexing", new Object[0]);
        }
        ArrayList<Tuple> hostPortPairs = new ArrayList<Tuple>();
        for (String host : hosts) {
            List<String> hostPort = Arrays.asList(host.trim().split(":"));
            if (hostPort.size() != 1 && hostPort.size() != 2) {
                logger.warn("invalid host:port specified: [{}] for setting [{}.hosts]", (Object)REMOTE_CLIENT_SETTINGS.getKey(), (Object)host);
            }
            hostPortPairs.add(new Tuple((Object)hostPort.get(0), (Object)(hostPort.size() == 2 ? Integer.valueOf(hostPort.get(1)) : 9300)));
        }
        if (hostPortPairs.size() == 0) {
            throw new ElasticsearchException("no valid host:port pairs specified for setting [" + REMOTE_CLIENT_SETTINGS.getKey() + ".hosts]", new Object[0]);
        }
        Settings theClientSetting = Settings.builder().put(clientSettings.filter(s -> !s.startsWith("hosts"))).put(EsExecutors.PROCESSORS_SETTING.getKey(), processors).build();
        TransportClient transportClient = new TransportClient(Settings.builder().put("node.name", "security-audit-client-" + (String)Node.NODE_NAME_SETTING.get(settings)).put(theClientSetting).build(), Settings.EMPTY, this.remoteTransportClientPlugins(), null){};
        for (Tuple pair : hostPortPairs) {
            try {
                transportClient.addTransportAddress(new TransportAddress(InetAddress.getByName((String)pair.v1()), ((Integer)pair.v2()).intValue()));
            }
            catch (UnknownHostException e) {
                throw new ElasticsearchException("could not find host {}", (Throwable)e, new Object[]{pair.v1()});
            }
        }
        logger.info("forwarding audit events to remote cluster [{}] using hosts [{}]", (Object)clientSettings.get("cluster.name", ""), (Object)((Object)hostPortPairs).toString());
        return transportClient;
    }

    public static Settings customAuditIndexSettings(Settings nodeSettings, Logger logger) {
        Settings newSettings = Settings.builder().put((Settings)INDEX_SETTINGS.get(nodeSettings), false).normalizePrefix("index.").build();
        if (newSettings.names().isEmpty()) {
            return Settings.EMPTY;
        }
        return Settings.builder().put(newSettings.filter(name -> {
            if (FORBIDDEN_INDEX_SETTING.equals(name)) {
                logger.warn("overriding the default [{}} setting is forbidden. ignoring...", name);
                return false;
            }
            return true;
        })).build();
    }

    private void putTemplate(Settings customSettings, Consumer<Exception> consumer) {
        try {
            PutIndexTemplateRequest request = this.getPutIndexTemplateRequest(customSettings);
            this.client.admin().indices().putTemplate(request, ActionListener.wrap(response -> {
                if (response.isAcknowledged()) {
                    this.client.admin().cluster().prepareState().execute(ActionListener.wrap(stateResponse -> this.updateCurrentIndexMappingsIfNecessary(stateResponse.getState()), (Consumer)consumer));
                } else {
                    consumer.accept(new IllegalStateException("failed to put index template for audit logging"));
                }
            }, consumer));
        }
        catch (Exception e) {
            this.logger.debug("unexpected exception while putting index template", (Throwable)e);
            consumer.accept(e);
        }
    }

    private PutIndexTemplateRequest getPutIndexTemplateRequest(Settings customSettings) {
        byte[] template = TemplateUtils.loadTemplate((String)"/security_audit_log.json", (String)Version.CURRENT.toString(), (String)SecurityIndexManager.TEMPLATE_VERSION_PATTERN).getBytes(StandardCharsets.UTF_8);
        PutIndexTemplateRequest request = new PutIndexTemplateRequest(INDEX_TEMPLATE_NAME).source(template, XContentType.JSON);
        if (customSettings != null && customSettings.names().size() > 0) {
            Settings updatedSettings = Settings.builder().put(request.settings()).put(customSettings).build();
            request.settings(updatedSettings);
        }
        return request;
    }

    private void putAuditIndexMappings(String index, String mappings, ActionListener<Void> listener) {
        this.client.admin().indices().preparePutMapping(new String[]{index}).setType(DOC_TYPE).setSource(mappings, XContentType.JSON).execute(ActionListener.wrap(response -> {
            if (response.isAcknowledged()) {
                listener.onResponse(null);
            } else {
                listener.onFailure((Exception)new IllegalStateException("failed to put mappings for audit logging index [" + index + "]"));
            }
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    BlockingQueue<Message> createQueue(int maxQueueSize) {
        return new LinkedBlockingQueue<Message>(maxQueueSize);
    }

    private void initializeBulkProcessor() {
        int bulkSize = (Integer)BULK_SIZE_SETTING.get(this.settings);
        TimeValue interval = (TimeValue)FLUSH_TIMEOUT_SETTING.get(this.settings);
        this.bulkProcessor = BulkProcessor.builder((Client)this.client, (BulkProcessor.Listener)new BulkProcessor.Listener(){

            public void beforeBulk(long executionId, BulkRequest request) {
            }

            public void afterBulk(long executionId, BulkRequest request, BulkResponse response) {
                if (response.hasFailures()) {
                    IndexAuditTrail.this.logger.info("failed to bulk index audit events: [{}]", (Object)response.buildFailureMessage());
                }
            }

            public void afterBulk(long executionId, BulkRequest request, Throwable failure) {
                IndexAuditTrail.this.logger.error((org.apache.logging.log4j.message.Message)new ParameterizedMessage("failed to bulk index audit events: [{}]", (Object)failure.getMessage()), failure);
            }
        }).setBulkActions(bulkSize).setFlushInterval(interval).setConcurrentRequests(1).build();
    }

    List<Class<? extends Plugin>> remoteTransportClientPlugins() {
        return Arrays.asList(XPackClientPlugin.class);
    }

    public static void registerSettings(List<Setting<?>> settings) {
        settings.add(INDEX_SETTINGS);
        settings.add(EXCLUDE_EVENT_SETTINGS);
        settings.add(INCLUDE_EVENT_SETTINGS);
        settings.add(ROLLOVER_SETTING);
        settings.add(BULK_SIZE_SETTING);
        settings.add(FLUSH_TIMEOUT_SETTING);
        settings.add(QUEUE_SIZE_SETTING);
        settings.add(REMOTE_CLIENT_SETTINGS);
        settings.add(INCLUDE_REQUEST_BODY);
    }

    public static enum State {
        INITIALIZED,
        STARTING,
        STARTED,
        STOPPING,
        STOPPED;

    }

    static interface Field {
        public static final String TIMESTAMP = "@timestamp";
        public static final String NODE_NAME = "node_name";
        public static final String NODE_HOST_NAME = "node_host_name";
        public static final String NODE_HOST_ADDRESS = "node_host_address";
        public static final String LAYER = "layer";
        public static final String TYPE = "event_type";
        public static final String ORIGIN_ADDRESS = "origin_address";
        public static final String ORIGIN_TYPE = "origin_type";
        public static final String PRINCIPAL = "principal";
        public static final String ROLE_NAMES = "roles";
        public static final String RUN_AS_PRINCIPAL = "run_as_principal";
        public static final String RUN_AS_REALM = "run_as_realm";
        public static final String RUN_BY_PRINCIPAL = "run_by_principal";
        public static final String RUN_BY_REALM = "run_by_realm";
        public static final String ACTION = "action";
        public static final String INDICES = "indices";
        public static final String REQUEST = "request";
        public static final String REQUEST_BODY = "request_body";
        public static final String URI = "uri";
        public static final String REALM = "realm";
        public static final String TRANSPORT_PROFILE = "transport_profile";
        public static final String RULE = "rule";
    }

    static class Message {
        final DateTime timestamp = DateTime.now((DateTimeZone)DateTimeZone.UTC);
        final XContentBuilder builder = XContentFactory.jsonBuilder();

        Message() throws IOException {
        }

        Message start() throws IOException {
            this.builder.startObject();
            this.builder.timeField("@timestamp", (Object)this.timestamp);
            return this;
        }

        Message end() throws IOException {
            this.builder.endObject();
            return this;
        }
    }

    private final class QueueConsumer
    extends Thread
    implements Closeable {
        private final AtomicBoolean open;
        private final BlockingQueue<Message> eventQueue;
        private final Message shutdownSentinelMessage;

        QueueConsumer(String name, BlockingQueue eventQueue) {
            super(name);
            this.open = new AtomicBoolean(true);
            this.eventQueue = eventQueue;
            try {
                this.shutdownSentinelMessage = new Message();
            }
            catch (IOException e) {
                throw new AssertionError((Object)e);
            }
        }

        @Override
        public void close() {
            if (this.open.compareAndSet(true, false)) {
                try {
                    this.eventQueue.put(this.shutdownSentinelMessage);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }

        @Override
        public void run() {
            while (this.open.get()) {
                try {
                    Message message = this.eventQueue.take();
                    if (message == this.shutdownSentinelMessage || !this.open.get()) break;
                    IndexRequest indexRequest = (IndexRequest)((IndexRequestBuilder)IndexAuditTrail.this.client.prepareIndex().setIndex(IndexNameResolver.resolve(".security_audit_log", message.timestamp, IndexAuditTrail.this.rollover))).setType(IndexAuditTrail.DOC_TYPE).setSource(message.builder).request();
                    IndexAuditTrail.this.bulkProcessor.add(indexRequest);
                }
                catch (InterruptedException e) {
                    IndexAuditTrail.this.logger.debug("index audit queue consumer interrupted", (Throwable)e);
                    this.close();
                    break;
                }
                catch (Exception e) {
                    IndexAuditTrail.this.logger.warn("failed to index audit message from queue", (Throwable)e);
                }
            }
            this.eventQueue.clear();
        }

        public boolean offer(Message message) {
            if (this.open.get()) {
                return this.eventQueue.offer(message);
            }
            return false;
        }

        public Message peek() {
            return (Message)this.eventQueue.peek();
        }
    }
}

