/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc.kerberos;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.auth.login.LoginException;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.cache.Cache;
import org.elasticsearch.common.cache.CacheBuilder;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.core.security.authc.AuthenticationResult;
import org.elasticsearch.xpack.core.security.authc.AuthenticationToken;
import org.elasticsearch.xpack.core.security.authc.Realm;
import org.elasticsearch.xpack.core.security.authc.RealmConfig;
import org.elasticsearch.xpack.core.security.authc.kerberos.KerberosRealmSettings;
import org.elasticsearch.xpack.core.security.authc.support.CachingRealm;
import org.elasticsearch.xpack.core.security.user.User;
import org.elasticsearch.xpack.security.authc.kerberos.KerberosAuthenticationToken;
import org.elasticsearch.xpack.security.authc.kerberos.KerberosTicketValidator;
import org.elasticsearch.xpack.security.authc.support.UserRoleMapper;
import org.elasticsearch.xpack.security.authc.support.mapper.NativeRoleMappingStore;
import org.ietf.jgss.GSSException;

public final class KerberosRealm
extends Realm
implements CachingRealm {
    private final Cache<String, User> userPrincipalNameToUserCache;
    private final NativeRoleMappingStore userRoleMapper;
    private final KerberosTicketValidator kerberosTicketValidator;
    private final ThreadPool threadPool;
    private final Path keytabPath;
    private final boolean enableKerberosDebug;
    private final boolean removeRealmName;

    public KerberosRealm(RealmConfig config, NativeRoleMappingStore nativeRoleMappingStore, ThreadPool threadPool) {
        this(config, nativeRoleMappingStore, new KerberosTicketValidator(), threadPool, null);
    }

    KerberosRealm(RealmConfig config, NativeRoleMappingStore nativeRoleMappingStore, KerberosTicketValidator kerberosTicketValidator, ThreadPool threadPool, Cache<String, User> userPrincipalNameToUserCache) {
        super("kerberos", config);
        this.userRoleMapper = nativeRoleMappingStore;
        this.userRoleMapper.refreshRealmOnChange(this);
        TimeValue ttl = (TimeValue)KerberosRealmSettings.CACHE_TTL_SETTING.get(config.settings());
        this.userPrincipalNameToUserCache = ttl.getNanos() > 0L ? (userPrincipalNameToUserCache == null ? CacheBuilder.builder().setExpireAfterWrite((TimeValue)KerberosRealmSettings.CACHE_TTL_SETTING.get(config.settings())).setMaximumWeight((long)((Integer)KerberosRealmSettings.CACHE_MAX_USERS_SETTING.get(config.settings())).intValue()).build() : userPrincipalNameToUserCache) : null;
        this.kerberosTicketValidator = kerberosTicketValidator;
        this.threadPool = threadPool;
        this.keytabPath = config.env().configFile().resolve((String)KerberosRealmSettings.HTTP_SERVICE_KEYTAB_PATH.get(config.settings()));
        if (!Files.exists(this.keytabPath, new LinkOption[0])) {
            throw new IllegalArgumentException("configured service key tab file [" + this.keytabPath + "] does not exist");
        }
        if (Files.isDirectory(this.keytabPath, new LinkOption[0])) {
            throw new IllegalArgumentException("configured service key tab file [" + this.keytabPath + "] is a directory");
        }
        if (!Files.isReadable(this.keytabPath)) {
            throw new IllegalArgumentException("configured service key tab file [" + this.keytabPath + "] must have read permission");
        }
        this.enableKerberosDebug = (Boolean)KerberosRealmSettings.SETTING_KRB_DEBUG_ENABLE.get(config.settings());
        this.removeRealmName = (Boolean)KerberosRealmSettings.SETTING_REMOVE_REALM_NAME.get(config.settings());
    }

    public Map<String, List<String>> getAuthenticationFailureHeaders() {
        return Collections.singletonMap("WWW-Authenticate", Collections.singletonList("Negotiate"));
    }

    public void expire(String username) {
        if (this.userPrincipalNameToUserCache != null) {
            this.userPrincipalNameToUserCache.invalidate((Object)username);
        }
    }

    public void expireAll() {
        if (this.userPrincipalNameToUserCache != null) {
            this.userPrincipalNameToUserCache.invalidateAll();
        }
    }

    public boolean supports(AuthenticationToken token) {
        return token instanceof KerberosAuthenticationToken;
    }

    public AuthenticationToken token(ThreadContext context) {
        return KerberosAuthenticationToken.extractToken(context.getHeader("Authorization"));
    }

    public void authenticate(AuthenticationToken token, ActionListener<AuthenticationResult> listener) {
        assert (token instanceof KerberosAuthenticationToken);
        KerberosAuthenticationToken kerbAuthnToken = (KerberosAuthenticationToken)token;
        this.kerberosTicketValidator.validateTicket((byte[])kerbAuthnToken.credentials(), this.keytabPath, this.enableKerberosDebug, (ActionListener<Tuple<String, String>>)ActionListener.wrap(userPrincipalNameOutToken -> {
            if (userPrincipalNameOutToken.v1() != null) {
                String username = this.maybeRemoveRealmName((String)userPrincipalNameOutToken.v1());
                this.buildUser(username, (String)userPrincipalNameOutToken.v2(), listener);
            } else {
                String errorMessage = "failed to authenticate user, gss context negotiation not complete";
                ElasticsearchSecurityException ese = KerberosAuthenticationToken.unauthorized(errorMessage, null, new Object[0]);
                ese = KerberosAuthenticationToken.unauthorizedWithOutputToken(ese, (String)userPrincipalNameOutToken.v2());
                listener.onResponse((Object)AuthenticationResult.terminate((String)errorMessage, (Exception)((Object)ese)));
            }
        }, e -> this.handleException((Exception)e, listener)));
    }

    protected String maybeRemoveRealmName(String principalName) {
        int foundAtIndex;
        if (this.removeRealmName && (foundAtIndex = principalName.indexOf(64)) > 0) {
            return principalName.substring(0, foundAtIndex);
        }
        return principalName;
    }

    private void handleException(Exception e, ActionListener<AuthenticationResult> listener) {
        if (e instanceof LoginException) {
            this.logger.debug("failed to authenticate user, service login failure", (Throwable)e);
            listener.onResponse((Object)AuthenticationResult.terminate((String)"failed to authenticate user, service login failure", (Exception)((Object)KerberosAuthenticationToken.unauthorized(e.getLocalizedMessage(), e, new Object[0]))));
        } else if (e instanceof GSSException) {
            this.logger.debug("failed to authenticate user, gss context negotiation failure", (Throwable)e);
            listener.onResponse((Object)AuthenticationResult.terminate((String)"failed to authenticate user, gss context negotiation failure", (Exception)((Object)KerberosAuthenticationToken.unauthorized(e.getLocalizedMessage(), e, new Object[0]))));
        } else {
            this.logger.debug("failed to authenticate user", (Throwable)e);
            listener.onFailure(e);
        }
    }

    private void buildUser(String username, String outToken, ActionListener<AuthenticationResult> listener) {
        User user;
        if (Strings.hasText((String)outToken)) {
            this.threadPool.getThreadContext().addResponseHeader("WWW-Authenticate", "Negotiate " + outToken);
        }
        User user2 = user = this.userPrincipalNameToUserCache != null ? (User)this.userPrincipalNameToUserCache.get((Object)username) : null;
        if (user != null) {
            listener.onResponse((Object)AuthenticationResult.success((User)user));
        } else {
            UserRoleMapper.UserData userData = new UserRoleMapper.UserData(username, null, Collections.emptySet(), null, this.config);
            this.userRoleMapper.resolveRoles(userData, (ActionListener<Set<String>>)ActionListener.wrap(roles -> {
                User computedUser = new User(username, roles.toArray(new String[roles.size()]), null, null, null, true);
                if (this.userPrincipalNameToUserCache != null) {
                    this.userPrincipalNameToUserCache.put((Object)username, (Object)computedUser);
                }
                listener.onResponse((Object)AuthenticationResult.success((User)computedUser));
            }, arg_0 -> listener.onFailure(arg_0)));
        }
    }

    public void lookupUser(String username, ActionListener<User> listener) {
        listener.onResponse(null);
    }
}

