/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.rollup.action;

import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.ResourceAlreadyExistsException;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexAction;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.mapping.get.GetMappingsAction;
import org.elasticsearch.action.admin.indices.mapping.get.GetMappingsRequest;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingAction;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingRequest;
import org.elasticsearch.action.fieldcaps.FieldCapabilitiesRequest;
import org.elasticsearch.action.fieldcaps.FieldCapabilitiesResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.MappingMetaData;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.CheckedConsumer;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.license.LicenseUtils;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.persistent.PersistentTaskParams;
import org.elasticsearch.persistent.PersistentTasksCustomMetaData;
import org.elasticsearch.persistent.PersistentTasksService;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.XPackPlugin;
import org.elasticsearch.xpack.core.rollup.action.PutRollupJobAction;
import org.elasticsearch.xpack.core.rollup.action.RollupActionRequestValidationException;
import org.elasticsearch.xpack.core.rollup.job.RollupJob;
import org.elasticsearch.xpack.core.rollup.job.RollupJobConfig;
import org.elasticsearch.xpack.rollup.Rollup;

public class TransportPutRollupJobAction
extends TransportMasterNodeAction<PutRollupJobAction.Request, PutRollupJobAction.Response> {
    private final XPackLicenseState licenseState;
    private final PersistentTasksService persistentTasksService;
    private final Client client;
    private final IndexNameExpressionResolver indexNameExpressionResolver;

    @Inject
    public TransportPutRollupJobAction(Settings settings, TransportService transportService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, ClusterService clusterService, XPackLicenseState licenseState, PersistentTasksService persistentTasksService, Client client) {
        super(settings, "cluster:admin/xpack/rollup/put", transportService, clusterService, threadPool, actionFilters, indexNameExpressionResolver, PutRollupJobAction.Request::new);
        this.licenseState = licenseState;
        this.persistentTasksService = persistentTasksService;
        this.client = client;
        this.indexNameExpressionResolver = indexNameExpressionResolver;
    }

    protected String executor() {
        return "same";
    }

    protected PutRollupJobAction.Response newResponse() {
        return new PutRollupJobAction.Response();
    }

    protected void masterOperation(final PutRollupJobAction.Request request, ClusterState clusterState, final ActionListener<PutRollupJobAction.Response> listener) {
        if (!this.licenseState.isRollupAllowed()) {
            listener.onFailure((Exception)LicenseUtils.newComplianceException((String)"rollup"));
            return;
        }
        XPackPlugin.checkReadyForXPackCustomMetadata((ClusterState)clusterState);
        FieldCapabilitiesRequest fieldCapsRequest = new FieldCapabilitiesRequest().indices(new String[]{request.getConfig().getIndexPattern()}).fields(request.getConfig().getAllFields().toArray(new String[0]));
        this.client.fieldCaps(fieldCapsRequest, (ActionListener)new ActionListener<FieldCapabilitiesResponse>(){

            public void onResponse(FieldCapabilitiesResponse fieldCapabilitiesResponse) {
                RollupActionRequestValidationException validationException = request.validateMappings(fieldCapabilitiesResponse.get());
                if (validationException != null) {
                    listener.onFailure((Exception)validationException);
                    return;
                }
                RollupJob job = TransportPutRollupJobAction.createRollupJob(request.getConfig(), TransportPutRollupJobAction.this.threadPool);
                TransportPutRollupJobAction.createIndex(job, (ActionListener<PutRollupJobAction.Response>)listener, TransportPutRollupJobAction.this.persistentTasksService, TransportPutRollupJobAction.this.client, TransportPutRollupJobAction.this.logger);
            }

            public void onFailure(Exception e) {
                listener.onFailure(e);
            }
        });
    }

    private static RollupJob createRollupJob(RollupJobConfig config, ThreadPool threadPool) {
        Map<String, String> filteredHeaders = threadPool.getThreadContext().getHeaders().entrySet().stream().filter(e -> Rollup.HEADER_FILTERS.contains(e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        return new RollupJob(config, filteredHeaders);
    }

    static void createIndex(RollupJob job, ActionListener<PutRollupJobAction.Response> listener, PersistentTasksService persistentTasksService, Client client, Logger logger) {
        String jobMetadata = "\"" + job.getConfig().getId() + "\":" + job.getConfig().toJSONString();
        String mapping = Rollup.DYNAMIC_MAPPING_TEMPLATE.replace("\"ROLLUP_METADATA_PLACEHOLDER\":\"ROLLUP_METADATA_PLACEHOLDER\"", jobMetadata);
        CreateIndexRequest request = new CreateIndexRequest(job.getConfig().getRollupIndex());
        request.mapping("_doc", mapping, XContentType.JSON);
        client.execute((Action)CreateIndexAction.INSTANCE, (ActionRequest)request, ActionListener.wrap(createIndexResponse -> TransportPutRollupJobAction.startPersistentTask(job, listener, persistentTasksService), e -> {
            if (e instanceof ResourceAlreadyExistsException) {
                logger.debug("Rolled index already exists for rollup job [" + job.getConfig().getId() + "], updating metadata.");
                TransportPutRollupJobAction.updateMapping(job, listener, persistentTasksService, client, logger);
            } else {
                String msg = "Could not create index for rollup job [" + job.getConfig().getId() + "]";
                logger.error(msg);
                listener.onFailure((Exception)new RuntimeException(msg, (Throwable)e));
            }
        }));
    }

    static void updateMapping(RollupJob job, ActionListener<PutRollupJobAction.Response> listener, PersistentTasksService persistentTasksService, Client client, Logger logger) {
        String indexName = job.getConfig().getRollupIndex();
        CheckedConsumer getMappingResponseHandler = getMappingResponse -> {
            MappingMetaData mappings = (MappingMetaData)((ImmutableOpenMap)getMappingResponse.getMappings().get((Object)indexName)).get((Object)"_doc");
            Object m = mappings.getSourceAsMap().get("_meta");
            if (m == null) {
                String msg = "Expected to find _meta key in mapping of rollup index [" + indexName + "] but not found.";
                logger.error(msg);
                listener.onFailure((Exception)new RuntimeException(msg));
                return;
            }
            Map metadata = (Map)m;
            if (metadata.get("_rollup") == null) {
                String msg = "Expected to find rollup meta key [_rollup] in mapping of rollup index [" + indexName + "] but not found.";
                logger.error(msg);
                listener.onFailure((Exception)new RuntimeException(msg));
                return;
            }
            Map rollupMeta = (Map)((Map)m).get("_rollup");
            String stringVersion = (String)((Map)m).get("rollup-version");
            if (stringVersion == null) {
                listener.onFailure((Exception)new IllegalStateException("Could not determine version of existing rollup metadata for index [" + indexName + "]"));
                return;
            }
            if (rollupMeta.get(job.getConfig().getId()) != null) {
                String msg = "Cannot create rollup job [" + job.getConfig().getId() + "] because job was previously created (existing metadata).";
                logger.error(msg);
                listener.onFailure((Exception)new ElasticsearchStatusException(msg, RestStatus.CONFLICT, new Object[0]));
                return;
            }
            rollupMeta.put(job.getConfig().getId(), job.getConfig());
            metadata.put("_rollup", rollupMeta);
            Map newMapping = mappings.getSourceAsMap();
            newMapping.put("_meta", metadata);
            PutMappingRequest request = new PutMappingRequest(new String[]{indexName});
            request.type("_doc");
            request.source(newMapping);
            client.execute((Action)PutMappingAction.INSTANCE, (ActionRequest)request, ActionListener.wrap(putMappingResponse -> TransportPutRollupJobAction.startPersistentTask(job, listener, persistentTasksService), arg_0 -> ((ActionListener)listener).onFailure(arg_0)));
        };
        GetMappingsRequest request = new GetMappingsRequest();
        client.execute((Action)GetMappingsAction.INSTANCE, (ActionRequest)request, ActionListener.wrap((CheckedConsumer)getMappingResponseHandler, e -> {
            String msg = "Could not update mappings for rollup job [" + job.getConfig().getId() + "]";
            logger.error(msg);
            listener.onFailure((Exception)new RuntimeException(msg, (Throwable)e));
        }));
    }

    static void startPersistentTask(RollupJob job, ActionListener<PutRollupJobAction.Response> listener, PersistentTasksService persistentTasksService) {
        persistentTasksService.sendStartRequest(job.getConfig().getId(), "xpack/rollup/job", (PersistentTaskParams)job, ActionListener.wrap(rollupConfigPersistentTask -> TransportPutRollupJobAction.waitForRollupStarted(job, listener, persistentTasksService), e -> {
            if (e instanceof ResourceAlreadyExistsException) {
                e = new ElasticsearchStatusException("Cannot create job [" + job.getConfig().getId() + "] because it has already been created (task exists)", RestStatus.CONFLICT, (Throwable)e, new Object[0]);
            }
            listener.onFailure(e);
        }));
    }

    private static void waitForRollupStarted(final RollupJob job, final ActionListener<PutRollupJobAction.Response> listener, PersistentTasksService persistentTasksService) {
        persistentTasksService.waitForPersistentTaskCondition(job.getConfig().getId(), Objects::nonNull, job.getConfig().getTimeout(), (PersistentTasksService.WaitForPersistentTaskListener)new PersistentTasksService.WaitForPersistentTaskListener<RollupJob>(){

            public void onResponse(PersistentTasksCustomMetaData.PersistentTask<RollupJob> task) {
                listener.onResponse((Object)new PutRollupJobAction.Response(true));
            }

            public void onFailure(Exception e) {
                listener.onFailure(e);
            }

            public void onTimeout(TimeValue timeout) {
                listener.onFailure((Exception)new ElasticsearchException("Creation of task for Rollup Job ID [" + job.getConfig().getId() + "] timed out after [" + timeout + "]", new Object[0]));
            }
        });
    }

    protected ClusterBlockException checkBlock(PutRollupJobAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }
}

