/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Map;
import java.util.function.DoubleSupplier;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.Scorer;
import org.elasticsearch.index.fielddata.ScriptDocValues;
import org.elasticsearch.script.ScriptContext;
import org.elasticsearch.search.lookup.LeafSearchLookup;
import org.elasticsearch.search.lookup.SearchLookup;

public abstract class ScoreScript {
    public static final String[] PARAMETERS = new String[0];
    private final Map<String, Object> params;
    private final LeafSearchLookup leafLookup;
    private DoubleSupplier scoreSupplier = () -> 0.0;
    public static final ScriptContext<Factory> CONTEXT = new ScriptContext<Factory>("score", Factory.class);

    public ScoreScript(Map<String, Object> params, SearchLookup lookup, LeafReaderContext leafContext) {
        this.params = params;
        this.leafLookup = lookup.getLeafSearchLookup(leafContext);
    }

    public abstract double execute();

    public Map<String, Object> getParams() {
        return this.params;
    }

    public final Map<String, ScriptDocValues<?>> getDoc() {
        return this.leafLookup.doc();
    }

    public void setDocument(int docid) {
        this.leafLookup.setDocument(docid);
    }

    public void setScorer(Scorer scorer) {
        this.scoreSupplier = () -> {
            try {
                return scorer.score();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        };
    }

    public double get_score() {
        return this.scoreSupplier.getAsDouble();
    }

    public static interface Factory {
        public LeafFactory newFactory(Map<String, Object> var1, SearchLookup var2);
    }

    public static interface LeafFactory {
        public boolean needs_score();

        public ScoreScript newInstance(LeafReaderContext var1) throws IOException;
    }
}

