/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.function.aggregate;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.xpack.sql.expression.Expression;
import org.elasticsearch.xpack.sql.expression.function.Function;
import org.elasticsearch.xpack.sql.expression.function.aggregate.AggregateFunctionAttribute;
import org.elasticsearch.xpack.sql.tree.Location;
import org.elasticsearch.xpack.sql.util.CollectionUtils;

public abstract class AggregateFunction
extends Function {
    private final Expression field;
    private final List<Expression> parameters;
    private AggregateFunctionAttribute lazyAttribute;

    AggregateFunction(Location location, Expression field) {
        this(location, field, Collections.emptyList());
    }

    AggregateFunction(Location location, Expression field, List<Expression> parameters) {
        super(location, CollectionUtils.combine(Collections.singletonList(field), parameters));
        this.field = field;
        this.parameters = parameters;
    }

    public Expression field() {
        return this.field;
    }

    public List<Expression> parameters() {
        return this.parameters;
    }

    @Override
    public AggregateFunctionAttribute toAttribute() {
        if (this.lazyAttribute == null) {
            this.lazyAttribute = new AggregateFunctionAttribute(this.location(), this.name(), this.dataType(), this.id(), this.functionId(), null);
        }
        return this.lazyAttribute;
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        AggregateFunction other = (AggregateFunction)obj;
        return Objects.equals(other.field(), this.field()) && Objects.equals(other.parameters(), this.parameters());
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.field(), this.parameters());
    }
}

