/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.predicate;

import org.elasticsearch.xpack.sql.expression.BinaryOperator;
import org.elasticsearch.xpack.sql.expression.Expression;
import org.elasticsearch.xpack.sql.tree.Location;
import org.elasticsearch.xpack.sql.type.DataType;

public abstract class BinaryComparison
extends BinaryOperator {
    public BinaryComparison(Location location, Expression left, Expression right) {
        super(location, left, right);
    }

    @Override
    protected Expression.TypeResolution resolveInputType(DataType inputType) {
        return Expression.TypeResolution.TYPE_RESOLVED;
    }

    @Override
    protected Expression canonicalize() {
        return this.left().hashCode() > this.right().hashCode() ? this.swapLeftAndRight() : this;
    }

    @Override
    public DataType dataType() {
        return DataType.BOOLEAN;
    }

    public static Integer compare(Object l, Object r) {
        if (l instanceof Number && r instanceof Number) {
            return BinaryComparison.compare((Number)l, (Number)r);
        }
        if (l instanceof Comparable && r instanceof Comparable) {
            try {
                return ((Comparable)l).compareTo(r);
            }
            catch (ClassCastException cce) {
                return null;
            }
        }
        return null;
    }

    static Integer compare(Number l, Number r) {
        if (l instanceof Double || r instanceof Double) {
            return Double.compare(l.doubleValue(), r.doubleValue());
        }
        if (l instanceof Float || r instanceof Float) {
            return Float.compare(l.floatValue(), r.floatValue());
        }
        if (l instanceof Long || r instanceof Long) {
            return Long.compare(l.longValue(), r.longValue());
        }
        return Integer.compare(l.intValue(), r.intValue());
    }
}

