/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.parser;

import java.util.ArrayList;
import java.util.List;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeVisitor;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.elasticsearch.xpack.sql.parser.ParsingException;
import org.elasticsearch.xpack.sql.parser.SqlBaseBaseVisitor;
import org.elasticsearch.xpack.sql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.sql.tree.Location;
import org.elasticsearch.xpack.sql.util.Check;

abstract class AbstractBuilder
extends SqlBaseBaseVisitor<Object> {
    AbstractBuilder() {
    }

    public Object visit(ParseTree tree) {
        Object result = super.visit(tree);
        Check.notNull(result, "Don't know how to handle context [{}] with value [{}]", tree.getClass(), tree.getText());
        return result;
    }

    protected <T> T typedParsing(ParseTree ctx, Class<T> type) {
        Object result = ctx.accept((ParseTreeVisitor)this);
        if (type.isInstance(result)) {
            return (T)result;
        }
        throw new ParsingException(AbstractBuilder.source(ctx), "Invalid query '{}'[{}] given; expected {} but found {}", ctx.getText(), ctx.getClass().getSimpleName(), type.getSimpleName(), result != null ? result.getClass().getSimpleName() : "null");
    }

    protected LogicalPlan plan(ParseTree ctx) {
        return this.typedParsing(ctx, LogicalPlan.class);
    }

    protected List<LogicalPlan> plans(List<? extends ParserRuleContext> ctxs) {
        return this.visitList(ctxs, LogicalPlan.class);
    }

    protected <T> List<T> visitList(List<? extends ParserRuleContext> contexts, Class<T> clazz) {
        ArrayList<T> results = new ArrayList<T>(contexts.size());
        for (ParserRuleContext parserRuleContext : contexts) {
            results.add(clazz.cast(this.visit((ParseTree)parserRuleContext)));
        }
        return results;
    }

    static Location source(ParseTree ctx) {
        if (ctx instanceof ParserRuleContext) {
            return AbstractBuilder.source((ParserRuleContext)ctx);
        }
        return Location.EMPTY;
    }

    static Location source(TerminalNode terminalNode) {
        Check.notNull(terminalNode, "terminalNode is null");
        return AbstractBuilder.source(terminalNode.getSymbol());
    }

    static Location source(ParserRuleContext parserRuleContext) {
        Check.notNull(parserRuleContext, "parserRuleContext is null");
        return AbstractBuilder.source(parserRuleContext.getStart());
    }

    static Location source(Token token) {
        Check.notNull(token, "token is null");
        return new Location(token.getLine(), token.getCharPositionInLine());
    }

    static String text(ParseTree node) {
        return node == null ? null : node.getText();
    }

    static String string(TerminalNode node) {
        return node == null ? null : AbstractBuilder.unquoteString(node.getText());
    }

    static String unquoteString(String text) {
        return text == null ? null : text.substring(1, text.length() - 1).replace("''", "'");
    }

    public Object visitTerminal(TerminalNode node) {
        throw new ParsingException(AbstractBuilder.source(node), "Does not know how to handle {}", node.getText());
    }
}

