/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.parser;

import java.util.Locale;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xpack.sql.ClientSqlException;
import org.elasticsearch.xpack.sql.tree.Location;

public class ParsingException
extends ClientSqlException {
    private final int line;
    private final int charPositionInLine;

    public ParsingException(String message, Exception cause, int line, int charPositionInLine) {
        super(message, cause);
        this.line = line;
        this.charPositionInLine = charPositionInLine;
    }

    ParsingException(String message, Object ... args) {
        this(Location.EMPTY, message, args);
    }

    public ParsingException(Location nodeLocation, String message, Object ... args) {
        super(message, args);
        this.line = nodeLocation.getLineNumber();
        this.charPositionInLine = nodeLocation.getColumnNumber();
    }

    public ParsingException(Exception cause, Location nodeLocation, String message, Object ... args) {
        super(cause, message, args);
        this.line = nodeLocation.getLineNumber();
        this.charPositionInLine = nodeLocation.getColumnNumber();
    }

    public int getLineNumber() {
        return this.line;
    }

    public int getColumnNumber() {
        return this.charPositionInLine + 1;
    }

    public String getErrorMessage() {
        return super.getMessage();
    }

    public RestStatus status() {
        return RestStatus.BAD_REQUEST;
    }

    public String getMessage() {
        return String.format(Locale.ROOT, "line %s:%s: %s", this.getLineNumber(), this.getColumnNumber(), this.getErrorMessage());
    }
}

