/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.plan.physical;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.xpack.sql.plan.physical.PhysicalPlan;
import org.elasticsearch.xpack.sql.tree.Location;

abstract class BinaryExec
extends PhysicalPlan {
    private final PhysicalPlan left;
    private final PhysicalPlan right;

    protected BinaryExec(Location location, PhysicalPlan left, PhysicalPlan right) {
        super(location, Arrays.asList(left, right));
        this.left = left;
        this.right = right;
    }

    @Override
    public final BinaryExec replaceChildren(List<PhysicalPlan> newChildren) {
        if (newChildren.size() != 2) {
            throw new IllegalArgumentException("expected [2] children but received [" + newChildren.size() + "]");
        }
        return this.replaceChildren(newChildren.get(0), newChildren.get(1));
    }

    protected abstract BinaryExec replaceChildren(PhysicalPlan var1, PhysicalPlan var2);

    public PhysicalPlan left() {
        return this.left;
    }

    public PhysicalPlan right() {
        return this.right;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.left, this.right);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        BinaryExec other = (BinaryExec)obj;
        return Objects.equals(this.left, other.left) && Objects.equals(this.right, other.right);
    }
}

