/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.authc;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.xpack.core.security.authc.AuthenticationResult;
import org.elasticsearch.xpack.core.security.authc.AuthenticationToken;
import org.elasticsearch.xpack.core.security.authc.RealmConfig;
import org.elasticsearch.xpack.core.security.user.User;

public abstract class Realm
implements Comparable<Realm> {
    protected final Logger logger;
    protected final String type;
    protected RealmConfig config;

    public String getType() {
        return this.type;
    }

    public Realm(String type, RealmConfig config) {
        this.type = type;
        this.config = config;
        this.logger = config.logger(this.getClass());
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.config.name;
    }

    public int order() {
        return this.config.order;
    }

    public Map<String, List<String>> getAuthenticationFailureHeaders() {
        return Collections.singletonMap("WWW-Authenticate", Collections.singletonList("Basic realm=\"security\" charset=\"UTF-8\""));
    }

    @Override
    public int compareTo(Realm other) {
        int result = Integer.compare(this.config.order, other.config.order);
        if (result == 0) {
            result = this.config.name.compareTo(other.config.name);
        }
        return result;
    }

    public abstract boolean supports(AuthenticationToken var1);

    public abstract AuthenticationToken token(ThreadContext var1);

    public abstract void authenticate(AuthenticationToken var1, ActionListener<AuthenticationResult> var2);

    public abstract void lookupUser(String var1, ActionListener<User> var2);

    public void usageStats(ActionListener<Map<String, Object>> listener) {
        HashMap<String, Object> stats = new HashMap<String, Object>();
        stats.put("name", this.name());
        stats.put("order", this.order());
        listener.onResponse(stats);
    }

    public String toString() {
        return this.type + "/" + this.config.name;
    }

    public static interface Factory {
        public Realm create(RealmConfig var1) throws Exception;
    }
}

