/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.support;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;

public class MetadataUtils {
    public static final String RESERVED_PREFIX = "_";
    public static final String RESERVED_METADATA_KEY = "_reserved";
    public static final Map<String, Object> DEFAULT_RESERVED_METADATA = Collections.singletonMap("_reserved", true);

    private MetadataUtils() {
    }

    public static void writeValue(StringBuilder sb, Object object) {
        if (object == null) {
            sb.append(object);
        } else if (object instanceof Map) {
            sb.append("{");
            for (Map.Entry entry : ((Map)object).entrySet()) {
                sb.append((String)entry.getKey()).append("=");
                MetadataUtils.writeValue(sb, entry.getValue());
            }
            sb.append("}");
        } else if (object instanceof Collection) {
            sb.append("[");
            boolean first = true;
            for (Object item : (Collection)object) {
                if (!first) {
                    sb.append(",");
                }
                MetadataUtils.writeValue(sb, item);
                first = false;
            }
            sb.append("]");
        } else if (object.getClass().isArray()) {
            sb.append("[");
            for (int i = 0; i < Array.getLength(object); ++i) {
                if (i != 0) {
                    sb.append(",");
                }
                MetadataUtils.writeValue(sb, Array.get(object, i));
            }
            sb.append("]");
        } else {
            sb.append(object);
        }
    }

    public static void verifyNoReservedMetadata(Map<String, Object> metadata) {
        for (String key : metadata.keySet()) {
            if (!key.startsWith(RESERVED_PREFIX)) continue;
            throw new IllegalArgumentException("invalid user metadata. [" + key + "] is a reserved for internal use");
        }
    }

    public static boolean containsReservedMetadata(Map<String, Object> metadata) {
        for (String key : metadata.keySet()) {
            if (!key.startsWith(RESERVED_PREFIX)) continue;
            return true;
        }
        return false;
    }
}

