/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.painless.Location;
import org.elasticsearch.painless.MethodWriter;
import org.elasticsearch.painless.ScriptClassInfo;
import org.elasticsearch.painless.lookup.PainlessLookup;
import org.elasticsearch.painless.lookup.PainlessLookupUtility;
import org.elasticsearch.painless.lookup.PainlessMethod;

public final class Locals {
    public static final String LOOP = "#loop";
    public static final String THIS = "#this";
    public static final Set<String> KEYWORDS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("#this", "#loop")));
    private final PainlessLookup painlessLookup;
    private final Locals parent;
    private final Class<?> returnType;
    private final Set<String> keywords;
    private int nextSlotNumber;
    private Map<String, Variable> variables;
    private Map<String, PainlessMethod> methods;

    public static Locals newLocalScope(Locals currentScope) {
        return new Locals(currentScope);
    }

    public static Locals newLambdaScope(Locals programScope, Class<?> returnType, List<Parameter> parameters, int captureCount, int maxLoopCounter) {
        Locals locals = new Locals(programScope, programScope.painlessLookup, returnType, KEYWORDS);
        for (int i = 0; i < parameters.size(); ++i) {
            Parameter parameter = parameters.get(i);
            boolean isCapture = true;
            locals.addVariable(parameter.location, parameter.clazz, parameter.name, isCapture);
        }
        if (maxLoopCounter > 0) {
            locals.defineVariable(null, Integer.TYPE, LOOP, true);
        }
        return locals;
    }

    public static Locals newFunctionScope(Locals programScope, Class<?> returnType, List<Parameter> parameters, int maxLoopCounter) {
        Locals locals = new Locals(programScope, programScope.painlessLookup, returnType, KEYWORDS);
        for (Parameter parameter : parameters) {
            locals.addVariable(parameter.location, parameter.clazz, parameter.name, false);
        }
        if (maxLoopCounter > 0) {
            locals.defineVariable(null, Integer.TYPE, LOOP, true);
        }
        return locals;
    }

    public static Locals newMainMethodScope(ScriptClassInfo scriptClassInfo, Locals programScope, int maxLoopCounter) {
        Locals locals = new Locals(programScope, programScope.painlessLookup, scriptClassInfo.getExecuteMethodReturnType(), KEYWORDS);
        locals.defineVariable(null, Object.class, THIS, true);
        for (ScriptClassInfo.MethodArgument arg : scriptClassInfo.getExecuteArguments()) {
            locals.defineVariable(null, arg.getClazz(), arg.getName(), true);
        }
        if (maxLoopCounter > 0) {
            locals.defineVariable(null, Integer.TYPE, LOOP, true);
        }
        return locals;
    }

    public static Locals newProgramScope(PainlessLookup painlessLookup, Collection<PainlessMethod> methods) {
        Locals locals = new Locals(null, painlessLookup, null, null);
        for (PainlessMethod method : methods) {
            locals.addMethod(method);
        }
        return locals;
    }

    public boolean hasVariable(String name) {
        Variable variable = this.lookupVariable(null, name);
        if (variable != null) {
            return true;
        }
        if (this.parent != null) {
            return this.parent.hasVariable(name);
        }
        return false;
    }

    public Variable getVariable(Location location, String name) {
        Variable variable = this.lookupVariable(location, name);
        if (variable != null) {
            return variable;
        }
        if (this.parent != null) {
            return this.parent.getVariable(location, name);
        }
        throw location.createError(new IllegalArgumentException("Variable [" + name + "] is not defined."));
    }

    public PainlessMethod getMethod(String key) {
        PainlessMethod method = this.lookupMethod(key);
        if (method != null) {
            return method;
        }
        if (this.parent != null) {
            return this.parent.getMethod(key);
        }
        return null;
    }

    public Variable addVariable(Location location, Class<?> clazz, String name, boolean readonly) {
        if (this.hasVariable(name)) {
            throw location.createError(new IllegalArgumentException("Variable [" + name + "] is already defined."));
        }
        if (this.keywords.contains(name)) {
            throw location.createError(new IllegalArgumentException("Variable [" + name + "] is reserved."));
        }
        return this.defineVariable(location, clazz, name, readonly);
    }

    public Class<?> getReturnType() {
        return this.returnType;
    }

    public Locals getProgramScope() {
        Locals locals = this;
        while (locals.getParent() != null) {
            locals = locals.getParent();
        }
        return locals;
    }

    public PainlessLookup getPainlessLookup() {
        return this.painlessLookup;
    }

    private Locals(Locals parent) {
        this(parent, parent.painlessLookup, parent.returnType, parent.keywords);
    }

    private Locals(Locals parent, PainlessLookup painlessLookup, Class<?> returnType, Set<String> keywords) {
        this.parent = parent;
        this.painlessLookup = painlessLookup;
        this.returnType = returnType;
        this.keywords = keywords;
        this.nextSlotNumber = parent == null ? 0 : parent.getNextSlot();
    }

    private Locals getParent() {
        return this.parent;
    }

    private Variable lookupVariable(Location location, String name) {
        if (this.variables == null) {
            return null;
        }
        return this.variables.get(name);
    }

    private PainlessMethod lookupMethod(String key) {
        if (this.methods == null) {
            return null;
        }
        return this.methods.get(key);
    }

    private Variable defineVariable(Location location, Class<?> type, String name, boolean readonly) {
        if (this.variables == null) {
            this.variables = new HashMap<String, Variable>();
        }
        Variable variable = new Variable(location, name, type, this.getNextSlot(), readonly);
        this.variables.put(name, variable);
        this.nextSlotNumber += MethodWriter.getType(type).getSize();
        return variable;
    }

    private void addMethod(PainlessMethod method) {
        if (this.methods == null) {
            this.methods = new HashMap<String, PainlessMethod>();
        }
        this.methods.put(PainlessLookupUtility.buildPainlessMethodKey(method.name, method.arguments.size()), method);
    }

    private int getNextSlot() {
        return this.nextSlotNumber;
    }

    public static final class Parameter {
        public final Location location;
        public final String name;
        public final Class<?> clazz;

        public Parameter(Location location, String name, Class<?> clazz) {
            this.location = location;
            this.name = name;
            this.clazz = clazz;
        }
    }

    public static final class Variable {
        public final Location location;
        public final String name;
        public final Class<?> clazz;
        public final boolean readonly;
        private final int slot;
        private boolean used;

        public Variable(Location location, String name, Class<?> clazz, int slot, boolean readonly) {
            this.location = location;
            this.name = name;
            this.clazz = clazz;
            this.slot = slot;
            this.readonly = readonly;
        }

        public int getSlot() {
            return this.slot;
        }

        public String toString() {
            StringBuilder b = new StringBuilder();
            b.append("Variable[type=").append(PainlessLookupUtility.typeToCanonicalTypeName(this.clazz));
            b.append(",name=").append(this.name);
            b.append(",slot=").append(this.slot);
            if (this.readonly) {
                b.append(",readonly");
            }
            b.append(']');
            return b.toString();
        }
    }
}

