/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless.node;

import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.elasticsearch.painless.Globals;
import org.elasticsearch.painless.Locals;
import org.elasticsearch.painless.Location;
import org.elasticsearch.painless.MethodWriter;
import org.elasticsearch.painless.lookup.PainlessLookupUtility;
import org.elasticsearch.painless.lookup.PainlessMethod;
import org.elasticsearch.painless.lookup.def;
import org.elasticsearch.painless.node.AExpression;
import org.objectweb.asm.Type;

public final class EMapInit
extends AExpression {
    private final List<AExpression> keys;
    private final List<AExpression> values;
    private PainlessMethod constructor = null;
    private PainlessMethod method = null;

    public EMapInit(Location location, List<AExpression> keys, List<AExpression> values) {
        super(location);
        this.keys = keys;
        this.values = values;
    }

    @Override
    void extractVariables(Set<String> variables) {
        for (AExpression key : this.keys) {
            key.extractVariables(variables);
        }
        for (AExpression value : this.values) {
            value.extractVariables(variables);
        }
    }

    @Override
    void analyze(Locals locals) {
        AExpression expression;
        int index;
        if (!this.read) {
            throw this.createError(new IllegalArgumentException("Must read from map initializer."));
        }
        this.actual = HashMap.class;
        this.constructor = locals.getPainlessLookup().getPainlessStructFromJavaClass(this.actual).constructors.get(PainlessLookupUtility.buildPainlessMethodKey("<init>", 0));
        if (this.constructor == null) {
            throw this.createError(new IllegalStateException("Illegal tree structure."));
        }
        this.method = locals.getPainlessLookup().getPainlessStructFromJavaClass(this.actual).methods.get(PainlessLookupUtility.buildPainlessMethodKey("put", 2));
        if (this.method == null) {
            throw this.createError(new IllegalStateException("Illegal tree structure."));
        }
        if (this.keys.size() != this.values.size()) {
            throw this.createError(new IllegalStateException("Illegal tree structure."));
        }
        for (index = 0; index < this.keys.size(); ++index) {
            expression = this.keys.get(index);
            expression.expected = def.class;
            expression.internal = true;
            expression.analyze(locals);
            this.keys.set(index, expression.cast(locals));
        }
        for (index = 0; index < this.values.size(); ++index) {
            expression = this.values.get(index);
            expression.expected = def.class;
            expression.internal = true;
            expression.analyze(locals);
            this.values.set(index, expression.cast(locals));
        }
    }

    @Override
    void write(MethodWriter writer, Globals globals) {
        writer.writeDebugInfo(this.location);
        writer.newInstance(MethodWriter.getType(this.actual));
        writer.dup();
        writer.invokeConstructor(Type.getType(this.constructor.target), this.constructor.method);
        for (int index = 0; index < this.keys.size(); ++index) {
            AExpression key = this.keys.get(index);
            AExpression value = this.values.get(index);
            writer.dup();
            key.write(writer, globals);
            value.write(writer, globals);
            this.method.write(writer);
            writer.pop();
        }
    }

    @Override
    public String toString() {
        return this.singleLineToString(this.pairwiseToString(this.keys, this.values));
    }
}

