/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.time;

import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.TemporalAccessor;

public class CompoundDateTimeFormatter {
    final DateTimeFormatter printer;
    final DateTimeFormatter[] parsers;

    CompoundDateTimeFormatter(DateTimeFormatter ... parsers) {
        if (parsers.length == 0) {
            throw new IllegalArgumentException("at least one date time formatter is required");
        }
        this.printer = parsers[0];
        this.parsers = parsers;
    }

    public TemporalAccessor parse(String input) {
        DateTimeParseException failure = null;
        for (int i = 0; i < this.parsers.length; ++i) {
            try {
                return this.parsers[i].parse(input);
            }
            catch (DateTimeParseException e) {
                if (failure == null) {
                    failure = e;
                    continue;
                }
                failure.addSuppressed(e);
                continue;
            }
        }
        throw failure;
    }

    public CompoundDateTimeFormatter withZone(ZoneId zoneId) {
        DateTimeFormatter[] parsersWithZone = new DateTimeFormatter[this.parsers.length];
        for (int i = 0; i < this.parsers.length; ++i) {
            parsersWithZone[i] = this.parsers[i].withZone(zoneId);
        }
        return new CompoundDateTimeFormatter(parsersWithZone);
    }

    public String format(TemporalAccessor accessor) {
        return this.printer.format(accessor);
    }
}

