/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.tasks;

import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskListener;

public final class LoggingTaskListener<Response>
implements TaskListener<Response> {
    private static final Logger logger = Loggers.getLogger(LoggingTaskListener.class);
    private static final LoggingTaskListener<Object> INSTANCE = new LoggingTaskListener();

    public static <Response> TaskListener<Response> instance() {
        return INSTANCE;
    }

    private LoggingTaskListener() {
    }

    @Override
    public void onResponse(Task task, Response response) {
        logger.info("{} finished with response {}", (Object)task.getId(), (Object)response);
    }

    @Override
    public void onFailure(Task task, Throwable e) {
        logger.warn(() -> new ParameterizedMessage("{} failed with exception", (Object)task.getId()), e);
    }
}

