/*
 * Decompiled with CFR 0.152.
 */
package freemind.controller;

import freemind.controller.StructuredMenuHolder;
import freemind.main.Resources;
import java.util.HashSet;
import java.util.logging.Logger;
import javax.swing.JPopupMenu;
import javax.swing.event.MenuListener;

public class FreeMindPopupMenu
extends JPopupMenu
implements StructuredMenuHolder.MenuEventSupplier {
    private HashSet listeners = new HashSet();
    protected static Logger logger = null;

    public FreeMindPopupMenu() {
        if (logger == null) {
            logger = Resources.getInstance().getLogger(this.getClass().getName());
        }
    }

    @Override
    protected void firePopupMenuWillBecomeVisible() {
        super.firePopupMenuWillBecomeVisible();
        logger.fine("Popup firePopupMenuWillBecomeVisible called.");
        for (MenuListener listener : this.listeners) {
            listener.menuSelected(null);
        }
    }

    @Override
    public void addMenuListener(MenuListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeMenuListener(MenuListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    protected void firePopupMenuCanceled() {
        super.firePopupMenuCanceled();
        for (MenuListener listener : this.listeners) {
            listener.menuCanceled(null);
        }
    }

    @Override
    protected void firePopupMenuWillBecomeInvisible() {
        super.firePopupMenuWillBecomeInvisible();
        for (MenuListener listener : this.listeners) {
            listener.menuDeselected(null);
        }
    }
}

