/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.processors;

import javax.annotation.Nullable;
import org.gradle.api.internal.tasks.testing.DefaultTestSuiteDescriptor;
import org.gradle.api.internal.tasks.testing.TestClassProcessor;
import org.gradle.api.internal.tasks.testing.TestCompleteEvent;
import org.gradle.api.internal.tasks.testing.TestResultProcessor;
import org.gradle.api.internal.tasks.testing.TestStartEvent;
import org.gradle.api.internal.tasks.testing.results.AttachParentTestResultProcessor;
import org.gradle.internal.time.Clock;

public class TestMainAction
implements Runnable {
    private final Runnable detector;
    private final TestClassProcessor processor;
    private final TestResultProcessor resultProcessor;
    private final Clock clock;
    private final Object testTaskOperationId;
    private final Object rootTestSuiteId;
    private final String displayName;

    public TestMainAction(Runnable detector, TestClassProcessor processor, TestResultProcessor resultProcessor, Clock clock, Object testTaskOperationId, Object rootTestSuiteId, String displayName) {
        this.detector = detector;
        this.processor = processor;
        this.resultProcessor = new AttachParentTestResultProcessor(resultProcessor);
        this.clock = clock;
        this.testTaskOperationId = testTaskOperationId;
        this.rootTestSuiteId = rootTestSuiteId;
        this.displayName = displayName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        RootTestSuiteDescriptor suite = new RootTestSuiteDescriptor(this.rootTestSuiteId, this.displayName, this.testTaskOperationId);
        this.resultProcessor.started(suite, new TestStartEvent(this.clock.getCurrentTime()));
        try {
            this.processor.startProcessing(this.resultProcessor);
            try {
                this.detector.run();
            }
            finally {
                this.processor.stop();
            }
        }
        finally {
            this.resultProcessor.completed(suite.getId(), new TestCompleteEvent(this.clock.getCurrentTime()));
        }
    }

    public static final class RootTestSuiteDescriptor
    extends DefaultTestSuiteDescriptor {
        private final Object testTaskOperationId;

        private RootTestSuiteDescriptor(Object id, String name, Object testTaskOperationId) {
            super(id, name);
            this.testTaskOperationId = testTaskOperationId;
        }

        @Override
        @Nullable
        public Object getOwnerBuildOperationId() {
            return this.testTaskOperationId;
        }

        @Override
        public String toString() {
            return this.getName();
        }

        @Override
        public boolean isRoot() {
            return true;
        }
    }
}

