/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.util;

import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.util.MultikeyShortcutAction;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public final class MultikeyActionsHandler {
    private static final long DIALOG_DELAY = 1000L;
    private static final String STATUS_BAR_ID = "multikeyShortcut";
    private final Map<MultikeyShortcutAction, MyAction> myActions = new HashMap<MultikeyShortcutAction, MyAction>();
    private long lastTimestamp;
    private MyAction lastAction;
    private final Timer timer;
    private static MultikeyActionsHandler instance;

    private MultikeyActionsHandler() {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(new MyKeyEventDispatcher());
        this.timer = new Timer();
    }

    public static synchronized MultikeyActionsHandler getInstance() {
        if (instance == null) {
            instance = new MultikeyActionsHandler();
        }
        return instance;
    }

    private static String formatMenuText(KeyStroke keyStroke, String index, String description) {
        String shortcutText = Shortcut.getKeyText(keyStroke) + ',' + index;
        return "<html><i>" + shortcutText + "</i>&nbsp;&nbsp;&nbsp;&nbsp;" + description;
    }

    public void addAction(MultikeyShortcutAction action) {
        if (action.getMultikeyShortcut() != null) {
            MyAction myAction = new MyAction(action);
            this.myActions.put(action, myAction);
            MainApplication.registerActionShortcut(myAction, myAction.shortcut);
        }
    }

    public void removeAction(MultikeyShortcutAction action) {
        MyAction a = this.myActions.get(action);
        if (a != null) {
            MainApplication.unregisterActionShortcut(a, a.shortcut);
            this.myActions.remove(action);
        }
    }

    private class MyTimerTask
    extends TimerTask {
        private final long lastTimestamp;
        private final MyAction lastAction;

        MyTimerTask(long lastTimestamp, MyAction lastAction) {
            this.lastTimestamp = lastTimestamp;
            this.lastAction = lastAction;
        }

        @Override
        public void run() {
            if (this.lastTimestamp == MultikeyActionsHandler.this.lastTimestamp && this.lastAction == MultikeyActionsHandler.this.lastAction) {
                SwingUtilities.invokeLater(new ShowLayersPopupWorker(this.lastAction));
                MultikeyActionsHandler.this.lastAction = null;
            }
        }
    }

    private class MyAction
    extends AbstractAction {
        private final transient MultikeyShortcutAction action;
        private final transient Shortcut shortcut;

        MyAction(MultikeyShortcutAction action) {
            this.action = action;
            this.shortcut = action.getMultikeyShortcut();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MultikeyActionsHandler.this.lastTimestamp = e.getWhen();
            MultikeyActionsHandler.this.lastAction = this;
            MultikeyActionsHandler.this.timer.schedule((TimerTask)new MyTimerTask(MultikeyActionsHandler.this.lastTimestamp, MultikeyActionsHandler.this.lastAction), 1000L);
            MainApplication.getMap().statusLine.setHelpText(MultikeyActionsHandler.STATUS_BAR_ID, I18n.tr("{0}... [please type its number]", (String)this.action.getValue("ShortDescription")));
        }

        public String toString() {
            return "MultikeyAction" + this.action;
        }
    }

    private class MyKeyEventDispatcher
    implements KeyEventDispatcher {
        private MyKeyEventDispatcher() {
        }

        @Override
        public boolean dispatchKeyEvent(KeyEvent e) {
            if (e.getWhen() == MultikeyActionsHandler.this.lastTimestamp) {
                return false;
            }
            if (MultikeyActionsHandler.this.lastAction != null && e.getID() == 401) {
                int index = this.getIndex(e.getKeyCode());
                if (index >= 0) {
                    MultikeyActionsHandler.this.lastAction.action.executeMultikeyAction(index, e.getKeyCode() == MultikeyActionsHandler.this.lastAction.shortcut.getKeyStroke().getKeyCode());
                }
                MultikeyActionsHandler.this.lastAction = null;
                MainApplication.getMap().statusLine.resetHelpText(MultikeyActionsHandler.STATUS_BAR_ID);
                return true;
            }
            return false;
        }

        private int getIndex(int lastKey) {
            if (lastKey >= 49 && lastKey <= 57) {
                return lastKey - 49;
            }
            if (lastKey == 48) {
                return 9;
            }
            if (lastKey >= 65 && lastKey <= 90) {
                return lastKey - 65 + 10;
            }
            return -1;
        }
    }

    static final class ShowLayersPopupWorker
    implements Runnable {
        private final MyAction action;

        ShowLayersPopupWorker(MyAction action) {
            this.action = action;
        }

        @Override
        public void run() {
            MultikeyShortcutAction.MultikeyInfo lastLayer;
            JPopupMenu layers = new JPopupMenu();
            JMenuItem lbTitle = new JMenuItem((String)this.action.action.getValue("ShortDescription"));
            lbTitle.setEnabled(false);
            JPanel pnTitle = new JPanel();
            pnTitle.add(lbTitle);
            layers.add(pnTitle);
            char repeatKey = (char)this.action.shortcut.getKeyStroke().getKeyCode();
            boolean repeatKeyUsed = false;
            for (MultikeyShortcutAction.MultikeyInfo info : this.action.action.getMultikeyCombinations()) {
                if (info.getShortcut() == repeatKey) {
                    repeatKeyUsed = true;
                }
                JMenuItem item = new JMenuItem(MultikeyActionsHandler.formatMenuText(this.action.shortcut.getKeyStroke(), String.valueOf(info.getShortcut()), info.getDescription()));
                item.setMnemonic(info.getShortcut());
                item.addActionListener(e -> this.action.action.executeMultikeyAction(info.getIndex(), false));
                layers.add(item);
            }
            if (!repeatKeyUsed && (lastLayer = this.action.action.getLastMultikeyAction()) != null) {
                JMenuItem repeateItem = new JMenuItem(MultikeyActionsHandler.formatMenuText(this.action.shortcut.getKeyStroke(), KeyEvent.getKeyText(this.action.shortcut.getKeyStroke().getKeyCode()), "Repeat " + lastLayer.getDescription()));
                repeateItem.setMnemonic(this.action.shortcut.getKeyStroke().getKeyCode());
                repeateItem.addActionListener(e -> this.action.action.executeMultikeyAction(-1, true));
                layers.add(repeateItem);
            }
            layers.addPopupMenuListener(new StatusLinePopupMenuListener());
            layers.show(MainApplication.getMainFrame(), Integer.MAX_VALUE, Integer.MAX_VALUE);
            layers.setLocation(MainApplication.getMainFrame().getX() + MainApplication.getMainFrame().getWidth() - layers.getWidth(), MainApplication.getMainFrame().getY() + MainApplication.getMainFrame().getHeight() - layers.getHeight());
        }

        static final class StatusLinePopupMenuListener
        implements PopupMenuListener {
            StatusLinePopupMenuListener() {
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                MainApplication.getMap().statusLine.resetHelpText(MultikeyActionsHandler.STATUS_BAR_ID);
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        }
    }
}

