/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.widgets;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractCellEditor;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.LineBorder;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class ButtonColumn
extends AbstractCellEditor
implements TableCellRenderer,
TableCellEditor,
ActionListener {
    private final Action action;
    private final JButton renderButton;
    private final JButton editButton;
    private Object editorValue;
    private String buttonName;

    public ButtonColumn() {
        this(null);
    }

    public ButtonColumn(Action action, String buttonName) {
        this(action);
        this.buttonName = buttonName;
    }

    public ButtonColumn(Action action) {
        this.action = action;
        this.renderButton = new JButton();
        this.editButton = new JButton();
        this.editButton.setFocusPainted(false);
        this.editButton.addActionListener(this);
        this.editButton.setBorder(new LineBorder(Color.BLUE));
    }

    @Override
    public Object getCellEditorValue() {
        return this.editorValue;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.action.actionPerformed(e);
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.editorValue = value;
        if (this.buttonName != null) {
            this.editButton.setText(this.buttonName);
            this.editButton.setIcon(null);
        } else if (value == null) {
            this.editButton.setText("");
            this.editButton.setIcon(null);
        } else if (value instanceof Icon) {
            this.editButton.setText("");
            this.editButton.setIcon((Icon)value);
        } else {
            this.editButton.setText(value.toString());
            this.editButton.setIcon(null);
        }
        return this.editButton;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (isSelected) {
            this.renderButton.setForeground(table.getSelectionForeground());
            this.renderButton.setBackground(table.getSelectionBackground());
        } else {
            this.renderButton.setForeground(table.getForeground());
            this.renderButton.setBackground(UIManager.getColor("Button.background"));
        }
        this.renderButton.setFocusPainted(hasFocus);
        if (this.buttonName != null) {
            this.renderButton.setText(this.buttonName);
            this.renderButton.setIcon(null);
        } else if (value == null) {
            this.renderButton.setText("");
            this.renderButton.setIcon(null);
        } else if (value instanceof Icon) {
            this.renderButton.setText("");
            this.renderButton.setIcon((Icon)value);
        } else {
            this.renderButton.setText(value.toString());
            this.renderButton.setIcon(null);
        }
        return this.renderButton;
    }
}

