/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.rules.Categories;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.TextLevelRule;

public class PunctuationMarkAtParagraphEnd
extends TextLevelRule {
    private static final String[] PUNCTUATION_MARKS = new String[]{".", "!", "?", ":", ",", ";"};
    private static final String[] QUOTATION_MARKS = new String[]{"\u201e", "\u00bb", "\u00ab", "\"", "\u201d", "\u2033", "\u2019", "\u201a", "\u2018", "\u203a", "\u2039", "\u2032", "'"};

    public PunctuationMarkAtParagraphEnd(ResourceBundle messages) {
        super(messages);
        super.setCategory(Categories.PUNCTUATION.getCategory(messages));
        this.setLocQualityIssueType(ITSIssueType.Grammar);
    }

    @Override
    public String getId() {
        return "PUNCTUATION_PARAGRAPH_END";
    }

    @Override
    public String getDescription() {
        return this.messages.getString("punctuation_mark_paragraph_end_desc");
    }

    private static boolean stringEqualsAny(String token, String[] any) {
        for (int i = 0; i < any.length; ++i) {
            if (!token.equals(any[i])) continue;
            return true;
        }
        return false;
    }

    private static boolean isQuotationMark(AnalyzedTokenReadings tk) {
        return PunctuationMarkAtParagraphEnd.stringEqualsAny(tk.getToken(), QUOTATION_MARKS);
    }

    private static boolean isPunctuationMark(AnalyzedTokenReadings tk) {
        return PunctuationMarkAtParagraphEnd.stringEqualsAny(tk.getToken(), PUNCTUATION_MARKS);
    }

    private static boolean isWord(AnalyzedTokenReadings tk) {
        return Character.isLetter(tk.getToken().charAt(0));
    }

    private static boolean isWhitespace(AnalyzedTokenReadings token) {
        return token.isWhitespace() && !token.isLinebreak();
    }

    private static boolean isParaBreak(AnalyzedTokenReadings token) {
        return "\n".equals(token.getToken()) || "\r\n".equals(token.getToken()) || "\n\r".equals(token.getToken());
    }

    @Override
    public RuleMatch[] match(List<AnalyzedSentence> sentences) throws IOException {
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        int lastPara = -1;
        int pos = 0;
        boolean doCheck = true;
        boolean isFirstWord = false;
        for (int n = 0; n < sentences.size(); ++n) {
            int i;
            AnalyzedSentence sentence = sentences.get(n);
            AnalyzedTokenReadings[] tokens = sentence.getTokens();
            if (doCheck) {
                for (i = 1; i < tokens.length && PunctuationMarkAtParagraphEnd.isWhitespace(tokens[i]); ++i) {
                }
                isFirstWord = i < tokens.length ? tokens.length > i + 2 && (PunctuationMarkAtParagraphEnd.isWord(tokens[i]) && !PunctuationMarkAtParagraphEnd.isPunctuationMark(tokens[i + 1]) || PunctuationMarkAtParagraphEnd.isQuotationMark(tokens[i]) && PunctuationMarkAtParagraphEnd.isWord(tokens[i + 1]) && !PunctuationMarkAtParagraphEnd.isPunctuationMark(tokens[i + 2])) : false;
                doCheck = false;
            }
            for (i = 1; i < tokens.length; ++i) {
                if (!PunctuationMarkAtParagraphEnd.isParaBreak(tokens[i]) && (n != sentences.size() - 1 || i != tokens.length - 1)) continue;
                if (n - lastPara > 1 && isFirstWord) {
                    if (n == sentences.size() - 1 && i == tokens.length - 1) {
                        ++i;
                    }
                    --i;
                    while (i > 0 && PunctuationMarkAtParagraphEnd.isWhitespace(tokens[i])) {
                        --i;
                    }
                    if (i > 0 && (PunctuationMarkAtParagraphEnd.isWord(tokens[i]) || i < tokens.length - 1 && PunctuationMarkAtParagraphEnd.isQuotationMark(tokens[i]) && PunctuationMarkAtParagraphEnd.isWord(tokens[i + 1]))) {
                        int fromPos = pos + tokens[i].getStartPos();
                        int toPos = pos + tokens[i].getEndPos();
                        RuleMatch ruleMatch = new RuleMatch((Rule)this, sentence, fromPos, toPos, this.messages.getString("punctuation_mark_paragraph_end_msg"));
                        ArrayList<String> replacements = new ArrayList<String>();
                        for (int j = 0; j < PUNCTUATION_MARKS.length; ++j) {
                            replacements.add(tokens[i].getToken() + PUNCTUATION_MARKS[j]);
                        }
                        ruleMatch.setSuggestedReplacements(replacements);
                        ruleMatches.add(ruleMatch);
                    }
                }
                lastPara = n;
                isFirstWord = false;
                doCheck = true;
            }
            pos += sentence.getText().length();
        }
        return this.toRuleMatchArray(ruleMatches);
    }
}

