#include <string.h>
#include <stdlib.h>
#include <unistd.h>

#ifndef PI
#define PI 3.1415926535897932384626433832795028841971693993751
#endif

#define	MAXWID	8.5	/* default limits max picture to 8.5 x 11; */
#define	MAXHT	11	/* change to taste without peril */

#define	dprintf	if(dbg)printf

extern	char	errbuf[200];

#undef	sprintf	/* Snow Leopard */

#define	ERROR	sprintf(errbuf,
#define	FATAL	), yyerror(errbuf), exit(1)
#define	WARNING	), yyerror(errbuf)

#define	DEFAULT	0

#define	HEAD1	1
#define	HEAD2	2
#define	HEAD12	(HEAD1+HEAD2)
#define	INVIS	4
#define	CW_ARC	8	/* clockwise arc */
#define	DOTBIT	16	/* line styles */
#define	DASHBIT	32
#define	FILLBIT	64	/* gray-fill on boxes, etc. */

#define	CENTER	01	/* text attributes */
#define	LJUST	02
#define	RJUST	04
#define	ABOVE	010
#define	BELOW	020
#define	SPREAD	040

#define	SCALE	1.0	/* default scale: units/inch */
#define	WID	0.75	/* default width for boxes and ellipses */
#define	WID2	0.375
#define	HT	0.5	/* default height and line length */
#define	HT2	(HT/2)
#define	HT5	(HT/5)
#define	HT10	(HT/10)

/* these have to be like so, so that we can write */
/* things like R & V, etc. */
#define	H	0
#define	V	1
#define	R_DIR	0
#define	U_DIR	1
#define	L_DIR	2
#define	D_DIR	3
#define	ishor(n)	(((n) & V) == 0)
#define	isvert(n)	(((n) & V) != 0)
#define	isright(n)	((n) == R_DIR)
#define	isleft(n)	((n) == L_DIR)
#define	isdown(n)	((n) == D_DIR)
#define	isup(n)		((n) == U_DIR)

typedef	float	ofloat;	/* for o_val[] in obj;  could be double */

typedef struct obj {	/* stores various things in variable length */
	int	o_type;
	int	o_count;	/* number of things */
	int	o_nobj;		/* index in objlist */
	int	o_mode;		/* hor or vert */
	float	o_x;		/* coord of "center" */
	float	o_y;
	int	o_nt1;		/* 1st index in text[] for this object */
	int	o_nt2;		/* 2nd; difference is #text strings */
	int	o_attr;		/* HEAD, CW, INVIS, etc., go here */
	int	o_size;		/* linesize */
	int	o_nhead;	/* arrowhead style */
	struct symtab *o_symtab; /* symtab for [...] */
	float	o_ddval;	/* value of dot/dash expression */
	float	o_fillval;	/* gray scale value */
	ofloat	o_val[1];	/* actually this will be > 1 in general */
				/* type is not always FLOAT!!!! */
} obj;

typedef union {		/* the yacc stack type */
	int	i;
	char	*p;
	obj	*o;
	double	f;
	struct symtab *st;
} YYSTYPE;

extern	YYSTYPE	yylval, yyval;

struct symtab {
	char	*s_name;
	int	s_type;
	YYSTYPE	s_val;
	struct symtab *s_next;
};

typedef struct {	/* attribute of an object */
	int	a_type;
	int	a_sub;
	YYSTYPE	a_val;
} Attr;

typedef struct {
	int	t_type;		/* CENTER, LJUST, etc. */
	char	t_op;		/* optional sign for size changes */
	char	t_size;		/* size, abs or rel */
	char	*t_val;
} Text;

#define	String	01
#define	Macro	02
#define	File	04
#define	Char	010
#define	Thru	020
#define	Free	040

typedef struct {	/* input source */
	int	type;	/* Macro, String, File */
	char	*sp;	/* if String or Macro */
} Src;

extern	Src	src[], *srcp;	/* input source stack */

typedef struct {
	FILE	*fin;
	char	*fname;
	int	lineno;
} Infile;

extern	Infile	infile[], *curfile;

#define	MAXARGS	20
typedef struct {	/* argument stack */
	char	*argstk[MAXARGS];	/* pointers to args */
	char	*argval;	/* points to space containing args */
} Arg;

extern	int	dbg;
extern	obj	**objlist;
extern	int	nobj, nobjlist;
extern	Attr	*attr;
extern	int	nattr, nattrlist;
extern	Text	*text;
extern	int	ntextlist;
extern	int	ntext;
extern	int	ntext1;
extern	double	curx, cury;
extern	int	hvmode;
extern	int	codegen;
extern	int	PEseen;
extern	double	deltx, delty;
extern	int	lineno;
extern	int	synerr;

extern	double	xmin, ymin, xmax, ymax;

struct pushstack {
	double	p_x;
	double	p_y;
	int	p_hvmode;
	double	p_xmin;
	double	p_ymin;
	double	p_xmax;
	double	p_ymax;
	struct symtab *p_symtab;
};
extern	struct pushstack stack[];
extern	int	nstack;
extern	int	cw;


#define	Log10(x) errcheck(log10(x), "log")
#define	Exp(x)	errcheck(exp(x), "exp")
#define	Sqrt(x)	errcheck(sqrt(x), "sqrt")


char*		addnewline(char *p)	/* add newline to end of p */;
obj*		addpos(obj *p, obj *q);
void		addtattr(int sub)		/* add text attrib to existing item */;
void		arc(double xc, double yc, double x0, double y0, double x1, double y1)	/* draw arc with center xc,yc */;
void		arc_extreme(double x0, double y0, double x1, double y1, double xc, double yc);
obj*		arcgen(int type)	/* handles circular and (eventually) elliptical arcs */;
void		arrow(double x0, double y0, double x1, double y1, double w, double h, double ang, int nhead) 	/* draw arrow (without shaft) */ /* head wid w, len h, rotated ang */ /* and drawn with nhead lines */;
int		baldelim(int c, char *s)	/* replace c by balancing entry in s */;
void		blockadj(obj *p)	/* adjust coords in block starting at p */;
obj*		blockgen(obj *p, obj *q)	/* handles [...] */;
obj*		boxgen(void);
void		checkscale(char *s)	/* if s is "scale", adjust default variables */;
obj*		circgen(int type);
void		copy(void)	/* begin input from file, etc. */;
void		copydef(struct symtab *p)	/* remember macro symtab ptr */;
void		copyfile(char *s)	/* remember file to start reading from */;
struct symtab*	copythru(char *s)	/* collect the macro name or body for thru */;
void		copyuntil(char *s)	/* string that terminates a thru */;
int		curdir(void)	/* convert current dir (hvmode) to RIGHT, LEFT, etc. */;
void		definition(char *s)	/* collect definition for s and install */ /* definitions picked up lexically */;
char*		delimstr(char *s)	/* get body of X ... X */ 	/* message if too big */;
void		do_thru(void)	/* read one line, make into a macro expansion */;
void		dodef(struct symtab *stp)	/* collect args and switch input to defn */;
void		dot(void);
void		dotbox(double x0, double y0, double x1, double y1, int ddtype, double ddval)	/* dotted or dashed box */;
void		dotext(obj *p)	/* print text strings of p in proper vertical spacing */;
void		dotline(double x0, double y0, double x1, double y1, int ddtype, double ddval);
void		dotline(double x0, double y0, double x1, double y1, int ddtype, double ddval) /* dotted line */;
void		ellipse(double x, double y, double r1, double r2);
void		endfor(void)	/* end one iteration of for loop */;
void		eprint(void)	/* try to print context around error */;
double		errcheck(double x, char *s);
void		exprsave(double f);
void		extreme(double x, double y)	/* record max and min x and y values */;
void		fillend(void);
void		fillstart(double v)	/* only choose black, light grey (.75), or white, for now */;
obj*		fixpos(obj *p, double x, double y);
void		forloop(char *, double, double, int, double, char *)	/* set up a for loop */;
void		fpecatch(int arg);
void		freedef(char *s)	/* free definition for string s */;
void		freesymtab(struct symtab *p)	/* free space used by symtab at p */;
int		getarg(char *p)	/* pick up single argument, store in p, return length */;
YYSTYPE		getblk(obj *p, char *s)	/* find union type for s in p */;
double		getblkvar(obj *p, char *s)	/* find variable s2 in block p */;
obj*		getblock(obj *p, char *s)	/* find variable s in block p */;
double		getcomp(obj *p, int t)	/* return component of a position */;
void		getdata(void);
obj*		getfirst(int n, int t)	/* find n-th occurrence of type t */;
double		getfval(char *s)	/* return float value of variable s */;
obj*		gethere(void)	/* make a place for curx,cury */;
obj*		getlast(int n, int t)	/* find n-th previous occurrence of type t */;
obj*		getpos(obj *p, int corner)	/* find position of point */;
YYSTYPE		getvar(char *s)	/* return value of variable s (usually pointer) */;
char *		grow(char *ptr, char *name, int num, int size)	/* make array bigger */;
char*		ifstat(double expr, char *thenpart, char *elsepart);
int		input(void);
void		label(char *s, int t, int nh)	/* text s of type t nh half-lines up */;
obj*		leftthing(int c)	/* called for {... or [... */ 		/* really ought to be separate functions */;
obj*		linegen(int type);
struct symtab*	lookup(char *s)	/* find s in symtab */;
int		main(int argc, char **argv);
void		makeattr(int type, int sub, YYSTYPE val)	/* add attribute type and val */;
obj*		makebetween(double f, obj *p1, obj* p2)	/* make position between p1 and p2 */;
void		makefattr(int type, int sub, double f)	/* double attr */;
void		makeiattr(int type, int i)	/* int attr */;
obj*		makenode(int type, int n);
void		makeoattr(int type, obj *o)	/* obj* attr */;
obj*		makepos(double x, double y)	/* make a position cell */;
void		maketattr(int sub, char *p)	/* text attribute: takes two */;
struct symtab*	makevar(char *s, int t, YYSTYPE v)	/* make variable named s in table */ 	/* assumes s is static or from tostring */;
void		makevattr(char *p)	/* varname attribute */;
obj*		movegen(void);
int		nextchar(void);
void		nextfor(void)	/* do one iteration of a for loop */;
void		pbstr(char *s);
void		popsrc(void)	/* restore an old one */;
void		print(void);
void		printexpr(double f)	/* print expression for debugging */;
void		printlf(int line, char *name);
void		printpos(obj *p)	/* print position for debugging */;
void		pushsrc(int type, char *ptr)	/* new input source */;
int		quadrant(double x, double y);
void		reset(void);
void		resetvar(void)	/* reset variables listed */;
obj*		rightthing(obj *p, int c)	/* called for ... ] or ... } */;
void		savetext(int t, char *s)	/* record text elements for current object */;
void		setdefaults(void)	/* set default sizes for variables like boxht */;
int		setdir(int n)	/* set direction (hvmode) from LEFT, RIGHT, etc. */;
void		setfval(char *s, double f)	/* set variable s to f */;
void		shell_exec(void)	/* do it */;
void		shell_init(void)	/* set up to interpret a shell command */;
void		shell_text(char *s)	/* add string to command being collected */;
void		space(double x0, double y0, double x1, double y1)	/* set limits of page */;
void		spline(double x, double y, double/*sic*/ n, float *p, int dashed, double ddval);
char*		sprintgen(char *fmt);
obj*		subpos(obj *p, obj *q);
obj*		textgen(void);
char*		tostring(char *s);
void		troff(char *s);
obj*		troffgen(char *s)	/* save away a string of troff commands */;
void		undefine(char *s)	/* undefine macro */;
int		unput(int c);
int		whatpos(obj *p, int corner, double *px, double *py)	/* what is the position (no side effect) */;
void		yyerror(char *s);
int		yyparse(void);

#include "tex.h"

