/*
	SuperCollider real time audio synthesis system
    Copyright (c) 2002 James McCartney. All rights reserved.
	http://www.audiosynth.com

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
*/


#ifndef _SC_OSC_Commands_
#define _SC_OSC_Commands_

// command numbers:
enum {
	cmd_none = 0,

	cmd_notify = 1,
	cmd_status = 2,
	cmd_quit = 3,
	cmd_cmd = 4,

	cmd_d_recv = 5,
	cmd_d_load = 6,
	cmd_d_loadDir = 7,
	cmd_d_freeAll = 8,

	cmd_s_new = 9,

	cmd_n_trace = 10,
	cmd_n_free = 11,
	cmd_n_run = 12,
	cmd_n_cmd = 13,
	cmd_n_map = 14,
	cmd_n_set = 15,
	cmd_n_setn = 16,
	cmd_n_fill = 17,
	cmd_n_before = 18,
	cmd_n_after = 19,

	cmd_u_cmd = 20,

	cmd_g_new = 21,
	cmd_g_head = 22,
	cmd_g_tail = 23,
	cmd_g_freeAll = 24,

	cmd_c_set = 25,
	cmd_c_setn = 26,
	cmd_c_fill = 27,

	cmd_b_alloc = 28,
	cmd_b_allocRead = 29,
	cmd_b_read = 30,
	cmd_b_write = 31,
	cmd_b_free = 32,
	cmd_b_close = 33,
	cmd_b_zero = 34,
	cmd_b_set = 35,
	cmd_b_setn = 36,
	cmd_b_fill = 37,
	cmd_b_gen = 38,

	cmd_dumpOSC = 39,

	cmd_c_get = 40,
	cmd_c_getn = 41,
	cmd_b_get = 42,
	cmd_b_getn = 43,
	cmd_s_get = 44,
	cmd_s_getn = 45,

	cmd_n_query = 46,
	cmd_b_query = 47,

	cmd_n_mapn = 48,
	cmd_s_noid = 49,

	cmd_g_deepFree = 50,
	cmd_clearSched = 51,

	cmd_sync = 52,

	cmd_d_free = 53,

	cmd_b_allocReadChannel = 54,
	cmd_b_readChannel = 55,

	cmd_g_dumpTree = 56,
	cmd_g_queryTree = 57,

	cmd_error = 58,

	cmd_s_newargs = 59,

	cmd_n_mapa = 60,
	cmd_n_mapan = 61,
	cmd_n_order = 62,

	cmd_p_new = 63,

	cmd_version = 64,

	NUMBER_OF_COMMANDS = 65
};

#endif /* _SC_OSC_Commands_ */
