/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.cache;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.jnlp.DownloadServiceListener;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import net.sourceforge.jnlp.cache.DownloadIndicator;
import net.sourceforge.jnlp.runtime.ApplicationInstance;
import net.sourceforge.jnlp.runtime.JNLPRuntime;
import net.sourceforge.jnlp.runtime.Translator;
import net.sourceforge.jnlp.util.ImageResources;
import net.sourceforge.jnlp.util.ScreenFinder;
import net.sourceforge.jnlp.util.logging.OutputController;

public class DefaultDownloadIndicator
implements DownloadIndicator {
    private static String downloading = Translator.R("CDownloading");
    private static String complete = Translator.R("CComplete");
    private static final int CLOSE_DELAY = 750;
    private static JDialog dialog;
    private static final Object dialogMutex;
    static GridBagConstraints vertical;
    static GridBagConstraints verticalNoClean;
    static GridBagConstraints verticalIndent;

    @Override
    public int getUpdateRate() {
        return 150;
    }

    @Override
    public int getInitialDelay() {
        return 300;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DownloadServiceListener getListener(ApplicationInstance app, String downloadName, URL[] resources) {
        DownloadPanel result = new DownloadPanel(downloadName);
        Object object = dialogMutex;
        synchronized (object) {
            if (dialog == null) {
                dialog = DefaultDownloadIndicator.createDownloadIndicatorWindow(true);
            }
            if (resources != null) {
                for (URL url : resources) {
                    result.addProgressPanel(url, null);
                }
            }
            dialog.getContentPane().add((Component)result, vertical);
            dialog.pack();
            DefaultDownloadIndicator.placeFrameToLowerRight();
            result.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    DefaultDownloadIndicator.placeFrameToLowerRight();
                }
            });
            dialog.setVisible(true);
            return result;
        }
    }

    public static JDialog createDownloadIndicatorWindow(boolean undecorated) throws HeadlessException {
        JDialog f = new JDialog((Frame)null, downloading + "...");
        f.setUndecorated(undecorated);
        f.setIconImages(ImageResources.INSTANCE.getApplicationImages());
        f.getContentPane().setLayout(new GridBagLayout());
        return f;
    }

    private static void placeFrameToLowerRight() throws HeadlessException {
        Rectangle bounds = ScreenFinder.getCurrentScreenSizeWithoutBounds();
        dialog.setLocation(bounds.width + bounds.x - dialog.getWidth(), bounds.height + bounds.y - dialog.getHeight());
    }

    @Override
    public void disposeListener(final DownloadServiceListener listener) {
        if (!(listener instanceof DownloadPanel)) {
            return;
        }
        ActionListener hider = new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent evt) {
                Object object = dialogMutex;
                synchronized (object) {
                    dialog.getContentPane().remove((DownloadPanel)listener);
                    dialog.pack();
                    if (dialog.getContentPane().getComponentCount() == 0) {
                        dialog.setVisible(false);
                        dialog.dispose();
                        dialog = null;
                    }
                }
            }
        };
        Timer timer = new Timer(750, hider);
        timer.setRepeats(false);
        timer.start();
    }

    static {
        dialogMutex = new Object();
        vertical = new GridBagConstraints();
        DefaultDownloadIndicator.vertical.gridwidth = 0;
        DefaultDownloadIndicator.vertical.weightx = 1.0;
        DefaultDownloadIndicator.vertical.fill = 2;
        DefaultDownloadIndicator.vertical.anchor = 17;
        verticalNoClean = new GridBagConstraints();
        DefaultDownloadIndicator.verticalNoClean.weightx = 1.0;
        verticalIndent = (GridBagConstraints)vertical.clone();
        DefaultDownloadIndicator.verticalIndent.insets = new Insets(0, 10, 3, 0);
    }

    static class ProgressPanel
    extends JPanel {
        private final JPanel bar = new JPanel();
        private long total;
        private long readSoFar;
        private final Dimension size = new Dimension(80, 15);

        ProgressPanel() {
            this.bar.setMinimumSize(this.size);
            this.bar.setPreferredSize(this.size);
            this.bar.setOpaque(false);
            this.setLayout(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            this.styleGridBagConstraints(gbc);
            this.add((Component)this.bar, gbc);
        }

        ProgressPanel(URL url, String version) {
            this(" " + url.getHost() + "/" + url.getFile(), version);
        }

        ProgressPanel(String caption, String version) {
            JLabel location = new JLabel(caption);
            this.bar.setMinimumSize(this.size);
            this.bar.setPreferredSize(this.size);
            this.bar.setOpaque(false);
            this.setLayout(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.weightx = 0.0;
            gbc.fill = 0;
            gbc.gridwidth = -1;
            this.add((Component)this.bar, gbc);
            this.styleGridBagConstraints(gbc);
            this.add((Component)location, gbc);
        }

        public void setProgress(long readSoFar, long total) {
            this.readSoFar = readSoFar;
            this.total = total;
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            int x = this.bar.getX();
            int y = this.bar.getY();
            int h = this.bar.getHeight();
            int w = this.bar.getWidth();
            if (this.readSoFar > 0L && this.total > 0L) {
                double progress = (double)this.readSoFar / (double)this.total;
                int divide = (int)((double)w * progress);
                g.setColor(Color.white);
                g.fillRect(x, y, w, h);
                g.setColor(Color.blue);
                g.fillRect(x + 1, y + 1, divide - 1, h - 1);
            }
        }

        private void styleGridBagConstraints(GridBagConstraints gbc) {
            gbc.insets = new Insets(0, 3, 0, 0);
            gbc.weightx = 1.0;
            gbc.fill = 2;
            gbc.gridwidth = 0;
            gbc.anchor = 17;
        }
    }

    static class DownloadPanel
    extends JPanel
    implements DownloadServiceListener {
        private final DownloadPanel self;
        private static final String DETAILS = Translator.R("ButShowDetails");
        private static final String HIDE_DETAILS = Translator.R("ButHideDetails");
        private String downloadName;
        private JLabel header = new JLabel();
        private final JButton detailsButton;
        private static final URL magnifyGlassUrl = ClassLoader.getSystemResource("net/sourceforge/jnlp/resources/showDownloadDetails.png");
        private static final URL redCrossUrl = ClassLoader.getSystemResource("net/sourceforge/jnlp/resources/hideDownloadDetails.png");
        private static final Icon magnifyGlassIcon = new ImageIcon(magnifyGlassUrl);
        private static final Icon redCrossIcon = new ImageIcon(redCrossUrl);
        private JLabel delimiter = new JLabel("");
        private List<ProgressPanel> progressPanels = new ArrayList<ProgressPanel>();
        private States state = States.ONE_JAR;
        private ProgressPanel mainProgressPanel;
        private List<URL> urls = new ArrayList<URL>();
        private List<ProgressPanel> panels = new ArrayList<ProgressPanel>();

        protected DownloadPanel(String downloadName) {
            this.self = this;
            this.setLayout(new GridBagLayout());
            this.downloadName = downloadName;
            this.add((Component)this.header, verticalNoClean);
            this.header.setFont(this.header.getFont().deriveFont(1));
            this.add((Component)this.delimiter, vertical);
            this.detailsButton = new JButton(magnifyGlassIcon);
            int w = magnifyGlassIcon.getIconWidth();
            int h = magnifyGlassIcon.getIconHeight();
            this.detailsButton.setPreferredSize(new Dimension(w + 2, h + 2));
            this.detailsButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (state == States.DETAILED) {
                        state = States.COLLAPSED;
                        detailsButton.setToolTipText(DETAILS);
                        detailsButton.setIcon(magnifyGlassIcon);
                        for (ProgressPanel progressPanel : progressPanels) {
                            this.remove(progressPanel);
                        }
                        this.add((Component)mainProgressPanel, verticalIndent);
                        this.recreateFrame(true);
                    } else {
                        state = States.DETAILED;
                        detailsButton.setToolTipText(HIDE_DETAILS);
                        detailsButton.setIcon(redCrossIcon);
                        this.remove(mainProgressPanel);
                        for (ProgressPanel progressPanel : progressPanels) {
                            this.add((Component)progressPanel, verticalIndent);
                        }
                        this.recreateFrame(false);
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void recreateFrame(boolean undecorated) throws HeadlessException {
                    JDialog oldFrame = dialog;
                    dialog = DefaultDownloadIndicator.createDownloadIndicatorWindow(undecorated);
                    dialog.getContentPane().add((Component)self, vertical);
                    Object object = dialogMutex;
                    synchronized (object) {
                        dialog.pack();
                        DefaultDownloadIndicator.placeFrameToLowerRight();
                    }
                    dialog.setVisible(true);
                    oldFrame.dispose();
                }
            });
            this.setOverallPercent(0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void addProgressPanel(URL url, String version) {
            if (!this.urls.contains(url)) {
                ProgressPanel panel = new ProgressPanel(url, version);
                if (this.state != States.COLLAPSED) {
                    this.add((Component)panel, verticalIndent);
                }
                this.progressPanels.add(panel);
                this.urls.add(url);
                this.panels.add(panel);
                if (this.panels.size() == 2) {
                    this.remove(this.panels.get(0));
                    this.remove(this.panels.get(1));
                    this.remove(this.delimiter);
                    this.add((Component)this.detailsButton, vertical);
                    this.mainProgressPanel = new ProgressPanel();
                    this.add((Component)this.mainProgressPanel, verticalIndent);
                    this.state = States.COLLAPSED;
                }
                Object object = dialogMutex;
                synchronized (object) {
                    dialog.pack();
                    DefaultDownloadIndicator.placeFrameToLowerRight();
                }
            }
        }

        protected void update(final URL url, final String version, final long readSoFar, final long total, final int overallPercent) {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    if (!urls.contains(url)) {
                        this.addProgressPanel(url, version);
                    }
                    this.setOverallPercent(overallPercent);
                    ProgressPanel panel = (ProgressPanel)panels.get(urls.indexOf(url));
                    panel.setProgress(readSoFar, total);
                    panel.repaint();
                }
            };
            SwingUtilities.invokeLater(r);
        }

        public void setOverallPercent(int percent) {
            String s = downloading + " " + this.downloadName + ": " + percent + "% " + complete + ".";
            if (JNLPRuntime.isHeadless()) {
                OutputController.getLogger().log(OutputController.Level.MESSAGE_ALL, s);
            }
            this.header.setText(s);
            for (Container c = this.header.getParent(); c != null; c = c.getParent()) {
                c.invalidate();
                c.validate();
                if (!(c instanceof Window)) continue;
                ((Window)c).pack();
            }
            if (this.mainProgressPanel != null) {
                this.mainProgressPanel.setProgress(percent, 100L);
                this.mainProgressPanel.repaint();
            }
        }

        @Override
        public void downloadFailed(URL url, String version) {
            this.update(url, version, -1L, -1L, -1);
        }

        @Override
        public void progress(URL url, String version, long readSoFar, long total, int overallPercent) {
            this.update(url, version, readSoFar, total, overallPercent);
        }

        @Override
        public void upgradingArchive(URL url, String version, int patchPercent, int overallPercent) {
            this.update(url, version, patchPercent, 100L, overallPercent);
        }

        @Override
        public void validating(URL url, String version, long entry, long total, int overallPercent) {
            this.update(url, version, entry, total, overallPercent);
        }

        private static enum States {
            ONE_JAR,
            COLLAPSED,
            DETAILED;

        }
    }
}

